DF-ISE text

Info {
  version   = 1.0
  type      = xyplot
  datasets  = [
    "time"
    "Source OuterVoltage" "Source InnerVoltage" "Source QuasiFermiPotential" "Source DisplacementCurrent" "Source eCurrent"
    "Source hCurrent" "Source TotalCurrent" "Source Charge" "Gate OuterVoltage" "Gate InnerVoltage"
    "Gate QuasiFermiPotential" "Gate DisplacementCurrent" "Gate eCurrent" "Gate hCurrent" "Gate TotalCurrent"
    "Gate Charge" "Drain OuterVoltage" "Drain InnerVoltage" "Drain QuasiFermiPotential" "Drain DisplacementCurrent"
    "Drain eCurrent" "Drain hCurrent" "Drain TotalCurrent" "Drain Charge" ]
  functions = [
    Time
    OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent eCurrent
    hCurrent TotalCurrent Charge OuterVoltage InnerVoltage
    QuasiFermiPotential DisplacementCurrent eCurrent hCurrent TotalCurrent
    Charge OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent
    eCurrent hCurrent TotalCurrent Charge ]
}

Data {
      5.00000000000000E-10
      0.00000000000000E+00  -1.22248100565334E-11   0.00000000000000E+00   1.97004180430131E-13   1.66478653341152E-22
      1.22247884333944E-08   1.22249854375750E-08  -7.89593879202807E-19  -2.50634423491831E-01  -2.50634423491827E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.48782128818100E-12   0.00000000000000E+00  -4.48782128818100E-12
      3.69848470502331E-18  -2.50634423491836E-01  -2.46784373370059E-01   0.00000000000000E+00  -1.99541794695583E-13
     -9.83531228655611E-23  -1.22202980744920E-08  -1.22204976162868E-08  -2.90889082582050E-18
      1.17500000000000E-09
      0.00000000000000E+00  -1.24273277020760E-11   0.00000000000000E+00   2.04427161679075E-13   1.68705730270729E-22
      1.24272869203152E-08   1.24274913474770E-08  -7.88042275316176E-19  -2.51349385892101E-01  -2.51349385892097E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.74581126241872E-12   0.00000000000000E+00  -4.74581126241872E-12
      3.69528128242117E-18  -2.51349385892236E-01  -2.47435620879905E-01   0.00000000000000E+00  -2.10079562739724E-13
     -9.83784494906420E-23  -1.24225354566518E-08  -1.24227455362146E-08  -2.90723900710500E-18
      2.08625000000000E-09
      0.00000000000000E+00  -1.26296616581442E-11   0.00000000000000E+00   3.87983792548841E-14   1.70156976924102E-22
      1.26295624594400E-08   1.26296012578195E-08  -7.86445318605375E-19  -2.52123214179518E-01  -2.52123214179513E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.58741381135012E-12   0.00000000000000E+00  -4.58741381135012E-12
      3.69110100158558E-18  -2.52123214179586E-01  -2.48145673396944E-01   0.00000000000000E+00  -4.56073444919198E-14
     -9.84147762134098E-23  -1.26249682366635E-08  -1.26250138440081E-08  -2.90465568298021E-18
      3.31643750000000E-09
      0.00000000000000E+00  -1.28223519168056E-11   0.00000000000000E+00   4.12064081219584E-14   1.70761867693833E-22
      1.28223332811149E-08   1.28223744875232E-08  -7.84873672107980E-19  -2.52920928691217E-01  -2.52920928691213E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.04893211397738E-12   0.00000000000000E+00  -4.04893211397738E-12
      3.68612005591062E-18  -2.52920928691175E-01  -2.48882486566384E-01   0.00000000000000E+00  -4.83428994168005E-14
     -9.84612107314570E-23  -1.28182772125097E-08  -1.28183255554093E-08  -2.90124638380264E-18
      4.97719062500000E-09
      0.00000000000000E+00  -1.29970406069743E-11   0.00000000000000E+00   4.12553402175756E-14   1.70644479835463E-22
      1.29970415742020E-08   1.29970828295424E-08  -7.83404424977116E-19  -2.53694847298143E-01  -2.53694847298140E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.23858909787183E-12   0.00000000000000E+00  -3.23858909787183E-12
      3.68074155894574E-18  -2.53694847297804E-01  -2.49601108705903E-01   0.00000000000000E+00  -4.76391225544129E-14
     -9.85141037697010E-23  -1.29937966013219E-08  -1.29938442404445E-08  -2.89733713396862E-18
      6.97719062500000E-09
      0.00000000000000E+00  -1.31351750917344E-11   0.00000000000000E+00   2.80387805706611E-14   1.70138745880662E-22
      1.31351596325701E-08   1.31351876713508E-08  -7.82213913563571E-19  -2.54337765695454E-01  -2.54337765695452E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.39854136239051E-12   0.00000000000000E+00  -2.39854136239051E-12
      3.67594447622096E-18  -2.54337765695302E-01  -2.50200248908109E-01   0.00000000000000E+00  -3.31145598865589E-14
     -9.85631196609229E-23  -1.31327560154285E-08  -1.31327891299885E-08  -2.89373056265738E-18
      8.97719062500000E-09
      0.00000000000000E+00  -1.32283975000001E-11   0.00000000000000E+00   2.31555018052327E-15   1.69614273526921E-22
      1.32283978850612E-08   1.32284002006115E-08  -7.81397129913189E-19  -2.54785260091229E-01  -2.54785260091228E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.74215348935456E-12   0.00000000000000E+00  -1.74215348935456E-12
      3.67246016924225E-18  -2.54785260091893E-01  -2.50618162198505E-01   0.00000000000000E+00  -6.12819709345861E-15
     -9.85996515410185E-23  -1.32266519189250E-08  -1.32266580471222E-08  -2.89106303932906E-18
      1.09771906250000E-08
      0.00000000000000E+00  -1.32924132818337E-11   0.00000000000000E+00   5.38147677990897E-15   1.69173897400690E-22
      1.32924171292792E-08   1.32924225107562E-08  -7.80830177509309E-19  -2.55098453554039E-01  -2.55098453554038E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.25172203176625E-12   0.00000000000000E+00  -1.25172203176625E-12
      3.66995672517871E-18  -2.55098453555926E-01  -2.50911032148499E-01   0.00000000000000E+00  -8.21532552269399E-15
     -9.86263676768052E-23  -1.32911625733988E-08  -1.32911707887244E-08  -2.88912654766941E-18
      1.29771906250000E-08
      0.00000000000000E+00  -1.33367742899050E-11   0.00000000000000E+00   2.81815852624457E-14   1.68833070229442E-22
      1.33368459663494E-08   1.33368741479348E-08  -7.80433914343488E-19  -2.55318391398503E-01  -2.55318391398502E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.93691096449561E-13   0.00000000000000E+00  -8.93691096449561E-13
      3.66816934298582E-18  -2.55318391402432E-01  -2.51116860053600E-01   0.00000000000000E+00  -3.03441030614045E-14
     -9.86456760765495E-23  -1.33359501127352E-08  -1.33359804568383E-08  -2.88773542864233E-18
      1.49771906250000E-08
      0.00000000000000E+00  -1.33679096558183E-11   0.00000000000000E+00   3.13500803311377E-15   1.68579623042772E-22
      1.33678979728072E-08   1.33679011078154E-08  -7.80155892438809E-19  -2.55473131267179E-01  -2.55473131267178E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.35614095256221E-13   0.00000000000000E+00  -6.35614095256221E-13
      3.66689811479530E-18  -2.55473131272522E-01  -2.51261735841128E-01   0.00000000000000E+00  -4.62750129788021E-15
     -9.86595674892642E-23  -1.33672608662187E-08  -1.33672654937201E-08  -2.88674222235649E-18
      1.69771906250000E-08
      0.00000000000000E+00  -1.33896768585365E-11   0.00000000000000E+00   1.41781659231320E-14   1.68394768570555E-22
      1.33896664695337E-08   1.33896806476998E-08  -7.79960314265224E-19  -2.55582154071525E-01  -2.55582154071525E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.51000305777763E-13   0.00000000000000E+00  -4.51000305777763E-13
      3.66599611418375E-18  -2.55582154077517E-01  -2.51363842400918E-01   0.00000000000000E+00  -1.53091804082093E-14
     -9.86694736755074E-23  -1.33892143382135E-08  -1.33892296473940E-08  -2.88603579991853E-18
      1.89771906250000E-08
      0.00000000000000E+00  -1.34050149296502E-11   0.00000000000000E+00   9.21351362789008E-16   1.68261746670115E-22
      1.34049783211606E-08   1.34049792425121E-08  -7.79822563201148E-19  -2.55659016338055E-01  -2.55659016338054E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.19514588115013E-13   0.00000000000000E+00  -3.19514588115013E-13
      3.66535708500752E-18  -2.55659016343921E-01  -2.51435839324982E-01   0.00000000000000E+00  -1.68213447842884E-15
     -9.86765494856407E-23  -1.34046580457894E-08  -1.34046597279240E-08  -2.88553452180637E-18
      2.09771906250000E-08
      0.00000000000000E+00  -1.34157607639034E-11   0.00000000000000E+00   3.40905562101194E-15   1.68166536994474E-22
      1.34157557151456E-08   1.34157591242014E-08  -7.79725436878206E-19  -2.55713239562096E-01  -2.55713239562095E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.26146917394286E-13   0.00000000000000E+00  -2.26146917394286E-13
      3.66490479117273E-18  -2.55713239565768E-01  -2.51486637758272E-01   0.00000000000000E+00  -3.96700096962896E-15
     -9.86815674123235E-23  -1.34155290102830E-08  -1.34155329772840E-08  -2.88517935429452E-18
      2.29771906250000E-08
      0.00000000000000E+00  -1.34233838770917E-11   0.00000000000000E+00   3.19458409084432E-16   1.68098762561015E-22
      1.34233533823371E-08   1.34233537017957E-08  -7.79656923336146E-19  -2.55751502376169E-01  -2.55751502376169E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.59957456996039E-13   0.00000000000000E+00  -1.59957456996039E-13
      3.66458487625874E-18  -2.55751502375263E-01  -2.51522486106709E-01   0.00000000000000E+00  -7.03340543918514E-16
     -9.86851336447131E-23  -1.34231930409981E-08  -1.34231937443387E-08  -2.88492795292259E-18
      2.49771906250000E-08
      0.00000000000000E+00  -1.34287108718497E-11   0.00000000000000E+00   8.93608769463539E-16   1.68050607442328E-22
      1.34287107439326E-08   1.34287116375415E-08  -7.79608572191177E-19  -2.55778510416503E-01  -2.55778510416503E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13093613152532E-13   0.00000000000000E+00  -1.13093613152532E-13
      3.66435868903243E-18  -2.55778510408073E-01  -2.51547791561605E-01   0.00000000000000E+00  -1.17017104731207E-15
     -9.86876582845567E-23  -1.34285973737572E-08  -1.34285985439284E-08  -2.88475011684126E-18
      2.69771906250000E-08
      0.00000000000000E+00  -1.34325683508124E-11   0.00000000000000E+00   7.17533902844528E-16   1.68016480532109E-22
      1.34324908544728E-08   1.34324915720068E-08  -7.79574442938043E-19  -2.55797576996662E-01  -2.55797576996662E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.99357576094473E-14   0.00000000000000E+00  -7.99357576094473E-14
      3.66419881751721E-18  -2.55797576977924E-01  -2.51565656778875E-01   0.00000000000000E+00  -9.18053454357321E-16
     -9.86894477306552E-23  -1.34324107181957E-08  -1.34324116362492E-08  -2.88462437457917E-18
      2.89771906250000E-08
      0.00000000000000E+00  -1.34351400034542E-11   0.00000000000000E+00   2.53449001277325E-16   1.67992291538701E-22
      1.34351587261564E-08   1.34351589796056E-08  -7.79550348544459E-19  -2.55811038651547E-01  -2.55811038651547E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.64883912083277E-14   0.00000000000000E+00  -5.64883912083277E-14
      3.66408584073480E-18  -2.55811038621497E-01  -2.51578270534670E-01   0.00000000000000E+00  -3.92018064047849E-16
     -9.86907133733441E-23  -1.34351020991962E-08  -1.34351024912144E-08  -2.88453549219034E-18
      3.09771906250000E-08
      0.00000000000000E+00  -1.34369768981984E-11   0.00000000000000E+00   2.01162543974952E-16   1.67975182368063E-22
      1.34370418296951E-08   1.34370420308578E-08  -7.79533336452647E-19  -2.55820544033794E-01  -2.55820544033794E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.99131669922630E-14   0.00000000000000E+00  -3.99131669922630E-14
      3.66400601440081E-18  -2.55820543993710E-01  -2.51587177421443E-01   0.00000000000000E+00  -2.99657852882848E-16
     -9.86916091416126E-23  -1.34370018180329E-08  -1.34370021176908E-08  -2.88447267794817E-18
      3.29771906250000E-08
      0.00000000000000E+00  -1.34383545692565E-11   0.00000000000000E+00   9.32089147254276E-16   1.67963089744884E-22
      1.34383711108532E-08   1.34383720429425E-08  -7.79521323043350E-19  -2.55827256630452E-01  -2.55827256630452E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.81988357609055E-14   0.00000000000000E+00  -2.81988357609055E-14
      3.66394961672929E-18  -2.55827256584720E-01  -2.51593467537748E-01   0.00000000000000E+00  -1.01232012415441E-15
     -9.86922424483070E-23  -1.34383428317865E-08  -1.34383438441067E-08  -2.88442829368594E-18
      3.49771906250000E-08
      0.00000000000000E+00  -1.34393648613658E-11   0.00000000000000E+00   6.14234405237507E-17   1.67954520542224E-22
      1.34393100580289E-08   1.34393101194525E-08  -7.79512840444489E-19  -2.55831996535267E-01  -2.55831996535267E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.99210021783002E-14   0.00000000000000E+00  -1.99210021783002E-14
      3.66390977472493E-18  -2.55831996497839E-01  -2.51597909032459E-01   0.00000000000000E+00  -1.11630021192949E-16
     -9.86926902120848E-23  -1.34392900868202E-08  -1.34392901984503E-08  -2.88439693428045E-18
      3.69771906250000E-08
      0.00000000000000E+00  -1.34399159297890E-11   0.00000000000000E+00   2.39570583033368E-16   1.67948472724107E-22
      1.34399727785666E-08   1.34399730181373E-08  -7.79506849931613E-19  -2.55835344043763E-01  -2.55835344043763E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.40726576224578E-14   0.00000000000000E+00  -1.40726576224578E-14
      3.66388162940969E-18  -2.55835344033628E-01  -2.51601045938158E-01   0.00000000000000E+00  -2.76697244066053E-16
     -9.86930067155805E-23  -1.34399586687823E-08  -1.34399589454797E-08  -2.88437477947808E-18
      3.89771906250000E-08
      0.00000000000000E+00  -1.34403751534750E-11   0.00000000000000E+00   2.10958481949426E-17   1.67944194176511E-22
      1.34404408730573E-08   1.34404408941534E-08  -7.79502619464712E-19  -2.55837708066259E-01  -2.55837708066259E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.94062782322511E-15   0.00000000000000E+00  -9.94062782322511E-15
      3.66386174815404E-18  -2.55837708104110E-01  -2.51603261235944E-01   0.00000000000000E+00  -4.57005565184507E-17
     -9.86932304076750E-23  -1.34404309078249E-08  -1.34404309535255E-08  -2.88435912868933E-18
      4.09771906250000E-08
      0.00000000000000E+00  -1.34407425324239E-11   0.00000000000000E+00   6.36680462436835E-17   1.67941173312200E-22
      1.34407713699422E-08   1.34407714336104E-08  -7.79499631694042E-19  -2.55839377687522E-01  -2.55839377687522E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.02173156580688E-15   0.00000000000000E+00  -7.02173156580688E-15
      3.66384770469091E-18  -2.55839377795048E-01  -2.51604825885626E-01   0.00000000000000E+00  -8.14662438762130E-17
     -9.86933884809053E-23  -1.34407643304125E-08  -1.34407644118789E-08  -2.88434807299687E-18
      4.29771906250000E-08
      0.00000000000000E+00  -1.34410180666355E-11   0.00000000000000E+00   8.15084539672778E-18   1.67939037863660E-22
      1.34410048001899E-08   1.34410048083409E-08  -7.79497521606200E-19  -2.55840556850287E-01  -2.55840556850287E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.95975841883071E-15   0.00000000000000E+00  -4.95975841883071E-15
      3.66383778517407E-18  -2.55840557042468E-01  -2.51605930942321E-01   0.00000000000000E+00  -2.03191367978487E-17
     -9.86935001777760E-23  -1.34409998282632E-08  -1.34409998485825E-08  -2.88434026356787E-18
      4.49771906250000E-08
      0.00000000000000E+00  -1.34412017561099E-11   0.00000000000000E+00   1.78856098297796E-17   1.67937529832432E-22
      1.34411696432380E-08   1.34411696611238E-08  -7.79496031293319E-19  -2.55841389674778E-01  -2.55841389674778E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.50329152165281E-15   0.00000000000000E+00  -3.50329152165281E-15
      3.66383077859103E-18  -2.55841389949932E-01  -2.51606711457842E-01   0.00000000000000E+00  -2.65798150482410E-17
     -9.86935790958298E-23  -1.34411661312524E-08  -1.34411661578323E-08  -2.88433474729771E-18
      4.69771906250000E-08
      0.00000000000000E+00  -1.34412936008471E-11   0.00000000000000E+00   3.47585103265430E-18   1.67936464269579E-22
      1.34412860769129E-08   1.34412860803889E-08  -7.79494978686247E-19  -2.55841977896917E-01  -2.55841977896917E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.47454741121151E-15   0.00000000000000E+00  -2.47454741121151E-15
      3.66382582949621E-18  -2.55841978225495E-01  -2.51607262727411E-01   0.00000000000000E+00  -9.52056285177899E-18
     -9.86936348513290E-23  -1.34412835963209E-08  -1.34412836058415E-08  -2.88433085080996E-18
      4.89771906250000E-08
      0.00000000000000E+00  -1.34413854455843E-11   0.00000000000000E+00   5.47296443094799E-18   1.67935711773383E-22
      1.34413683173641E-08   1.34413683228372E-08  -7.79494235152177E-19  -2.55842393398025E-01  -2.55842393398025E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.74800675542475E-15   0.00000000000000E+00  -1.74800675542475E-15
      3.66382233348270E-18  -2.55842393712931E-01  -2.51607652076463E-01   0.00000000000000E+00  -9.76560267202642E-18
     -9.86936742355023E-23  -1.34413665650648E-08  -1.34413665748305E-08  -2.88432809833052E-18
      5.09771906250000E-08
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00   1.59236836997739E-18   1.67935180254975E-22
      1.34414264208599E-08   1.34414264224524E-08  -7.79493709858634E-19  -2.55842686935608E-01  -2.55842686935608E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.23494910153943E-15   0.00000000000000E+00  -1.23494910153943E-15
      3.66381986358449E-18  -2.55842687126634E-01  -2.51607927023287E-01   0.00000000000000E+00  -4.59584678560687E-18
     -9.86937020489250E-23  -1.34414251829074E-08  -1.34414251875034E-08  -2.88432615372586E-18
      5.29771906250000E-08
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00   1.87355195234409E-18   1.67934804955318E-22
      1.34414674799166E-08   1.34414674817903E-08  -7.79493338649904E-19  -2.55842894362321E-01  -2.55842894362321E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.72699670546740E-16   0.00000000000000E+00  -8.72699670546740E-16
      3.66381811818515E-18  -2.55842894281430E-01  -2.51608121128486E-01   0.00000000000000E+00  -3.99834356066826E-18
     -9.86937216809775E-23  -1.34414666050922E-08  -1.34414666090907E-08  -2.88432477953525E-18
      5.49771906250000E-08
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00   7.60383334137824E-19   1.67934539928510E-22
      1.34414965041004E-08   1.34414965048610E-08  -7.79493076246001E-19  -2.55843040984354E-01  -2.55843040984354E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.16934593689279E-16   0.00000000000000E+00  -6.16934593689279E-16
      3.66381688431597E-18  -2.55843040466009E-01  -2.51608258088548E-01   0.00000000000000E+00  -2.25218451617935E-18
     -9.86937355284154E-23  -1.34414958856741E-08  -1.34414958879264E-08  -2.88432380806997E-18
      5.69771906250000E-08
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00   7.16885725563991E-19   1.67934352749075E-22
      1.34415170230365E-08   1.34415170237535E-08  -7.79492890715351E-19  -2.55843144651047E-01  -2.55843144651048E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.36292556315510E-16   0.00000000000000E+00  -4.36292556315510E-16
      3.66381601173085E-18  -2.55843143552996E-01  -2.51608354654228E-01   0.00000000000000E+00  -1.77648886035624E-18
     -9.86937452863095E-23  -1.34415165856844E-08  -1.34415165874610E-08  -2.88432312101550E-18
      5.89771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   3.69054823501372E-19   1.67934220412846E-22
      1.34415315210492E-08   1.34415315214185E-08  -7.79492759586676E-19  -2.55843217927427E-01  -2.55843217927427E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.08548723737740E-16   0.00000000000000E+00  -3.08548723737740E-16
      3.66381539463340E-18  -2.55843216192268E-01  -2.51608422685719E-01   0.00000000000000E+00  -1.10833859868711E-18
     -9.86937521584164E-23  -1.34415312117613E-08  -1.34415312128697E-08  -2.88432263504673E-18
      6.09771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   3.08011131146117E-19   1.67934126634200E-22
      1.34415417407205E-08   1.34415417410287E-08  -7.79492667089875E-19  -2.55843269635318E-01  -2.55843269635318E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.17940146569712E-16   0.00000000000000E+00  -2.17940146569712E-16
      3.66381495875311E-18  -2.55843267368655E-01  -2.51608470613898E-01   0.00000000000000E+00  -8.30106796518786E-19
     -9.86937570031684E-23  -1.34415415222583E-08  -1.34415415230885E-08  -2.88432229166324E-18
      6.29771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   1.80082367282191E-19   1.67934059864032E-22
      1.34415489014293E-08   1.34415489016096E-08  -7.79492602194906E-19  -2.55843305947535E-01  -2.55843305947535E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53291841969680E-16   0.00000000000000E+00  -1.53291841969680E-16
      3.66381465216943E-18  -2.55843303498843E-01  -2.51608504467771E-01   0.00000000000000E+00  -5.49691335393295E-19
     -9.86937604382725E-23  -1.34415487477680E-08  -1.34415487483177E-08  -2.88432204997452E-18
      6.49771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   1.37780833212532E-19   1.67934011961427E-22
      1.34415538564768E-08   1.34415538566148E-08  -7.79492557193593E-19  -2.55843331177409E-01  -2.55843331177409E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06729140908775E-16   0.00000000000000E+00  -1.06729140908775E-16
      3.66381443871114E-18  -2.55843329200115E-01  -2.51608528593310E-01   0.00000000000000E+00  -4.04827327020721E-19
     -9.86937629113655E-23  -1.34415537494807E-08  -1.34415537498856E-08  -2.88432188151755E-18
      6.69771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   8.27998120825647E-20   1.67933977260958E-22
      1.34415572096373E-08   1.34415572097203E-08  -7.79492526655653E-19  -2.55843348358213E-01  -2.55843348358213E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.28001393571599E-17   0.00000000000000E+00  -7.28001393571599E-17
      3.66381429311087E-18  -2.55843347814926E-01  -2.51608546141038E-01   0.00000000000000E+00  -2.85190614841698E-19
     -9.86937647476812E-23  -1.34415571366349E-08  -1.34415571369201E-08  -2.88432176645521E-18
      6.89771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   6.02005878500195E-20   1.67933951951108E-22
      1.34415594031571E-08   1.34415594032175E-08  -7.79492506637420E-19  -2.55843359680746E-01  -2.55843359680746E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.78876240839158E-17   0.00000000000000E+00  -4.78876240839158E-17
      3.66381419733562E-18  -2.55843361753560E-01  -2.51608559380771E-01   0.00000000000000E+00  -2.19282154625427E-19
     -9.86937661783051E-23  -1.34415593551105E-08  -1.34415593553298E-08  -2.88432169069820E-18
      7.09771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   3.46587277195892E-20   1.67933933639920E-22
      1.34415607853808E-08   1.34415607854156E-08  -7.79492494072433E-19  -2.55843366829862E-01  -2.55843366829862E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.98042738596616E-17   0.00000000000000E+00  -2.98042738596616E-17
      3.66381413772707E-18  -2.55843372697482E-01  -2.51608569883539E-01   0.00000000000000E+00  -1.67474205765709E-19
     -9.86937673549682E-23  -1.34415607554438E-08  -1.34415607556113E-08  -2.88432164365464E-18
      7.29771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   2.28040565635353E-20   1.67933921034221E-22
      1.34415616611189E-08   1.34415616611419E-08  -7.79492486308522E-19  -2.55843371241259E-01  -2.55843371241259E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.74847915190260E-17   0.00000000000000E+00  -1.74847915190260E-17
      3.66381410275749E-18  -2.55843381700444E-01  -2.51608578606729E-01   0.00000000000000E+00  -1.39461555642710E-19
     -9.86937683546651E-23  -1.34415616435175E-08  -1.34415616436571E-08  -2.88432161644896E-18
      7.49771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   1.77198254907446E-20   1.67933913651715E-22
      1.34415623245646E-08   1.34415623245825E-08  -7.79492480792079E-19  -2.55843374280355E-01  -2.55843374280355E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06933859573533E-17   0.00000000000000E+00  -1.06933859573533E-17
      3.66381408137072E-18  -2.55843389222967E-01  -2.51608585918101E-01   0.00000000000000E+00  -1.13281423338034E-19
     -9.86937691797404E-23  -1.34415623137758E-08  -1.34415623138891E-08  -2.88432160057864E-18
      7.69771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   1.85702454363732E-20   1.67933911505772E-22
      1.34415630714971E-08   1.34415630715158E-08  -7.79492474925388E-19  -2.55843377330977E-01  -2.55843377330977E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.67886795314669E-18   0.00000000000000E+00  -9.67886795314669E-18
      3.66381406201298E-18  -2.55843395141965E-01  -2.51608591601462E-01   0.00000000000000E+00  -8.43451988654813E-20
     -9.86937697589355E-23  -1.34415630617525E-08  -1.34415630618370E-08  -2.88432158708759E-18
      7.89771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   2.89014761306880E-20   1.67933914714865E-22
      1.34415641861929E-08   1.34415641862219E-08  -7.79492466139480E-19  -2.55843381771934E-01  -2.55843381771934E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.47268185157932E-17   0.00000000000000E+00  -1.47268185157932E-17
      3.66381403255934E-18  -2.55843398784757E-01  -2.51608594894654E-01   0.00000000000000E+00  -4.28593363995870E-20
     -9.86937699568937E-23  -1.34415641714522E-08  -1.34415641714951E-08  -2.88432156641987E-18
      8.09771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   4.37207295058045E-20   1.67933923019916E-22
      1.34415658992902E-08   1.34415658993341E-08  -7.79492452221906E-19  -2.55843388819740E-01  -2.55843388819740E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.55935573313625E-17   0.00000000000000E+00  -2.55935573313625E-17
      3.66381398137223E-18  -2.55843399043451E-01  -2.51608594617046E-01   0.00000000000000E+00   1.49582467425740E-20
     -9.86937695993597E-23  -1.34415658737554E-08  -1.34415658737405E-08  -2.88432152915032E-18
      8.29771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   5.82327343844357E-20   1.67933935234826E-22
      1.34415683164494E-08   1.34415683165078E-08  -7.79492431911818E-19  -2.55843399228402E-01  -2.55843399228402E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.08578393599064E-17   0.00000000000000E+00  -4.08578393599064E-17
      3.66381389965655E-18  -2.55843394624536E-01  -2.51608589441392E-01   0.00000000000000E+00   9.04225009715546E-20
     -9.86937685206764E-23  -1.34415682757403E-08  -1.34415682756500E-08  -2.88432146774473E-18
      8.49771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   7.55904455757513E-20   1.67933948714016E-22
      1.34415713249749E-08   1.34415713250506E-08  -7.79492405716205E-19  -2.55843412866247E-01  -2.55843412866247E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.72961227916465E-17   0.00000000000000E+00  -5.72961227916465E-17
      3.66381378506431E-18  -2.55843384473993E-01  -2.51608578348157E-01   0.00000000000000E+00   1.79308759460683E-19
     -9.86937666361823E-23  -1.34415712679337E-08  -1.34415712677545E-08  -2.88432137934810E-18
      8.69771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   7.81471919929317E-20   1.67933958987285E-22
      1.34415744961836E-08   1.34415744962619E-08  -7.79492376811062E-19  -2.55843428235831E-01  -2.55843428235831E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.94672980294935E-17   0.00000000000000E+00  -6.94672980294935E-17
      3.66381364612971E-18  -2.55843368382938E-01  -2.51608561261811E-01   0.00000000000000E+00   2.68350471058152E-19
     -9.86937640358619E-23  -1.34415744270629E-08  -1.34415744267946E-08  -2.88432126931865E-18
      8.89771906250000E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   6.43557579929621E-20   1.67933959773744E-22
      1.34415770139902E-08   1.34415770140547E-08  -7.79492351777865E-19  -2.55843442062329E-01  -2.55843442062329E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.97642588290675E-17   0.00000000000000E+00  -6.97642588290675E-17
      3.66381350660119E-18  -2.55843347720118E-01  -2.51608539805817E-01   0.00000000000000E+00   3.23616794363428E-19
     -9.86937610851181E-23  -1.34415769446140E-08  -1.34415769442905E-08  -2.88432115482333E-18
      9.09771906250001E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   1.77417718119221E-20   1.67933943621408E-22
      1.34415776728485E-08   1.34415776728664E-08  -7.79492340808513E-19  -2.55843449138762E-01  -2.55843449138762E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.92303588947101E-17   0.00000000000000E+00  -4.92303588947101E-17
      3.66381340814047E-18  -2.55843326155056E-01  -2.51608518026700E-01   0.00000000000000E+00   3.10050310155528E-19
     -9.86937585068242E-23  -1.34415776239460E-08  -1.34415776236360E-08  -2.88432106733196E-18
      9.29771906250001E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -5.95440270747922E-20   1.67933903397282E-22
      1.34415749955381E-08   1.34415749954787E-08  -7.79492356928743E-19  -2.55843442664176E-01  -2.55843442664176E-01
      0.00000000000000E+00   0.00000000000000E+00   5.93894797786399E-19   0.00000000000000E+00   5.93894797786399E-19
      3.66381340932826E-18  -2.55843310141016E-01  -2.51608502840474E-01   0.00000000000000E+00   1.79274011118819E-19
     -9.86937574052812E-23  -1.34415749962517E-08  -1.34415749960726E-08  -2.88432105239952E-18
      9.49771906250001E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -1.81322334428720E-19   1.67933834742463E-22
      1.34415675184890E-08   1.34415675183078E-08  -7.79492413789687E-19  -2.55843415317910E-01  -2.55843415317910E-01
      0.00000000000000E+00   0.00000000000000E+00   8.46653315610369E-17   0.00000000000000E+00   8.46653315610369E-17
      3.66381357865892E-18  -2.55843308838695E-01  -2.51608503867390E-01   0.00000000000000E+00  -9.19441125731956E-20
     -9.86937591846204E-23  -1.34415676028811E-08  -1.34415676029732E-08  -2.88432116486924E-18
      9.69771906250001E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -2.94119109840750E-19   1.67933739382877E-22
      1.34415542719766E-08   1.34415542716827E-08  -7.79492521719079E-19  -2.55843361248232E-01  -2.55843361248232E-01
      0.00000000000000E+00   0.00000000000000E+00   2.00422800609455E-16   0.00000000000000E+00   2.00422800609455E-16
      3.66381397950453E-18  -2.55843333114875E-01  -2.51608532280562E-01   0.00000000000000E+00  -5.57039695267566E-19
     -9.86937653132338E-23  -1.34415544715483E-08  -1.34415544721055E-08  -2.88432145778545E-18
      9.89771906250001E-08
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -4.59733364886665E-19   1.67933628835031E-22
      1.34415354394714E-08   1.34415354390119E-08  -7.79492682065724E-19  -2.55843278985372E-01  -2.55843278985372E-01
      0.00000000000000E+00   0.00000000000000E+00   3.33339394524928E-16   0.00000000000000E+00   3.33339394524928E-16
      3.66381464618332E-18  -2.55843393287083E-01  -2.51608598344295E-01   0.00000000000000E+00  -1.11292537981321E-18
     -9.86937769013950E-23  -1.34415357712382E-08  -1.34415357723513E-08  -2.88432196411759E-18
      1.00977190625000E-07
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00  -5.10798796546544E-19   1.67933527603334E-22
      1.34415131119894E-08   1.34415131114787E-08  -7.79492880436144E-19  -2.55843175002317E-01  -2.55843175002317E-01
      0.00000000000000E+00   0.00000000000000E+00   4.53154815613644E-16   0.00000000000000E+00   4.53154815613644E-16
      3.66381555249295E-18  -2.55843495453149E-01  -2.51608707507154E-01   0.00000000000000E+00  -1.78179438350090E-18
     -9.86937940962623E-23  -1.34415135628517E-08  -1.34415135646336E-08  -2.88432267205680E-18
      1.02977190625000E-07
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00  -5.26951288933194E-19   1.67933474482150E-22
      1.34414919638884E-08   1.34414919633616E-08  -7.79493080204437E-19  -2.55843067241919E-01  -2.55843067241919E-01
      0.00000000000000E+00   0.00000000000000E+00   5.12479009736092E-16   0.00000000000000E+00   5.12479009736092E-16
      3.66381657745097E-18  -2.55843636583427E-01  -2.51608855281718E-01   0.00000000000000E+00  -2.26573271178627E-18
     -9.86938153572972E-23  -1.34414924735748E-08  -1.34414924758406E-08  -2.88432349724653E-18
      1.04977190625000E-07
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00  -3.05203830895493E-19   1.67933520221383E-22
      1.34414795789988E-08   1.34414795786938E-08  -7.79493218553575E-19  -2.55842987463590E-01  -2.55842987463590E-01
      0.00000000000000E+00   0.00000000000000E+00   4.49872248712344E-16   0.00000000000000E+00   4.49872248712344E-16
      3.66381747719546E-18  -2.55843799071240E-01  -2.51609021691294E-01   0.00000000000000E+00  -2.44351620192511E-18
     -9.86938367622044E-23  -1.34414800261224E-08  -1.34414800285660E-08  -2.88432425864189E-18
      1.06977190625000E-07
      0.00000000000000E+00  -1.34414772903215E-11   0.00000000000000E+00   2.04007515085877E-19   1.67933719732476E-22
      1.34414860776869E-08   1.34414860778911E-08  -7.79493208094472E-19  -2.55842980829275E-01  -2.55842980829275E-01
      0.00000000000000E+00   0.00000000000000E+00   1.99577632480595E-16   0.00000000000000E+00   1.99577632480595E-16
      3.66381787635073E-18  -2.55843946101707E-01  -2.51609166753180E-01   0.00000000000000E+00  -2.00387103635627E-18
     -9.86938515824117E-23  -1.34414862754648E-08  -1.34414862774687E-08  -2.88432466825626E-18
      1.08977190625000E-07
      0.00000000000000E+00  -1.34415691350587E-11   0.00000000000000E+00   1.41541152460289E-18   1.67934117487725E-22
      1.34415226715941E-08   1.34415226730097E-08  -7.79492947466536E-19  -2.55843100920476E-01  -2.55843100920476E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.90527803294771E-16   0.00000000000000E+00  -2.90527803294771E-16
      3.66381729529512E-18  -2.55844019891029E-01  -2.51609229167631E-01   0.00000000000000E+00  -1.01968460543045E-18
     -9.86938504577297E-23  -1.34415223814621E-08  -1.34415223824819E-08  -2.88432434782859E-18
      1.10977190625000E-07
      0.00000000000000E+00  -1.34416609797960E-11   0.00000000000000E+00   2.17061186922263E-18   1.67934725977427E-22
      1.34415988540772E-08   1.34415988562480E-08  -7.79492343857616E-19  -2.55843398561167E-01  -2.55843398561167E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03270342198431E-15   0.00000000000000E+00  -1.03270342198431E-15
      3.66381522988828E-18  -2.55843945378581E-01  -2.51609130886881E-01   0.00000000000000E+00   1.83669127706636E-18
     -9.86938225320347E-23  -1.34415978253811E-08  -1.34415978235446E-08  -2.88432288603066E-18
      1.12977190625000E-07
      0.00000000000000E+00  -1.34417528245332E-11   0.00000000000000E+00   5.13440950730307E-18   1.67935499235609E-22
      1.34417181604508E-08   1.34417181655854E-08  -7.79491348631250E-19  -2.55843903661082E-01  -2.55843903661082E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.96739050613762E-15   0.00000000000000E+00  -1.96739050613762E-15
      3.66381129510727E-18  -2.55843642032101E-01  -2.51608790246043E-01   0.00000000000000E+00   3.71998008057287E-18
     -9.86937578651153E-23  -1.34417162019147E-08  -1.34417161981949E-08  -2.88431994647602E-18
      1.14977190625000E-07
      0.00000000000000E+00  -1.34419365140076E-11   0.00000000000000E+00   4.17536075842599E-18   1.67936306356924E-22
      1.34418728528177E-08   1.34418728569932E-08  -7.79490003926051E-19  -2.55844600957258E-01  -2.55844600957259E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.93170893779831E-15   0.00000000000000E+00  -2.93170893779831E-15
      3.66380543168939E-18  -2.55843045694118E-01  -2.51608145474217E-01   0.00000000000000E+00   1.01529442676490E-17
     -9.86936512513545E-23  -1.34418699354371E-08  -1.34418699252842E-08  -2.88431542776334E-18
      1.16977190625000E-07
      0.00000000000000E+00  -1.34420283587448E-11   0.00000000000000E+00   5.76782788684868E-18   1.67936913593128E-22
      1.34420384517602E-08   1.34420384575282E-08  -7.79488493053316E-19  -2.55845403113477E-01  -2.55845403113477E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.63873212618652E-15   0.00000000000000E+00  -3.63873212618652E-15
      3.66379815422514E-18  -2.55842140588206E-01  -2.51607188417079E-01   0.00000000000000E+00   1.32288400565839E-17
     -9.86935072076745E-23  -1.34420348320248E-08  -1.34420348187961E-08  -2.88430966117182E-18
      1.18977190625000E-07
      0.00000000000000E+00  -1.34422120482192E-11   0.00000000000000E+00   3.30823051808074E-18   1.67936986522727E-22
      1.34421697820616E-08   1.34421697853700E-08  -7.79487181296477E-19  -2.55846127895533E-01  -2.55846127895533E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.68184988958446E-15   0.00000000000000E+00  -3.68184988958446E-15
      3.66379079052536E-18  -2.55840998374543E-01  -2.51606004839653E-01   0.00000000000000E+00   1.77190171345812E-17
     -9.86933453769170E-23  -1.34421661212390E-08  -1.34421661035201E-08  -2.88430360922888E-18
      1.20977190625000E-07
      0.00000000000000E+00  -1.34422120482192E-11   0.00000000000000E+00   2.52418356313326E-18   1.67936126068470E-22
      1.34422008219881E-08   1.34422008245125E-08  -7.79486627343628E-19  -2.55846489574601E-01  -2.55846489574601E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.58027379813773E-15   0.00000000000000E+00  -2.58027379813773E-15
      3.66378562997776E-18  -2.55839816800776E-01  -2.51604813139025E-01   0.00000000000000E+00   1.51360668099148E-17
     -9.86932048922235E-23  -1.34421982593747E-08  -1.34421982442387E-08  -2.88429900263413E-18
      1.22977190625000E-07
      0.00000000000000E+00  -1.34420283587448E-11   0.00000000000000E+00   9.01721300241211E-19   1.67933950270714E-22
      1.34420511164551E-08   1.34420511173570E-08  -7.79487541068024E-19  -2.55846117296341E-01  -2.55846117296341E-01
      0.00000000000000E+00   0.00000000000000E+00   1.19690503008207E-16   0.00000000000000E+00   1.19690503008207E-16
      3.66378586935877E-18  -2.55838945278239E-01  -2.51603987931928E-01   0.00000000000000E+00   5.40289897172868E-18
     -9.86931456076004E-23  -1.34420512424503E-08  -1.34420512370475E-08  -2.88429832829074E-18
      1.24977190625000E-07
      0.00000000000000E+00  -1.34416609797960E-11   0.00000000000000E+00   3.58471959946156E-17   1.67930228332269E-22
      1.34416412996160E-08   1.34416413354633E-08  -7.79490663236218E-19  -2.55844613598466E-01  -2.55844613598467E-01
      0.00000000000000E+00   0.00000000000000E+00   4.68067238393887E-15   0.00000000000000E+00   4.68067238393887E-15
      3.66379523070354E-18  -2.55838880058596E-01  -2.51604050392474E-01   0.00000000000000E+00  -5.10590836864786E-17
     -9.86932435615776E-23  -1.34416459650765E-08  -1.34416460161357E-08  -2.88430456746732E-18
      1.26977190625000E-07
      0.00000000000000E+00  -1.34409262218983E-11   0.00000000000000E+00   4.09222077836518E-19   1.67925060073762E-22
      1.34409192284773E-08   1.34409192288867E-08  -7.79496551120104E-19  -2.55841662403542E-01  -2.55841662403542E-01
      0.00000000000000E+00   0.00000000000000E+00   1.09563106361561E-14   0.00000000000000E+00   1.09563106361561E-14
      3.66381714332481E-18  -2.55840209073972E-01  -2.51605604927326E-01   0.00000000000000E+00  -4.73468378552607E-17
     -9.86935781001579E-23  -1.34409301378504E-08  -1.34409301851974E-08  -2.88432059220471E-18
      1.28977190625000E-07
      0.00000000000000E+00  -1.34399159297890E-11   0.00000000000000E+00   1.08707930709406E-16   1.67919077955779E-22
      1.34398956544371E-08   1.34398957631452E-08  -7.79505271046766E-19  -2.55837187387546E-01  -2.55837187387546E-01
      0.00000000000000E+00   0.00000000000000E+00   1.81498440705156E-14   0.00000000000000E+00   1.81498440705156E-14
      3.66385344301295E-18  -2.55843488947214E-01  -2.51609205023065E-01   0.00000000000000E+00  -1.96200098524956E-16
     -9.86942088809857E-23  -1.34399137167891E-08  -1.34399139129893E-08  -2.88434817196618E-18
      1.30977190625000E-07
      0.00000000000000E+00  -1.34386301034681E-11   0.00000000000000E+00  -1.77821073213862E-17   1.67913617232920E-22
      1.34386853013367E-08   1.34386852835548E-08  -7.79516032370520E-19  -2.55831544755398E-01  -2.55831544755399E-01
      0.00000000000000E+00   0.00000000000000E+00   2.46107802156556E-14   0.00000000000000E+00   2.46107802156556E-14
      3.66390266457338E-18  -2.55849044971967E-01  -2.51615140348663E-01   0.00000000000000E+00  -1.07660794913903E-16
     -9.86951429459188E-23  -1.34387097866741E-08  -1.34387098943350E-08  -2.88438663220286E-18
      1.32977190625000E-07
      0.00000000000000E+00  -1.34375279666216E-11   0.00000000000000E+00   1.57551030336488E-17   1.67910789086820E-22
      1.34375428841766E-08   1.34375428999319E-08  -7.79526836447648E-19  -2.55825714093459E-01  -2.55825714093459E-01
      0.00000000000000E+00   0.00000000000000E+00   2.77623012429246E-14   0.00000000000000E+00   2.77623012429246E-14
      3.66395818917587E-18  -2.55856705177176E-01  -2.51623159493843E-01   0.00000000000000E+00  -1.70741616126399E-16
     -9.86962955467346E-23  -1.34375704914914E-08  -1.34375706622332E-08  -2.88443135272822E-18
      1.34977190625000E-07
      0.00000000000000E+00  -1.34368850534612E-11   0.00000000000000E+00   2.72371585755903E-18   1.67913347490888E-22
      1.34368808144397E-08   1.34368808171636E-08  -7.79534264856452E-19  -2.55821424152115E-01  -2.55821424152115E-01
      0.00000000000000E+00   0.00000000000000E+00   2.42699422459975E-14   0.00000000000000E+00   2.42699422459975E-14
      3.66400672906036E-18  -2.55865505050135E-01  -2.51632169061823E-01   0.00000000000000E+00  -1.51455724931609E-16
     -9.86974525220422E-23  -1.34369049356500E-08  -1.34369050871058E-08  -2.88447246420391E-18
      1.36977190625000E-07
      0.00000000000000E+00  -1.34372524324100E-11   0.00000000000000E+00   3.44052155220512E-16   1.67924267466705E-22
      1.34372481112373E-08   1.34372484552896E-08  -7.79533571718464E-19  -2.55821128149489E-01  -2.55821128149489E-01
      0.00000000000000E+00   0.00000000000000E+00   1.05751341295248E-14   0.00000000000000E+00   1.05751341295248E-14
      3.66402787932862E-18  -2.55873438195918E-01  -2.51639990803619E-01   0.00000000000000E+00  -4.40016667407159E-16
     -9.86982477530160E-23  -1.34372585904070E-08  -1.34372590304237E-08  -2.88449430761016E-18
      1.38977190625000E-07
      0.00000000000000E+00  -1.34391811718914E-11   0.00000000000000E+00   4.59942268260233E-16   1.67945944270845E-22
      1.34392516670097E-08   1.34392521269521E-08  -7.79519268447016E-19  -2.55827728531734E-01  -2.55827728531734E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.61239460908022E-14   0.00000000000000E+00  -1.61239460908022E-14
      3.66399563143644E-18  -2.55877363425075E-01  -2.51643293204073E-01   0.00000000000000E+00  -4.38624442170881E-16
     -9.86981731563014E-23  -1.34392355643815E-08  -1.34392360030060E-08  -2.88447636298942E-18
      1.40977190625000E-07
      0.00000000000000E+00  -1.34434060298029E-11   0.00000000000000E+00   3.22332199372784E-16   1.67979019458574E-22
      1.34434034688965E-08   1.34434037912289E-08  -7.79486347605839E-19  -2.55843969178928E-01  -2.55843969178928E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.64574858833472E-14   0.00000000000000E+00  -5.64574858833472E-14
      3.66388271646467E-18  -2.55873208215827E-01  -2.51637842631325E-01   0.00000000000000E+00  -1.05385938019087E-16
     -9.86966405212755E-23  -1.34433472283570E-08  -1.34433473337430E-08  -2.88439636885883E-18
      1.42977190625000E-07
      0.00000000000000E+00  -1.34498351614074E-11   0.00000000000000E+00   1.27255756515609E-15   1.68020953660627E-22
      1.34498901574833E-08   1.34498914300411E-08  -7.79432223903776E-19  -2.55871446090512E-01  -2.55871446090512E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07140150875496E-13   0.00000000000000E+00  -1.07140150875496E-13
      3.66366843616292E-18  -2.55856613142876E-01  -2.51619219820526E-01   0.00000000000000E+00  -8.04984696358078E-16
     -9.86931139601547E-23  -1.34497834849054E-08  -1.34497842898902E-08  -2.88423621225914E-18
      1.44977190625000E-07
      0.00000000000000E+00  -1.34582848772305E-11   0.00000000000000E+00   6.53298686849494E-16   1.68064570512995E-22
      1.34582859840686E-08   1.34582866373675E-08  -7.79359258304836E-19  -2.55909292449378E-01  -2.55909292449378E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.59285428663686E-13   0.00000000000000E+00  -1.59285428663686E-13
      3.66334986530559E-18  -2.55824118412007E-01  -2.51584096314410E-01   0.00000000000000E+00   1.17364561997152E-16
     -9.86873140894748E-23  -1.34581274693033E-08  -1.34581273519388E-08  -2.88399060700075E-18
      1.46977190625000E-07
      0.00000000000000E+00  -1.34672856614769E-11   0.00000000000000E+00   2.42239734849900E-16   1.68097149701726E-22
      1.34672539466763E-08   1.34672541889162E-08  -7.79277478891167E-19  -2.55952726118203E-01  -2.55952726118203E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.97282036329801E-13   0.00000000000000E+00  -1.97282036329801E-13
      3.66295530123293E-18  -2.55774905848601E-01  -2.51532070254811E-01   0.00000000000000E+00   7.91015506300871E-16
     -9.86794954004484E-23  -1.34670576978953E-08  -1.34670569068799E-08  -2.88367782234176E-18
      1.48977190625000E-07
      0.00000000000000E+00  -1.34743577062418E-11   0.00000000000000E+00   2.06749245215403E-16   1.68100548361730E-22
      1.34743320729955E-08   1.34743322797449E-08  -7.79206769151551E-19  -2.55991823146267E-01  -2.55991823146267E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.99061274770579E-13   0.00000000000000E+00  -1.99061274770579E-13
      3.66255717868339E-18  -2.55712921838600E-01  -2.51467856747943E-01   0.00000000000000E+00   9.24243128943264E-16
     -9.86707281905955E-23  -1.34741341427132E-08  -1.34741332184702E-08  -2.88335040953184E-18
      1.50977190625000E-07
      0.00000000000000E+00  -1.34759190667744E-11   0.00000000000000E+00   4.82609624846874E-17   1.68053215683139E-22
      1.34759270043549E-08   1.34759270526161E-08  -7.79177469058108E-19  -2.56011062731914E-01  -2.56011062731914E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.38566584207717E-13   0.00000000000000E+00  -1.38566584207717E-13
      3.66228004551498E-18  -2.55648974535595E-01  -2.51403387866849E-01   0.00000000000000E+00   9.04250441844070E-16
     -9.86631487327134E-23  -1.34757893902822E-08  -1.34757884860319E-08  -2.88310257645687E-18
      1.51477190625000E-07
      0.00000000000000E+00  -1.34759190667744E-11   0.00000000000000E+00  -1.39137847405342E-19   1.68040363124334E-22
      1.34759223086233E-08   1.34759223084844E-08  -7.79173248056078E-19  -2.56014366558035E-01  -2.56014366558035E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19127977782208E-13   0.00000000000000E+00  -1.19127977782208E-13
      3.66222048152608E-18  -2.55633062799805E-01  -2.51387471481676E-01   0.00000000000000E+00   8.85615983300792E-16
     -9.86794639391171E-23  -1.34758040661225E-08  -1.34758031805066E-08  -2.88304723347000E-18
      1.52152190625000E-07
      0.00000000000000E+00  -1.34750006194023E-11   0.00000000000000E+00  -6.61617353935406E-17   1.68013071155719E-22
      1.34750181374447E-08   1.34750180712832E-08  -7.79174608029440E-19  -2.56015357891334E-01  -2.56015357891334E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.39666722066993E-14   0.00000000000000E+00  -8.39666722066993E-14
      3.66216380402234E-18  -2.55612309629706E-01  -2.51366992096583E-01   0.00000000000000E+00   8.18400711101405E-16
     -9.86429870936626E-23  -1.34749349230116E-08  -1.34749341046109E-08  -2.88298919599290E-18
      1.53063440625000E-07
      0.00000000000000E+00  -1.34716942088628E-11   0.00000000000000E+00   1.96296574552852E-16   1.67959825461372E-22
      1.34717216426754E-08   1.34717218389721E-08  -7.79193160379903E-19  -2.56008367180600E-01  -2.56008367180600E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.76726886422764E-14   0.00000000000000E+00  -1.76726886422764E-14
      3.66214769978482E-18  -2.55587450850767E-01  -2.51343151020091E-01   0.00000000000000E+00   2.81681388941113E-16
     -9.86774773460625E-23  -1.34717044479648E-08  -1.34717041662835E-08  -2.88295453940492E-18
      1.54293628125000E-07
      0.00000000000000E+00  -1.34623260456676E-11   0.00000000000000E+00   1.80275863423862E-15   1.67854845764716E-22
      1.34623300702432E-08   1.34623318730020E-08  -7.79259112929526E-19  -2.55978241005200E-01  -2.55978241005200E-01
      0.00000000000000E+00   0.00000000000000E+00   1.11698524055856E-13   0.00000000000000E+00   1.11698524055856E-13
      3.66228510991288E-18  -2.55565487534889E-01  -2.51324105854098E-01   0.00000000000000E+00  -1.90893774705341E-15
     -9.86837770038670E-23  -1.34624416625882E-08  -1.34624435715260E-08  -2.88302599698335E-18
      1.55954381250000E-07
      0.00000000000000E+00  -1.34379871903077E-11   0.00000000000000E+00   5.44736221843432E-18   1.67524471596427E-22
      1.34379810400393E-08   1.34379810454868E-08  -7.79448208136132E-19  -2.55886074832851E-01  -2.55886074832851E-01
      0.00000000000000E+00   0.00000000000000E+00   3.65835282058187E-13   0.00000000000000E+00   3.65835282058187E-13
      3.66289267200080E-18  -2.55575407781706E-01  -2.51341617460109E-01   0.00000000000000E+00  -1.32288572844461E-15
     -9.86148254491842E-23  -1.34383455578830E-08  -1.34383468807689E-08  -2.88344446386466E-18
      1.57954381250000E-07
      0.00000000000000E+00  -1.33892176348505E-11   0.00000000000000E+00  -1.21047633486312E-15   1.67309843918102E-22
      1.33892265218048E-08   1.33892253113286E-08  -7.79850701280185E-19  -2.55683158240174E-01  -2.55683158240174E-01
      0.00000000000000E+00   0.00000000000000E+00   7.70627304074036E-13   0.00000000000000E+00   7.70627304074036E-13
      3.66443392660894E-18  -2.55681198965513E-01  -2.51462641774634E-01   0.00000000000000E+00  -2.16499110363399E-15
     -9.86904528080566E-23  -1.33899937736415E-08  -1.33899959386327E-08  -2.88458322532876E-18
      1.59954381250000E-07
      0.00000000000000E+00  -1.33229975793238E-11   0.00000000000000E+00  -1.64429487286410E-15   1.66966274062440E-22
      1.33230192185277E-08   1.33230175742330E-08  -7.80422710661144E-19  -2.55388273866185E-01  -2.55388273866186E-01
      0.00000000000000E+00   0.00000000000000E+00   1.21427987316344E-12   0.00000000000000E+00   1.21427987316344E-12
      3.66686248635527E-18  -2.55912815558295E-01  -2.51714977975181E-01   0.00000000000000E+00  -4.18141415915944E-15
     -9.92025097912060E-23  -1.33242276726919E-08  -1.33242318541062E-08  -2.88643977569413E-18
      1.61954381250000E-07
      0.00000000000000E+00  -1.32482359632369E-11   0.00000000000000E+00  -1.20931001408388E-15   1.66601714988275E-22
      1.32482587883127E-08   1.32482575790028E-08  -7.81100771406439E-19  -2.55030888597138E-01  -2.55030888597140E-01
      0.00000000000000E+00   0.00000000000000E+00   1.58205347083885E-12   0.00000000000000E+00   1.58205347083885E-12
      3.67002659329695E-18  -2.56284492665129E-01  -2.52110093384549E-01   0.00000000000000E+00  -6.97107978905550E-15
     -9.87123615188719E-23  -1.32498326613938E-08  -1.32498396324737E-08  -2.88892582189051E-18
      1.63954381250000E-07
      0.00000000000000E+00  -1.31826588208707E-11   0.00000000000000E+00  -1.83636001563678E-16   1.66429270305680E-22
      1.31826833505448E-08   1.31826831669089E-08  -7.81742221875730E-19  -2.54681497670567E-01  -2.54681497670568E-01
      0.00000000000000E+00   0.00000000000000E+00   1.70264421518693E-12   0.00000000000000E+00   1.70264421518693E-12
      3.67343188172732E-18  -2.56775991176508E-01  -2.52622214278319E-01   0.00000000000000E+00  -9.61014812803052E-15
     -9.80855571620178E-23  -1.31843762009759E-08  -1.31843858111241E-08  -2.89168965985159E-18
      1.65954381250000E-07
      0.00000000000000E+00  -1.31533603497015E-11   0.00000000000000E+00   6.57855952734014E-15   1.66709707713145E-22
      1.31533502910556E-08   1.31533568696152E-08  -7.82115462829417E-19  -2.54457805921266E-01  -2.54457805921267E-01
      0.00000000000000E+00   0.00000000000000E+00   1.36410510136074E-12   0.00000000000000E+00   1.36410510136074E-12
      3.67616009193004E-18  -2.57315244513510E-01  -2.53170816109012E-01   0.00000000000000E+00  -1.54306913819384E-14
     -9.89057572134390E-23  -1.31547055440251E-08  -1.31547209747166E-08  -2.89404462910063E-18
      1.67954381250000E-07
      0.00000000000000E+00  -1.31946904814449E-11   0.00000000000000E+00   1.10438699179256E-13   1.67521989055561E-22
      1.31947118953788E-08   1.31948223340782E-08  -7.81913168061516E-19  -2.54519500245412E-01  -2.54519500245412E-01
      0.00000000000000E+00   0.00000000000000E+00   3.53774392869442E-13   0.00000000000000E+00   3.53774392869442E-13
      3.67686764071578E-18  -2.57765025719593E-01  -2.53607884303544E-01   0.00000000000000E+00  -1.16233601304336E-13
     -9.89900153275586E-23  -1.31950598748696E-08  -1.31951761084710E-08  -2.89495447265427E-18
      1.69954381250000E-07
      0.00000000000000E+00  -1.33434789557211E-11   0.00000000000000E+00   1.11016308844971E-13   1.69030241277061E-22
      1.33434815844730E-08   1.33435926007820E-08  -7.80801736009415E-19  -2.55044592308144E-01  -2.55044592308143E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.47248550986155E-12   0.00000000000000E+00  -1.47248550986155E-12
      3.67392266969606E-18  -2.57919739361161E-01  -2.53716301864195E-01   0.00000000000000E+00  -1.08251099827794E-13
     -9.82681767081462E-23  -1.33420118641722E-08  -1.33421201152721E-08  -2.89312093368664E-18
      1.71954381250000E-07
      0.00000000000000E+00  -1.36292079331737E-11   0.00000000000000E+00   9.58785247220731E-13   1.71204963919465E-22
      1.36292208820981E-08   1.36301796673455E-08  -7.78508342217030E-19  -2.56185450662429E-01  -2.56185450662424E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.10108472523943E-12   0.00000000000000E+00  -4.10108472523943E-12
      3.66572050024558E-18  -2.57520405629191E-01  -2.53227770246280E-01   0.00000000000000E+00  -9.51207661108876E-13
     -9.87538551531875E-23  -1.36251273749591E-08  -1.36260785826203E-08  -2.88721215802855E-18
      1.73954381250000E-07
      0.00000000000000E+00  -1.40614292664723E-11   0.00000000000000E+00   2.57659654549451E-13   1.73659359960358E-22
      1.40614465881851E-08   1.40617042478398E-08  -7.74953383895993E-19  -2.58001247518793E-01  -2.58001247518786E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.25742679767476E-12   0.00000000000000E+00  -7.25742679767476E-12
      3.65120564665023E-18  -2.56294222410354E-01  -2.51866404267198E-01   0.00000000000000E+00  -2.27837136319874E-13
     -9.85212887708407E-23  -1.40542189839057E-08  -1.40544468210421E-08  -2.87625226275424E-18
      1.75954381250000E-07
      0.00000000000000E+00  -1.46084565212804E-11   0.00000000000000E+00   1.35717717350613E-14   1.76267530643707E-22
      1.46084455830754E-08   1.46084591548473E-08  -7.70384881006884E-19  -2.60384980995633E-01  -2.60384980995623E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03246403386111E-11   0.00000000000000E+00  -1.03246403386111E-11
      3.63055636597301E-18  -2.54034360682946E-01  -2.49435170284181E-01   0.00000000000000E+00   3.75063466651374E-14
     -9.81705870723521E-23  -1.45981720208552E-08  -1.45981345145087E-08  -2.86017148496613E-18
      1.77954381250000E-07
      0.00000000000000E+00  -1.51765162209089E-11   0.00000000000000E+00   5.30090040668533E-14   1.77491258271357E-22
      1.51764325822207E-08   1.51764855912249E-08  -7.65516696530363E-19  -2.62989089175044E-01  -2.62989089175031E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.23015187108159E-11   0.00000000000000E+00  -1.23015187108159E-11
      3.60595332855138E-18  -2.50718655317500E-01  -2.45941135790191E-01   0.00000000000000E+00   6.66099423676588E-15
     -9.76590980046650E-23  -1.51641907335083E-08  -1.51641840725141E-08  -2.84043663202101E-18
      1.79954381250000E-07
      0.00000000000000E+00  -1.55889909357079E-11   0.00000000000000E+00   1.02529253571315E-14   1.77054743323836E-22
      1.55890003811275E-08   1.55890106340530E-08  -7.61624565455003E-19  -2.65170666702629E-01  -2.65170666702617E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18179890439940E-11   0.00000000000000E+00  -1.18179890439940E-11
      3.58231735046339E-18  -2.46666008748990E-01  -2.41758350971630E-01   0.00000000000000E+00   5.74560929412405E-14
     -9.70954886276402E-23  -1.55772501011018E-08  -1.55771926450090E-08  -2.82069278500838E-18
      1.81954381250000E-07
      0.00000000000000E+00  -1.55855926804313E-11   0.00000000000000E+00  -6.11039862149707E-17   1.73279410975566E-22
      1.55856060690123E-08   1.55856060079084E-08  -7.60590527308636E-19  -2.65964306944953E-01  -2.65964306944946E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.25591068430439E-12   0.00000000000000E+00  -7.25591068430439E-12
      3.56780552909478E-18  -2.42692953292629E-01  -2.37784926139048E-01   0.00000000000000E+00   5.19703195033601E-14
     -9.66440294754105E-23  -1.55784020675436E-08  -1.55783500972241E-08  -2.80721500178614E-18
      1.83954381250000E-07
      0.00000000000000E+00  -1.48685608170521E-11   0.00000000000000E+00  -1.77969817167222E-14   1.65313066753962E-22
      1.48685406114113E-08   1.48685228144297E-08  -7.64851509691488E-19  -2.64102506636752E-01  -2.64102506636755E-01
      0.00000000000000E+00   0.00000000000000E+00   2.96449538811397E-12   0.00000000000000E+00   2.96449538811397E-12
      3.57373451987101E-18  -2.40176180387524E-01  -2.35490852561155E-01   0.00000000000000E+00   2.69625318791420E-14
     -9.65117591265813E-23  -1.48715142723496E-08  -1.48714873098178E-08  -2.80888301017952E-18
      1.85954381250000E-07
      0.00000000000000E+00  -1.32266524499931E-11   0.00000000000000E+00  -4.10294681405029E-14   1.52597367060641E-22
      1.32267273783821E-08   1.32266863489141E-08  -7.77142029278847E-19  -2.58137245134931E-01  -2.58137245134951E-01
      0.00000000000000E+00   0.00000000000000E+00   1.97287312899169E-11   0.00000000000000E+00   1.97287312899169E-11
      3.61319198245084E-18  -2.40873663732014E-01  -2.36700327039639E-01   0.00000000000000E+00  -2.62325608954989E-14
     -9.70291561979800E-23  -1.32463888476430E-08  -1.32464150802040E-08  -2.83604995317199E-18
      1.87954381250000E-07
      0.00000000000000E+00  -1.07209443294974E-11   0.00000000000000E+00  -6.22489899051500E-14   1.34009594531400E-22
      1.07209963978712E-08   1.07209341488814E-08  -7.99862834535895E-19  -2.46755330961728E-01  -2.46755330961771E-01
      0.00000000000000E+00   0.00000000000000E+00   4.21336978831028E-11   0.00000000000000E+00   4.21336978831028E-11
      3.69745937821705E-18  -2.46390084605603E-01  -2.42999147582138E-01   0.00000000000000E+00  -1.18197321979538E-13
     -9.84716185389941E-23  -1.07629496494424E-08  -1.07630678467645E-08  -2.89759654368115E-18
      1.89954381250000E-07
      0.00000000000000E+00  -7.80423100999796E-12   0.00000000000000E+00  -7.27297307098696E-14   1.09734630425623E-22
      7.80427351501332E-09   7.80420078528272E-09  -8.33927241005274E-19  -2.29391490637797E-01  -2.29391490637864E-01
      0.00000000000000E+00   0.00000000000000E+00   6.63455186400596E-11   0.00000000000000E+00   6.63455186400596E-11
      3.83015041549716E-18  -2.57421349248635E-01  -2.54941724127374E-01   0.00000000000000E+00  -2.52055531916900E-13
     -1.00627526768883E-22  -7.87029424839077E-09  -7.87054630392278E-09  -2.99622317449189E-18
      1.91954381250000E-07
      0.00000000000000E+00  -5.17692045743945E-12   0.00000000000000E+00  -7.20343481324465E-14   8.30890943003970E-23
      5.17701650817788E-09   5.17694447382983E-09  -8.77024011626214E-19  -2.07177082801625E-01  -2.07177082801710E-01
      0.00000000000000E+00   0.00000000000000E+00   8.54567684792994E-11   0.00000000000000E+00   8.54567684792994E-11
      4.00106395245577E-18  -2.73297992320368E-01  -2.71640078161816E-01   0.00000000000000E+00  -4.03241073699607E-13
     -1.03895783221998E-22  -5.26199800123533E-09  -5.26240124230914E-09  -3.12403994082955E-18
      1.93954381250000E-07
      0.00000000000000E+00  -3.37648807396031E-12   0.00000000000000E+00  -4.54223827391550E-14   6.16176923624849E-23
      3.37656095381874E-09   3.37651553143606E-09  -9.21615238878051E-19  -1.83933139641138E-01  -1.83933139641229E-01
      0.00000000000000E+00   0.00000000000000E+00   9.13794031332303E-11   0.00000000000000E+00   9.13794031332303E-11
      4.18382275872223E-18  -2.92334960640894E-01  -2.91242415826423E-01   0.00000000000000E+00  -5.31280679164053E-13
     -1.07394654862553E-22  -3.46736365389002E-09  -3.46789493456929E-09  -3.26220751984418E-18
      1.95954381250000E-07
      0.00000000000000E+00  -2.51783162580714E-12   0.00000000000000E+00  -2.19532263355472E-14   5.50359179394229E-23
      2.51789911479190E-09   2.51787716156561E-09  -9.54569654418503E-19  -1.66132536345730E-01  -1.66132536345808E-01
      0.00000000000000E+00   0.00000000000000E+00   7.83846572994366E-11   0.00000000000000E+00   7.83846572994366E-11
      4.34059207332110E-18  -3.12669607712491E-01  -3.11851674647363E-01   0.00000000000000E+00  -5.34429052696050E-13
     -1.10601602274526E-22  -2.59572738981224E-09  -2.59626181886505E-09  -3.38602241890260E-18
      1.97954381250000E-07
      0.00000000000000E+00  -2.51369861263280E-12   0.00000000000000E+00   3.34256771985027E-15   7.33267684144896E-23
      2.51364750259480E-09   2.51365084516259E-09  -9.61981169065979E-19  -1.60424215994622E-01  -1.60424215994668E-01
      0.00000000000000E+00   0.00000000000000E+00   4.65140601098579E-11   0.00000000000000E+00   4.65140601098579E-11
      4.43362019354082E-18  -3.32648305004988E-01  -3.31841750563255E-01   0.00000000000000E+00  -3.85293603990587E-13
     -1.12625643148131E-22  -2.55977961166834E-09  -2.56016490527244E-09  -3.47163902447483E-18
      1.99954381250000E-07
      0.00000000000000E+00  -3.46833281116783E-12   0.00000000000000E+00   2.41557812128654E-14   1.24539856690446E-22
      3.46828814714638E-09   3.46831230292771E-09  -9.38583523410533E-19  -1.69504823663609E-01  -1.69504823663612E-01
      0.00000000000000E+00   0.00000000000000E+00   2.52954485379452E-12   0.00000000000000E+00   2.52954485379452E-12
      4.43867928324840E-18  -3.50442107126593E-01  -3.49348654214849E-01   0.00000000000000E+00  -1.47299511632470E-13
     -1.13340043962019E-22  -3.47069454826976E-09  -3.47084184778151E-09  -3.50009575983787E-18
      2.01954381250000E-07
      0.00000000000000E+00  -5.76784949663268E-12   0.00000000000000E+00   5.77337089332944E-14   1.99858094119484E-22
      5.76783603674183E-09   5.76789377045097E-09  -8.93419609462966E-19  -1.90001939021705E-01  -1.90001939021663E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.24361754762528E-11   0.00000000000000E+00  -4.24361754762528E-11
      4.35380693229590E-18  -3.63512737272636E-01  -3.61708988081990E-01   0.00000000000000E+00   4.12040373184907E-14
     -1.12930428407875E-22  -5.72549879901192E-09  -5.72545759497472E-09  -3.46038732283293E-18
      2.03954381250000E-07
      0.00000000000000E+00  -9.66776072793868E-12   0.00000000000000E+00   9.72587365207417E-14   2.64689087851228E-22
      9.66762392257194E-09   9.66772118130872E-09  -8.41805553158015E-19  -2.15532133272291E-01  -2.15532133272213E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.82034652945951E-11   0.00000000000000E+00  -7.82034652945951E-11
      4.19740000170671E-18  -3.68858673223027E-01  -3.65837577010175E-01   0.00000000000000E+00   1.46406832686571E-13
     -1.11800131438763E-22  -9.58966412284671E-09  -9.58951771601413E-09  -3.35559444854869E-18
      2.05954381250000E-07
      0.00000000000000E+00  -1.50938559574222E-11   0.00000000000000E+00   1.34740594302923E-13   2.96845445456566E-22
      1.50936438562157E-08   1.50937785968103E-08  -7.91855664510639E-19  -2.41926337483391E-01  -2.41926337483289E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02298179304524E-10   0.00000000000000E+00  -1.02298179304524E-10
      3.99280364309766E-18  -3.63618407370905E-01  -3.58895437574410E-01   0.00000000000000E+00   2.46747805837094E-13
     -1.09937481154717E-22  -1.49917271653115E-08  -1.49914804175058E-08  -3.20094797858702E-18
      2.07954381250000E-07
      0.00000000000000E+00  -2.20744233641430E-11   0.00000000000000E+00   1.73214650664335E-13   3.00098084563677E-22
      2.20742867807814E-08   2.20744599954324E-08  -7.43995030636991E-19  -2.68028893333178E-01  -2.68028893333060E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18334168473886E-10   0.00000000000000E+00  -1.18334168473886E-10
      3.75613530614989E-18  -3.44934630853055E-01  -3.38017426750010E-01   0.00000000000000E+00   3.96155357785614E-13
     -1.06996228149406E-22  -2.19565219823162E-08  -2.19561258269585E-08  -3.01214027551290E-18
      2.09954381250000E-07
      0.00000000000000E+00  -3.07625681250262E-11   0.00000000000000E+00   2.15507683449741E-13   2.84966877252906E-22
      3.07623975647995E-08   3.07626130724833E-08  -6.96994429984683E-19  -2.93672253909879E-01  -2.93672253909750E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.29856893541813E-10   0.00000000000000E+00  -1.29856893541813E-10
      3.49642151906626E-18  -3.09731407265250E-01  -3.00080528429054E-01   0.00000000000000E+00   5.66922409050842E-13
     -1.02259893738611E-22  -3.06333231013504E-08  -3.06327561789415E-08  -2.79942708908158E-18
      2.11954381250000E-07
      0.00000000000000E+00  -4.09002065285186E-11   0.00000000000000E+00   2.51594931264491E-13   2.56653600434906E-22
      4.08999209026598E-08   4.09001724975913E-08  -6.50289760481210E-19  -3.18809643326794E-01  -3.18809643326653E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.40958834870718E-10   0.00000000000000E+00  -1.40958834870718E-10
      3.21450384932483E-18  -2.55506765685788E-01  -2.42665323972439E-01   0.00000000000000E+00   6.64733822429644E-13
     -9.50425165194657E-23  -4.07598783965430E-08  -4.07592136627206E-08  -2.56421408884362E-18
      2.13954381250000E-07
      0.00000000000000E+00  -5.08813414998094E-11   0.00000000000000E+00   2.85805619394554E-13   2.04845100005163E-22
      5.08811027747107E-08   5.08813885803303E-08  -6.04186463699431E-19  -3.43419080153010E-01  -3.43419080152852E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.57881879553755E-10   0.00000000000000E+00  -1.57881879553755E-10
      2.89874009021732E-18  -1.82906374152572E-01  -1.66925380479395E-01   0.00000000000000E+00   5.49711961401844E-13
     -8.63150124936564E-23  -5.07240564127378E-08  -5.07235067007765E-08  -2.29455362651789E-18
      2.15954381250000E-07
      0.00000000000000E+00  -5.69791891372287E-11   0.00000000000000E+00   1.70094088881264E-13   1.14163204929540E-22
      5.69790406715590E-08   5.69792107656480E-08  -5.58910346359743E-19  -3.67498241661392E-01  -3.67498241661214E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.77735387312287E-10   0.00000000000000E+00  -1.77735387312287E-10
      2.54326931559274E-18  -9.98214044309989E-02  -8.19252640175356E-02   0.00000000000000E+00   4.29060540214175E-13
     -7.32475853702831E-23  -5.68019044388758E-08  -5.68014753783357E-08  -1.98435896923300E-18
      2.17954381250000E-07
      0.00000000000000E+00  -4.46233166407001E-11   0.00000000000000E+00  -3.05965902069985E-13   3.75307625495890E-23
      4.46236349058598E-08   4.46233289399577E-08  -5.08359096693547E-19  -3.91130683374007E-01  -3.91130683373848E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.59036038883052E-10   0.00000000000000E+00  -1.59036038883052E-10
      2.22519723782664E-18  -4.24177099161936E-02  -2.84084915044516E-02   0.00000000000000E+00   5.89040031173911E-13
     -3.21803035993427E-23  -4.44648819411059E-08  -4.44642929010747E-08  -1.71683814113309E-18
      2.19954381250000E-07
      0.00000000000000E+00  -2.73003889112513E-11   0.00000000000000E+00  -4.28167284860952E-13   1.32532574334341E-23
      2.73008149009205E-08   2.73003867336356E-08  -4.51036270891543E-19  -4.14373364610717E-01  -4.14373364610602E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15266418099176E-10   0.00000000000000E+00  -1.15266418099176E-10
      1.99466440162829E-18  -1.98667498196729E-02  -1.13016025122699E-02   0.00000000000000E+00   5.35779243591977E-13
     -1.31264992963498E-23  -2.71856560947800E-08  -2.71851203155365E-08  -1.54362813073674E-18
      2.21954381250000E-07
      0.00000000000000E+00  -1.97336683916720E-11   0.00000000000000E+00  -1.86436822623847E-13   6.87600108390667E-24
      1.97338457030863E-08   1.97336592662637E-08  -3.94085645313853E-19  -4.37178775645395E-01  -4.37178775645296E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.94294435423964E-11   0.00000000000000E+00  -9.94294435423964E-11
      1.79580551454349E-18  -1.24864398220199E-02  -6.30032405769558E-03   0.00000000000000E+00   2.46668360767099E-13
     -7.47692045920769E-24  -1.96344764910820E-08  -1.96342298227213E-08  -1.40171986922964E-18
      2.23954381250000E-07
      0.00000000000000E+00  -1.72910576056378E-11   0.00000000000000E+00  -5.98787673986216E-14   4.82831217786964E-24
      1.72911570676734E-08   1.72910971889060E-08  -3.39264654071389E-19  -4.59527405574388E-01  -4.59527405574290E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.76756214527375E-11   0.00000000000000E+00  -9.76756214527375E-11
      1.60045427163802E-18  -1.00005963709156E-02  -4.58349559091185E-03   0.00000000000000E+00   1.04832066454510E-13
     -5.37413345998964E-24  -1.71935263995197E-08  -1.71934215674532E-08  -1.26118961756663E-18
      2.25954381250000E-07
      0.00000000000000E+00  -1.65544628132335E-11   0.00000000000000E+00  -1.78147650128026E-14   3.92309144192628E-24
      1.65544805070181E-08   1.65544626922531E-08  -2.86848825750930E-19  -4.81419598670505E-01  -4.81419598670405E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.97667672998145E-11   0.00000000000000E+00  -9.97667672998145E-11
      1.40092073703839E-18  -8.99276914174235E-03  -3.80841321097774E-03   0.00000000000000E+00   5.53021878534943E-14
     -4.34832656344931E-24  -1.64547512271411E-08  -1.64546959249532E-08  -1.11407191128746E-18
      2.27954381250000E-07
      0.00000000000000E+00  -1.63146562043846E-11   0.00000000000000E+00  -5.59387255752293E-15   3.40181540029550E-24
      1.63146708394627E-08   1.63146652455902E-08  -2.36893965620793E-19  -5.02859972144255E-01  -5.02859972144153E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02430715196206E-10   0.00000000000000E+00  -1.02430715196206E-10
      1.19605930664598E-18  -8.46834987328861E-03  -3.36038245449282E-03   0.00000000000000E+00   3.81259088068543E-14
     -3.71544944353365E-24  -1.62122726563028E-08  -1.62122345303940E-08  -9.59165341025184E-19
      2.29954381250000E-07
      0.00000000000000E+00  -1.62193213671632E-11   0.00000000000000E+00  -2.06359752880305E-15   3.05114120423410E-24
      1.62192957262672E-08   1.62192936626697E-08  -1.89379649893949E-19  -5.23844743428861E-01  -5.23844743428757E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04700134375178E-10   0.00000000000000E+00  -1.04700134375178E-10
      9.86659037895622E-19  -8.13771525175904E-03  -3.06050851470564E-03   0.00000000000000E+00   3.08344554416347E-14
     -3.27177347420499E-24  -1.61146243627499E-08  -1.61145935282945E-08  -7.97279388001673E-19
      2.31954381250000E-07
      0.00000000000000E+00  -1.61706436564432E-11   0.00000000000000E+00  -9.39480858428313E-16   2.79539287766307E-24
      1.61706441106777E-08   1.61706431711968E-08  -1.44362137285405E-19  -5.44301398490208E-01  -5.44301398490102E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05983177568999E-10   0.00000000000000E+00  -1.05983177568999E-10
      7.74692682757623E-19  -7.90574106280886E-03  -2.84426465083258E-03   0.00000000000000E+00   2.66178559015709E-14
     -2.94179454720033E-24  -1.60646866114837E-08  -1.60646599936278E-08  -6.30330545472217E-19
      2.33954381250000E-07
      0.00000000000000E+00  -1.61386816878950E-11   0.00000000000000E+00  -5.55159301549595E-16   2.60170926357322E-24
      1.61386824329442E-08   1.61386818777849E-08  -1.02351357367390E-19  -5.63915445583585E-01  -5.63915445583480E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04906131019947E-10   0.00000000000000E+00  -1.04906131019947E-10
      5.64880420717729E-19  -7.73450076936493E-03  -2.68275321929195E-03   0.00000000000000E+00   2.33278180296686E-14
     -2.69064698730447E-24  -1.60337990745830E-08  -1.60337757467650E-08  -4.62529063350340E-19
      2.35954381250000E-07
      0.00000000000000E+00  -1.61119548693676E-11   0.00000000000000E+00  -4.54367522278244E-16   2.45355908038972E-24
      1.61119986359298E-08   1.61119981815623E-08  -6.43323919371792E-20  -5.82105869684108E-01  -5.82105869684008E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.98789629243759E-11   0.00000000000000E+00  -9.98789629243759E-11
      3.65122494868977E-19  -7.60555788518115E-03  -2.56063203739494E-03   0.00000000000000E+00   2.01692918761969E-14
     -2.49924257021110E-24  -1.60121393879298E-08  -1.60121192186379E-08  -3.00790102931799E-19
      2.37954381250000E-07
      0.00000000000000E+00  -1.60840340692565E-11   0.00000000000000E+00  -5.21404332480396E-16   2.34248973419501E-24
      1.60840167735332E-08   1.60840162521289E-08  -3.19551406926437E-20  -5.97923679808822E-01  -5.97923679808734E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.86785445753736E-11   0.00000000000000E+00  -8.86785445753736E-11
      1.87765405718230E-19  -7.50920310186197E-03  -2.46956334659102E-03   0.00000000000000E+00   1.66222725121874E-14
     -2.35742651714429E-24  -1.59953543298260E-08  -1.59953377075535E-08  -1.55810265025586E-19
      2.39954381250000E-07
      0.00000000000000E+00  -1.60489493796432E-11   0.00000000000000E+00  -7.41488038080770E-16   2.26541848608357E-24
      1.60489551001652E-08   1.60489543586771E-08  -7.79289818703203E-21  -6.09919991618698E-01  -6.09919991618630E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.82948843896887E-11   0.00000000000000E+00  -6.82948843896887E-11
      5.11756369388523E-20  -7.44113849127641E-03  -2.40612252844081E-03   0.00000000000000E+00   1.21784693111578E-14
     -2.26172813949497E-24  -1.59806716527567E-08  -1.59806594742874E-08  -4.33827387518201E-20
      2.41954381250000E-07
      0.00000000000000E+00  -1.59996287557628E-11   0.00000000000000E+00  -1.14252569996460E-15   2.22550245528969E-24
      1.59996142068558E-08   1.59996130643301E-08   4.71272299698568E-21  -6.16189530038755E-01  -6.16189530038719E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.60258832482385E-11   0.00000000000000E+00  -3.60258832482385E-11
     -2.08761295576245E-20  -7.40561741972297E-03  -2.37598000469610E-03   0.00000000000000E+00   6.42905992190773E-15
     -2.21701204530924E-24  -1.59635936101418E-08  -1.59635871810818E-08   1.61634065606390E-20
      2.43954381250000E-07
      0.00000000000000E+00  -1.59388275397314E-11   0.00000000000000E+00  -1.54107988505336E-15   2.22376886346738E-24
      1.59388194033035E-08   1.59388178622236E-08   1.38354460219109E-21  -6.14512926065261E-01  -6.14512926065271E-01
      0.00000000000000E+00   0.00000000000000E+00   9.61259687424297E-12   0.00000000000000E+00   9.61259687424297E-12
     -1.65093580913851E-21  -7.39836914219313E-03  -2.37350722805692E-03   0.00000000000000E+00  -1.19074629767806E-15
     -2.22535993733864E-24  -1.59484292683515E-08  -1.59484304590978E-08   2.67391206947680E-22
      2.45954381250000E-07
      0.00000000000000E+00  -1.58540548472889E-11   0.00000000000000E+00   9.18921150081209E-15   2.27882774861483E-24
      1.58540097487052E-08   1.58540189379167E-08  -2.28975204908990E-20  -6.02389514636682E-01  -6.02389514636751E-01
      0.00000000000000E+00   0.00000000000000E+00   6.92793218163165E-11   0.00000000000000E+00   6.92793218163165E-11
      1.36907707823494E-19  -7.43846747739221E-03  -2.42152837404976E-03   0.00000000000000E+00  -2.25657447135820E-14
     -2.31530477977488E-24  -1.59232756939883E-08  -1.59232982597330E-08  -1.14010187332595E-19
      2.47954381250000E-07
      0.00000000000000E+00  -1.57411776652608E-11   0.00000000000000E+00  -3.05572384245556E-15   2.42520409998333E-24
      1.57412190198226E-08   1.57412159640988E-08  -7.50699044624111E-20  -5.76905441293740E-01  -5.76905441293882E-01
      0.00000000000000E+00   0.00000000000000E+00   1.42714593228787E-10   0.00000000000000E+00   1.42714593228787E-10
      4.22336894281068E-19  -7.55286720030032E-03  -2.54833003241881E-03   0.00000000000000E+00  -2.51544765240624E-14
     -2.54410259368233E-24  -1.58839054028510E-08  -1.58839305573276E-08  -3.47266989818657E-19
      2.49954381250000E-07
      0.00000000000000E+00  -1.55729181066966E-11   0.00000000000000E+00  -4.65356160327126E-15   2.75822783317152E-24
      1.55729092072470E-08   1.55729045536854E-08  -1.65331078250350E-19  -5.34668777133128E-01  -5.34668777133354E-01
      0.00000000000000E+00   0.00000000000000E+00   2.26227278108870E-10   0.00000000000000E+00   2.26227278108870E-10
      8.74791450498808E-19  -7.82901965807902E-03  -2.85120370717877E-03   0.00000000000000E+00  -4.62407128795746E-14
     -3.09348896569252E-24  -1.57990855910814E-08  -1.57991318317943E-08  -7.09460372248458E-19
      2.51954381250000E-07
      0.00000000000000E+00  -1.52221630553011E-11   0.00000000000000E+00  -9.78800849430359E-15   3.61200027692969E-24
      1.52221706113481E-08   1.52221608233396E-08  -3.08498727137534E-19  -4.72236786965382E-01  -4.72236786965686E-01
      0.00000000000000E+00   0.00000000000000E+00   3.04572201792524E-10   0.00000000000000E+00   3.04572201792524E-10
      1.48393585408386E-18  -8.63042923395374E-03  -3.73844640135456E-03   0.00000000000000E+00  -8.17456954457681E-14
     -4.71641186816285E-24  -1.55266512794367E-08  -1.55267330251321E-08  -1.17543712694632E-18
      2.53954381250000E-07
      0.00000000000000E+00  -1.37115926624489E-11   0.00000000000000E+00  -3.89142708383274E-14   5.67421809349357E-24
      1.37115593765567E-08   1.37115204622858E-08  -5.17549843844809E-19  -3.87177599582581E-01  -3.87177599582927E-01
      0.00000000000000E+00   0.00000000000000E+00   3.46775555596790E-10   0.00000000000000E+00   3.46775555596790E-10
      2.17748696527744E-18  -1.22838339596403E-02  -7.85452713283587E-03   0.00000000000000E+00  -1.47225170097167E-13
     -1.47937367976465E-23  -1.40581487927125E-08  -1.40582960178826E-08  -1.65993712143263E-18
      2.55954381250000E-07
      0.00000000000000E+00  -5.71108944903843E-12   0.00000000000000E+00  -2.16141108314424E-13  -6.77634810599356E-24
      5.71134274619159E-09   5.71112660508327E-09  -7.63180461048478E-19  -2.80151596876415E-01  -2.80151596876789E-01
      0.00000000000000E+00   0.00000000000000E+00   3.73859510816403E-10   0.00000000000000E+00   3.73859510816403E-10
      2.92520598691024E-18  -3.14412220133177E-02  -2.95240561981983E-02   0.00000000000000E+00  -2.38419769756025E-13
     -6.65755868276570E-23  -6.08474769612985E-09  -6.08498611589967E-09  -2.16202552586176E-18
      2.57954381250000E-07
      0.00000000000000E+00  -3.57459717211694E-13   0.00000000000000E+00  -1.37872184092440E-13  -4.03254957216085E-23
      3.57616873963088E-10   3.57479001778955E-10  -1.01139707612332E-18  -1.60673845165668E-01  -1.60673845166044E-01
      0.00000000000000E+00   0.00000000000000E+00   3.75356784183680E-10   0.00000000000000E+00   3.75356784183680E-10
      3.67591955527760E-18  -6.06682881869049E-02  -6.04374007284982E-02   0.00000000000000E+00  -7.71318888708629E-13
     -8.88698116720206E-23  -7.32064467073838E-10  -7.32835785962635E-10  -2.66452247915429E-18
      2.59954381250000E-07
      0.00000000000000E+00   7.66903555682848E-14   0.00000000000000E+00  -1.75376676882874E-14  -4.56030454716063E-23
     -7.66896769082789E-11  -7.67072145760128E-11  -1.20571056571774E-18  -6.40263982562679E-02  -6.40263982565571E-02
      0.00000000000000E+00   0.00000000000000E+00   2.89164368621223E-10   0.00000000000000E+00   2.89164368621223E-10
      4.25424829252005E-18  -9.03222832403034E-02  -9.02553464557909E-02   0.00000000000000E+00  -1.22392151326139E-12
     -9.99494374799681E-23  -2.11233232531848E-10  -2.12457154045210E-10  -3.04853772680231E-18
      2.61954381250000E-07
      0.00000000000000E+00   3.82992554155387E-14   0.00000000000000E+00  -1.66234387095472E-15  -4.63284828348588E-23
     -3.82997057949859E-11  -3.83013681389032E-11  -1.28491868131230E-18  -2.53727089408690E-02  -2.53727089410259E-02
      0.00000000000000E+00   0.00000000000000E+00   1.56932547696448E-10   0.00000000000000E+00   1.56932547696448E-10
      4.56811338791294E-18  -1.19557727755479E-01  -1.19520352097132E-01   0.00000000000000E+00  -8.05975667163572E-13
     -1.05500062185831E-22  -1.17825203890276E-10  -1.18631179557545E-10  -3.28319470660064E-18
      2.63954381250000E-07
      0.00000000000000E+00   4.50039212316881E-15   0.00000000000000E+00   6.69472145111495E-16  -4.63023110764132E-23
     -4.50521868768616E-12  -4.50454921558735E-12  -1.31111666660130E-18  -1.36458276366245E-02  -1.36458276367161E-02
      0.00000000000000E+00   0.00000000000000E+00   9.15997574804070E-11   0.00000000000000E+00   9.15997574804070E-11
      4.75131290287376E-18  -1.48254965494617E-01  -1.48227525796519E-01   0.00000000000000E+00  -5.00222928810314E-13
     -1.08501717307266E-22  -8.65949853359002E-11  -8.70952082648190E-11  -3.44019623627246E-18
      2.65954381250000E-07
      0.00000000000000E+00  -1.53380711136570E-14   0.00000000000000E+00   8.97118276472780E-16  -4.58511705309845E-23
      1.53532722508745E-11   1.53541693691051E-11  -1.31872059988927E-18  -1.01659273780322E-02  -1.01659273780954E-02
      0.00000000000000E+00   0.00000000000000E+00   6.32766720880168E-11   0.00000000000000E+00   6.32766720880168E-11
      4.87786624704979E-18  -1.76375070204130E-01  -1.76350297460439E-01   0.00000000000000E+00  -4.21473663849278E-13
     -1.10877614692539E-22  -7.82093677931618E-11  -7.86308414571219E-11  -3.55914564716053E-18
      2.67954381250000E-07
      0.00000000000000E+00  -2.92066264319935E-14   0.00000000000000E+00   7.49061084880619E-16  -4.47409866778367E-23
      2.91919341607185E-11   2.91926832217587E-11  -1.31964390831586E-18  -8.96585180597482E-03  -8.96585180602385E-03
      0.00000000000000E+00   0.00000000000000E+00   4.90271437479847E-11   0.00000000000000E+00   4.90271437479847E-11
      4.97592053454576E-18  -2.03914556675578E-01  -2.03889913612989E-01   0.00000000000000E+00  -4.22392167723073E-13
     -1.13163465077569E-22  -7.77974348019075E-11  -7.82198269697438E-11  -3.65627662622991E-18
      2.69954381250000E-07
      0.00000000000000E+00  -4.02279948968967E-14   0.00000000000000E+00   5.85853822839620E-16  -4.24849258050331E-23
      4.02616075204476E-11   4.02621933742280E-11  -1.31796445743024E-18  -8.41880142849962E-03  -8.41880142854017E-03
      0.00000000000000E+00   0.00000000000000E+00   4.05510227824217E-11   0.00000000000000E+00   4.05510227824217E-11
      5.05702258011060E-18  -2.30884456109920E-01  -2.30858996203107E-01   0.00000000000000E+00  -4.40613192387876E-13
     -1.15470267985314E-22  -8.03726029641459E-11  -8.08132161566493E-11  -3.73905812268036E-18
      2.71954381250000E-07
      0.00000000000000E+00  -4.97798475664795E-14   0.00000000000000E+00   4.66460053192664E-16  -3.84921977766729E-23
      4.98241362590890E-11   4.98246027191037E-11  -1.31525290709920E-18  -8.09510411063604E-03  -8.09510411067099E-03
      0.00000000000000E+00   0.00000000000000E+00   3.49502779480136E-11   0.00000000000000E+00   3.49502779480136E-11
      5.12692313600663E-18  -2.57299442070403E-01  -2.57272734277847E-01   0.00000000000000E+00  -4.59831863240096E-13
     -1.17808860478898E-22  -8.43150488037599E-11  -8.47748806671178E-11  -3.81167022890743E-18
      2.73954381249999E-07
      0.00000000000000E+00  -5.84132528639870E-14   0.00000000000000E+00   3.86320466946315E-16  -3.21472471956920E-23
      5.84496287558677E-11   5.84500150763025E-11  -1.31219572123456E-18  -7.87160492821925E-03  -7.87160492825028E-03
      0.00000000000000E+00   0.00000000000000E+00   3.10257753395283E-11   0.00000000000000E+00   3.10257753395283E-11
      5.18897468668569E-18  -2.83171369737020E-01  -2.83143181198231E-01   0.00000000000000E+00  -4.77575469560994E-13
     -1.20174303833327E-22  -8.89982149461498E-11  -8.94757904158310E-11  -3.87677896545112E-18
      2.75954381249999E-07
      0.00000000000000E+00  -6.64955897382494E-14   0.00000000000000E+00   3.33575657197021E-16  -2.29213316654240E-23
      6.64508379882018E-11   6.64511715638360E-11  -1.30911017864656E-18  -7.70473898035193E-03  -7.70473898038009E-03
      0.00000000000000E+00   0.00000000000000E+00   2.81535524290459E-11   0.00000000000000E+00   2.81535524290459E-11
      5.24528179154378E-18  -3.08506089851909E-01  -3.08476285756040E-01   0.00000000000000E+00  -4.94632133043135E-13
     -1.22563783850572E-22  -9.41100918597153E-11  -9.46047239928810E-11  -3.93617161289722E-18
      2.77954381249999E-07
      0.00000000000000E+00  -7.40268581892666E-14   0.00000000000000E+00   2.98700278566697E-16  -1.05502561113242E-23
      7.40324351591315E-11   7.40327338593995E-11  -1.30613818147003E-18  -7.57436049352563E-03  -7.57436049355159E-03
      0.00000000000000E+00   0.00000000000000E+00   2.59612738597651E-11   0.00000000000000E+00   2.59612738597651E-11
      5.29720433926331E-18  -3.33309667226409E-01  -3.33278165587355E-01   0.00000000000000E+00  -5.12415568795874E-13
     -1.24980173569753E-22  -9.94815921502443E-11  -9.99940077191652E-11  -3.99106615779328E-18
      2.79954381249999E-07
      0.00000000000000E+00  -8.13744371658687E-14   0.00000000000000E+00   2.75309368573486E-16   4.71387280921999E-24
      8.13333018422433E-11   8.13335771516166E-11  -1.30333403063314E-18  -7.46945323390914E-03  -7.46945323393334E-03
      0.00000000000000E+00   0.00000000000000E+00   2.42090003098597E-11   0.00000000000000E+00   2.42090003098597E-11
      5.34562233988303E-18  -3.57587480617893E-01  -3.57554231290394E-01   0.00000000000000E+00  -5.32102415925906E-13
     -1.27430332647013E-22  -1.05010475045423E-10  -1.05542577461476E-10  -4.04228830924989E-18
      2.81954381249999E-07
      0.00000000000000E+00  -8.85383266680558E-14   0.00000000000000E+00   2.62121130754181E-16   2.14405259636139E-23
      8.84988493039683E-11   8.84991114251205E-11  -1.30067366492571E-18  -7.40100656709840E-03  -7.40100656712109E-03
      0.00000000000000E+00   0.00000000000000E+00   2.26949378376969E-11   0.00000000000000E+00   2.26949378376969E-11
      5.39101221555842E-18  -3.81327485366220E-01  -3.81292455971922E-01   0.00000000000000E+00  -5.53504134412482E-13
     -1.29918575947353E-22  -1.10640545128274E-10  -1.11194049262817E-10  -4.09033855063271E-18
      2.83954381249999E-07
      0.00000000000000E+00  -9.56103714330353E-14   0.00000000000000E+00   2.52835255717247E-16   3.84477870451523E-23
      9.55785475962111E-11   9.55788004315053E-11  -1.29815414465714E-18  -7.35829421222534E-03  -7.35829421224679E-03
      0.00000000000000E+00   0.00000000000000E+00   2.14500305589439E-11   0.00000000000000E+00   2.14500305589439E-11
      5.43391227667631E-18  -4.04638302487407E-01  -4.04601435318449E-01   0.00000000000000E+00  -5.81655147414778E-13
     -1.32469198673748E-22  -1.16447175842902E-10  -1.17028830990449E-10  -4.13575813201918E-18
      2.85954381249999E-07
      0.00000000000000E+00  -1.02590571460807E-13   0.00000000000000E+00   2.45027361323761E-16   5.48026530564040E-23
      1.02588398800061E-10   1.02588643827478E-10  -1.29577905111415E-18  -7.32761531291254E-03  -7.32761531293294E-03
      0.00000000000000E+00   0.00000000000000E+00   2.03964267601425E-11   0.00000000000000E+00   2.03964267601425E-11
      5.47470513019659E-18  -4.27597753879906E-01  -4.27559010720997E-01   0.00000000000000E+00  -6.16431356589301E-13
     -1.35101271485036E-22  -1.22368639230897E-10  -1.22985070587621E-10  -4.17892607908244E-18
      2.86454381249999E-07
      0.00000000000000E+00  -1.04335621467750E-13   0.00000000000000E+00   2.45312715235807E-16   5.90372967340544E-23
      1.04361600450163E-10   1.04361845762937E-10  -1.29519531504735E-18  -7.32066048977077E-03  -7.32066048979084E-03
      0.00000000000000E+00   0.00000000000000E+00   2.00763355260010E-11   0.00000000000000E+00   2.00763355260010E-11
      5.48474329795960E-18  -4.33313467265998E-01  -4.33274266435782E-01   0.00000000000000E+00  -6.38222110284793E-13
     -1.35769896629780E-22  -1.23799959178517E-10  -1.24438181288938E-10  -4.18954798291224E-18
      2.87129381249999E-07
      0.00000000000000E+00  -1.06723584635146E-13   0.00000000000000E+00   2.42461821404318E-16   6.45438302892119E-23
      1.06741359130894E-10   1.06741601592780E-10  -1.29442369388563E-18  -7.31253177451682E-03  -7.31253177453653E-03
      0.00000000000000E+00   0.00000000000000E+00   1.97106164624665E-11   0.00000000000000E+00   1.97106164624665E-11
      5.49804796407176E-18  -4.40981718301380E-01  -4.40941883143895E-01   0.00000000000000E+00  -6.49667016615600E-13
     -1.36681235561215E-22  -1.25802551038492E-10  -1.26452218055245E-10  -4.20362427018613E-18
      2.88040631249999E-07
      0.00000000000000E+00  -1.09938150437410E-13   0.00000000000000E+00   2.38895611395004E-16   7.14891973390799E-23
      1.09928093269213E-10   1.09928332164896E-10  -1.29341006247514E-18  -7.30396690527474E-03  -7.30396690529397E-03
      0.00000000000000E+00   0.00000000000000E+00   1.92302844329446E-11   0.00000000000000E+00   1.92302844329446E-11
      5.51557156076128E-18  -4.51241254585125E-01  -4.51200567050513E-01   0.00000000000000E+00  -6.65038847231796E-13
     -1.37925123663664E-22  -1.28493577750471E-10  -1.29158616597841E-10  -4.22216149828614E-18
      2.89270818749999E-07
      0.00000000000000E+00  -1.14163008348956E-13   0.00000000000000E+00   2.34888372601730E-16   7.99494675817248E-23
      1.14190892527228E-10   1.14191127415681E-10  -1.29208738748726E-18  -7.29731140803516E-03  -7.29731140805377E-03
      0.00000000000000E+00   0.00000000000000E+00   1.86085642565193E-11   0.00000000000000E+00   1.86085642565193E-11
      5.53846358390260E-18  -4.64919639035232E-01  -4.64877804768926E-01   0.00000000000000E+00  -6.85945085020253E-13
     -1.39626478711855E-22  -1.32113746587040E-10  -1.32799691672199E-10  -4.24637619641534E-18
      2.90931571874999E-07
      0.00000000000000E+00  -1.19857382055822E-13   0.00000000000000E+00   2.30752728526521E-16   8.97760941192909E-23
      1.19891616741008E-10   1.19891847493826E-10  -1.29037116579592E-18  -7.29913026161176E-03  -7.29913026162957E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78112047074343E-11   0.00000000000000E+00   1.78112047074343E-11
      5.56804359778049E-18  -4.83073620718342E-01  -4.83030242210384E-01   0.00000000000000E+00  -7.14701717991545E-13
     -1.41957822927225E-22  -1.36988350483127E-10  -1.37703052201261E-10  -4.27767243198456E-18
      2.92931571874999E-07
      0.00000000000000E+00  -1.26745737346387E-13   0.00000000000000E+00   2.27904777773857E-16   9.95535918902137E-23
      1.26723074668190E-10   1.26723302573068E-10  -1.28837820430381E-18  -7.32267528428226E-03  -7.32267528429915E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68896281613988E-11   0.00000000000000E+00   1.68896281613988E-11
      5.60182285410328E-18  -5.04491236244248E-01  -5.04445996565050E-01   0.00000000000000E+00  -7.51579615854941E-13
     -1.44804109202085E-22  -1.42861351118467E-10  -1.43612930734467E-10  -4.31344464979948E-18
      2.94931571874999E-07
      0.00000000000000E+00  -1.33634092636951E-13   0.00000000000000E+00   2.29726203927171E-16   1.07596993716472E-22
      1.33629316723339E-10   1.33629546449651E-10  -1.28640806607727E-18  -7.38557076836981E-03  -7.38557076838578E-03
      0.00000000000000E+00   0.00000000000000E+00   1.59740600235935E-11   0.00000000000000E+00   1.59740600235935E-11
      5.63377097415047E-18  -5.25472558469802E-01  -5.25425432235241E-01   0.00000000000000E+00  -7.91216441806010E-13
     -1.47670824004682E-22  -1.48812390031289E-10  -1.49603606473243E-10  -4.34736290807320E-18
      2.96931571874999E-07
      0.00000000000000E+00  -1.41257205825176E-13   0.00000000000000E+00   2.59504430445232E-16   1.14578170146847E-22
      1.41254775648951E-10   1.41255035153496E-10  -1.28417466810370E-18  -7.61457291377806E-03  -7.61457291379295E-03
      0.00000000000000E+00   0.00000000000000E+00   1.48866202562568E-11   0.00000000000000E+00   1.48866202562568E-11
      5.66354421466298E-18  -5.46026177672445E-01  -5.45976992536017E-01   0.00000000000000E+00  -8.24082374768585E-13
     -1.50517510285630E-22  -1.55317573034835E-10  -1.56141655409754E-10  -4.37936954655929E-18
      2.98931571874999E-07
      0.00000000000000E+00  -1.50992747969174E-13   0.00000000000000E+00   3.47830427473423E-16   1.21571325545591E-22
      1.51001504734218E-10   1.51001852564767E-10  -1.28106426289016E-18  -8.27988196686319E-03  -8.27988196687656E-03
      0.00000000000000E+00   0.00000000000000E+00   1.33653371847255E-11   0.00000000000000E+00   1.33653371847255E-11
      5.69027488903244E-18  -5.66158298849026E-01  -5.66106523344427E-01   0.00000000000000E+00  -8.40866880010818E-13
     -1.53282219849615E-22  -1.63526322869328E-10  -1.64367189749492E-10  -4.40921062614227E-18
      3.00931571874999E-07
      0.00000000000000E+00  -1.74780534905923E-13   0.00000000000000E+00   9.14865825932368E-16   1.35545677958322E-22
      1.74802432795661E-10   1.74803347661623E-10  -1.27257002613532E-18  -1.14375082725509E-02  -1.14375082725591E-02
      0.00000000000000E+00   0.00000000000000E+00   8.19722341587907E-12   0.00000000000000E+00   8.19722341587907E-12
      5.70666933586419E-18  -5.85857985902965E-01  -5.85800341791013E-01   0.00000000000000E+00  -7.48994970873274E-13
     -1.55633083496116E-22  -1.82251576106473E-10  -1.83000571077502E-10  -4.43409930972887E-18
      3.02931571874999E-07
      0.00000000000000E+00  -3.23293474970494E-13   0.00000000000000E+00   5.33869952703697E-15   2.05225824861443E-22
      3.23305556562334E-10   3.23310895262066E-10  -1.22858895206753E-18  -3.04340711152243E-02  -3.04340711152024E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.19150982143888E-11   0.00000000000000E+00  -2.19150982143888E-11
      5.66283913943541E-18  -6.04941124150475E-01  -6.04846187748788E-01   0.00000000000000E+00   2.80377723706112E-14
     -1.55540611794504E-22  -3.01423834819892E-10  -3.01395797047677E-10  -4.43425018736789E-18
      3.04931571874999E-07
      0.00000000000000E+00  -7.13633608102483E-13   0.00000000000000E+00   1.17917215620688E-14   2.95781780862205E-22
      7.13622922926051E-10   7.13634714647909E-10  -1.15706289034867E-18  -5.97986835554381E-02  -5.97986835553906E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.74345462879409E-11   0.00000000000000E+00  -4.74345462879409E-11
      5.56797004685953E-18  -6.22942965145536E-01  -6.22733118273385E-01   0.00000000000000E+00   5.03309612859781E-13
     -1.53960461711862E-22  -6.66703477972673E-10  -6.66200168359967E-10  -4.41090715651085E-18
      3.06931571874999E-07
      0.00000000000000E+00  -1.47971056115046E-12   0.00000000000000E+00   2.07200202527638E-14   3.51909891685443E-22
      1.47971657291953E-09   1.47973729294014E-09  -1.08282521424000E-18  -8.94830780793946E-02  -8.94830780793370E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.76304312846284E-11   0.00000000000000E+00  -5.76304312846284E-11
      5.45270918429028E-18  -6.39127332823913E-01  -6.38679378474210E-01   0.00000000000000E+00   4.57556311177568E-13
     -1.52469456764034E-22  -1.42256441796653E-09  -1.42210686165551E-09  -4.36988397005028E-18
      3.08931571874999E-07
      0.00000000000000E+00  -2.87722008250019E-12   0.00000000000000E+00   3.60214054984606E-14   3.90741219578435E-22
      2.87720210587289E-09   2.87723812727878E-09  -1.01295277493717E-18  -1.18740552763413E-01  -1.18740552763345E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.83872538591191E-11   0.00000000000000E+00  -6.83872538591191E-11
      5.31593467657204E-18  -6.52307777168574E-01  -6.51423001596941E-01   0.00000000000000E+00   3.68806271944657E-13
     -1.51207604998562E-22  -2.80921967969145E-09  -2.80885087341965E-09  -4.30298190163486E-18
      3.09931571874999E-07
      0.00000000000000E+00  -3.92590329193573E-12   0.00000000000000E+00   5.31324072798272E-14   4.15078129637236E-22
      3.92583950312756E-09   3.92589263553526E-09  -9.79984096174379E-19  -1.33239942730665E-01  -1.33239942730589E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.57849702415708E-11   0.00000000000000E+00  -7.57849702415708E-11
      5.24014970633047E-18  -6.57814014739151E-01  -6.56601244448491E-01   0.00000000000000E+00   2.97541128643887E-13
     -1.50671629346827E-22  -3.85040520642217E-09  -3.85010766529368E-09  -4.26016561015609E-18
      3.11281571874999E-07
      0.00000000000000E+00  -5.75232773604461E-12   0.00000000000000E+00   6.80207028605370E-14   4.37143400388172E-22
      5.75224483363006E-09   5.75231285433336E-09  -9.39089281955903E-19  -1.52554838428412E-01  -1.52554838428325E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.62728470386886E-11   0.00000000000000E+00  -8.62728470386886E-11
      5.12368136282824E-18  -6.62758554586324E-01  -6.60973766228105E-01   0.00000000000000E+00   2.28680396443730E-13
     -1.50083035145487E-22  -5.66626868769096E-09  -5.66604000729467E-09  -4.18459208087233E-18
      3.13104071874999E-07
      0.00000000000000E+00  -9.02934795960916E-12   0.00000000000000E+00   8.98490976163980E-14   4.52293519557379E-22
      9.02928924983464E-09   9.02937909893271E-09  -8.89179163664496E-19  -1.78144174773551E-01  -1.78144174773451E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00689714335872E-10   0.00000000000000E+00  -1.00689714335872E-10
      4.94017435845111E-18  -6.63543502657123E-01  -6.60730975239498E-01   0.00000000000000E+00   2.17754967363374E-13
     -1.49285117011475E-22  -8.92890713956405E-09  -8.92868938459684E-09  -4.05099519478661E-18
      3.15104071874999E-07
      0.00000000000000E+00  -1.38461452024579E-11   0.00000000000000E+00   1.19858714889235E-13   4.58403944373768E-22
      1.38460045855233E-08   1.38461244442387E-08  -8.38957301744847E-19  -2.05644803274102E-01  -2.05644803273986E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15297721785331E-10   0.00000000000000E+00  -1.15297721785331E-10
      4.70957891488045E-18  -6.55081138609412E-01  -6.50755909029866E-01   0.00000000000000E+00   3.82789833776608E-13
     -1.47774629057654E-22  -1.37312095122870E-08  -1.37308267224534E-08  -3.87062161313560E-18
      3.17104071874999E-07
      0.00000000000000E+00  -2.01689206012985E-11   0.00000000000000E+00   1.57002765226669E-13   4.54307152449880E-22
      2.01687367518403E-08   2.01688937546060E-08  -7.91481002253008E-19  -2.32577357021238E-01  -2.32577357021111E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.27027278908771E-10   0.00000000000000E+00  -1.27027278908771E-10
      4.45552435706290E-18  -6.34548679401199E-01  -6.28235370654752E-01   0.00000000000000E+00   7.90267202927849E-13
     -1.44671475900662E-22  -2.00426567429000E-08  -2.00418664756972E-08  -3.66404335480990E-18
      3.19104071874999E-07
      0.00000000000000E+00  -2.83045274231412E-11   0.00000000000000E+00   2.01854633645876E-13   4.39590235442750E-22
      2.83043339372420E-08   2.83045357918761E-08  -7.45344828805312E-19  -2.58956665641974E-01  -2.58956665641839E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.35756777343338E-10   0.00000000000000E+00  -1.35756777343338E-10
      4.18401080237623E-18  -5.98651445798421E-01  -5.89777889904661E-01   0.00000000000000E+00   1.38603655773401E-12
     -1.38928345078424E-22  -2.81701650510904E-08  -2.81687790145328E-08  -3.43866597357092E-18
      3.21104071874999E-07
      0.00000000000000E+00  -3.85069163663649E-11   0.00000000000000E+00   2.53173807526343E-13   4.12588664486377E-22
      3.85067067647586E-08   3.85069599385665E-08  -6.99746715234921E-19  -2.84794121793936E-01  -2.84794121793793E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.43549316665969E-10   0.00000000000000E+00  -1.43549316665969E-10
      3.89691216904429E-18  -5.43653244167967E-01  -5.31567814536294E-01   0.00000000000000E+00   1.93739849176342E-12
     -1.29978881929502E-22  -3.83653480203922E-08  -3.83634106219005E-08  -3.19716545380937E-18
      3.23104071874999E-07
      0.00000000000000E+00  -5.05391280089741E-11   0.00000000000000E+00   2.98879312647602E-13   3.62891799281733E-22
      5.05388410795649E-08   5.05391399588779E-08  -6.54548342078259E-19  -3.10094591629148E-01  -3.10094591628994E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53881822954741E-10   0.00000000000000E+00  -1.53881822954741E-10
      3.58914852313481E-18  -4.66312926893890E-01  -4.50439692383244E-01   0.00000000000000E+00   2.11764067797951E-12
     -1.18816797891329E-22  -5.03873757766010E-08  -5.03852581359232E-08  -2.93460018105655E-18
      3.25104071874999E-07
      0.00000000000000E+00  -6.33494482652055E-11   0.00000000000000E+00   3.18741236813068E-13   2.87287262681319E-22
      6.33491069062873E-08   6.33494256475244E-08  -6.09856951696048E-19  -3.34863243770678E-01  -3.34863243770512E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.66702770307990E-10   0.00000000000000E+00  -1.66702770307990E-10
      3.25574298251883E-18  -3.65434931887753E-01  -3.45529283703046E-01   0.00000000000000E+00   1.92768394909499E-12
     -1.06793816092562E-22  -6.31846505611654E-08  -6.31827228772164E-08  -2.64588603082278E-18
      3.27104071874999E-07
      0.00000000000000E+00  -7.43944208275711E-11   0.00000000000000E+00   6.38303678219349E-13   2.23969309530823E-22
      7.43941729314791E-08   7.43948112351576E-08  -5.65791364207801E-19  -3.59105904324303E-01  -3.59105904324121E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.81719139208864E-10   0.00000000000000E+00  -1.81719139208864E-10
      2.89230470410110E-18  -2.44928067521998E-01  -2.21546693473399E-01   0.00000000000000E+00   1.13803326506371E-12
     -9.25494177239335E-23  -7.42142301292136E-08  -7.42130920959487E-08  -2.32651333989330E-18
      3.29104071874999E-07
      0.00000000000000E+00  -7.76367237404712E-11   0.00000000000000E+00   8.11319777611761E-14   1.23097539774685E-22
      7.76367012053233E-08   7.76367823373012E-08  -5.22946480666094E-19  -3.82811204161084E-01  -3.82811204160877E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.07682291782883E-10   0.00000000000000E+00  -2.07682291782883E-10
      2.47694012053534E-18  -1.20408961431293E-01  -9.60137808839081E-02   0.00000000000000E+00   8.98329487641745E-13
     -7.75232381878523E-23  -7.74299983750058E-08  -7.74291000455182E-08  -1.95399363986924E-18
      3.31104071874999E-07
      0.00000000000000E+00  -5.37844617982021E-11   0.00000000000000E+00  -5.92729938064265E-13   3.45770921424854E-23
      5.37850594198945E-08   5.37844666899564E-08  -4.72751546193057E-19  -4.06095426268000E-01  -4.06095426267821E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.79532224959980E-10   0.00000000000000E+00  -1.79532224959980E-10
      2.11787567061538E-18  -4.47839374420504E-02  -2.78947920644634E-02   0.00000000000000E+00   9.28126116714316E-13
     -3.22462070150518E-23  -5.36058625911131E-08  -5.36049344649964E-08  -1.64512412442232E-18
      3.33104071874999E-07
      0.00000000000000E+00  -2.88391556384262E-11   0.00000000000000E+00  -6.17339204803279E-13   1.13958649084246E-23
      2.88397442573231E-08   2.88391269181183E-08  -4.15005205850296E-19  -4.29027735264473E-01  -4.29027735264353E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20212678155111E-10   0.00000000000000E+00  -1.20212678155111E-10
      1.87745031430515E-18  -1.92177615602243E-02  -1.01693587759502E-02   0.00000000000000E+00   7.17986749000272E-13
     -1.20306745100354E-23  -2.87196322267122E-08  -2.87189142399632E-08  -1.46244510845486E-18
      3.35104071874999E-07
      0.00000000000000E+00  -1.97783967786921E-11   0.00000000000000E+00  -2.23405621734609E-13   5.95056643235616E-24
      1.97786627922410E-08   1.97784393866192E-08  -3.58927299610577E-19  -4.51534728306065E-01  -4.51534728305963E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01893660777878E-10   0.00000000000000E+00  -1.01893660777878E-10
      1.67366299274940E-18  -1.17878638206910E-02  -5.58841181021893E-03   0.00000000000000E+00   2.77373371438725E-13
     -6.60464816611006E-24  -1.96768230992128E-08  -1.96765457258414E-08  -1.31473569313882E-18
      3.36104071874999E-07
      0.00000000000000E+00  -1.77102369862530E-11   0.00000000000000E+00  -1.01711053323397E-13   4.79711820684211E-24
      1.77103563711601E-08   1.77102546601068E-08  -3.31707908853586E-19  -4.62675206443833E-01  -4.62675206443733E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00581703655838E-10   0.00000000000000E+00  -1.00581703655838E-10
      1.57308128909356E-18  -1.01416436034783E-02  -4.59339461886537E-03   0.00000000000000E+00   1.44991771697754E-13
     -5.40853903307235E-24  -1.76098179482226E-08  -1.76096729564509E-08  -1.24137338023997E-18
      3.37454071874999E-07
      0.00000000000000E+00  -1.67625829877457E-11   0.00000000000000E+00  -3.42837255674112E-14   4.07026260750377E-24
      1.67626236370200E-08   1.67625893532944E-08  -2.96124222087238E-19  -4.77509336460359E-01  -4.77509336460258E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00488800969417E-10   0.00000000000000E+00  -1.00488800969417E-10
      1.43742140778485E-18  -9.19591494091786E-03  -3.94621306109729E-03   0.00000000000000E+00   7.22688537569347E-14
     -4.54493941372557E-24  -1.66621728211788E-08  -1.66621005523250E-08  -1.14129718569761E-18
      3.39276571874999E-07
      0.00000000000000E+00  -1.63877646152018E-11   0.00000000000000E+00  -9.81971296189051E-15   3.52494161674668E-24
      1.63877278289651E-08   1.63877180092522E-08  -2.50029469895398E-19  -4.97164547263882E-01  -4.97164547263780E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02052545702286E-10   0.00000000000000E+00  -1.02052545702286E-10
      1.25143064324243E-18  -8.59919018804295E-03  -3.46808785481609E-03   0.00000000000000E+00   4.33937009601260E-14
     -3.87091320362557E-24  -1.62857088572509E-08  -1.62856654635499E-08  -1.00140117334703E-18
      3.41276571874999E-07
      0.00000000000000E+00  -1.62494464409673E-11   0.00000000000000E+00  -3.11419533635466E-15   3.13559015566667E-24
      1.62494350999687E-08   1.62494319857733E-08  -2.01813512454310E-19  -5.18295122832775E-01  -5.18295122832670E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04279435603599E-10   0.00000000000000E+00  -1.04279435603599E-10
      1.04287177203523E-18  -8.21959985999855E-03  -3.13276566612678E-03   0.00000000000000E+00   3.28390389671368E-14
     -3.37924690804027E-24  -1.61451853892087E-08  -1.61451525501697E-08  -8.41058259580922E-19
      3.43276571874999E-07
      0.00000000000000E+00  -1.61879104670382E-11   0.00000000000000E+00  -1.24950892050075E-15   2.85687226858390E-24
      1.61878830050263E-08   1.61878817555174E-08  -1.55918908128285E-19  -5.38995308965894E-01  -5.38995308965788E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06244697684158E-10   0.00000000000000E+00  -1.06244697684158E-10
      8.30382376666916E-19  -7.96290638829395E-03  -2.89608150198871E-03   0.00000000000000E+00   2.78283098182669E-14
     -3.02082207958632E-24  -1.60816648861430E-08  -1.60816370578332E-08  -6.74463468538632E-19
      3.45276571874999E-07
      0.00000000000000E+00  -1.61536523800598E-11   0.00000000000000E+00  -5.99491184892111E-16   2.64549626113957E-24
      1.61536420465103E-08   1.61536414470191E-08  -1.12198220652826E-19  -5.59272734697043E-01  -5.59272734696935E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07642434696155E-10   0.00000000000000E+00  -1.07642434696155E-10
      6.15097507274607E-19  -7.77458629358897E-03  -2.71898800618749E-03   0.00000000000000E+00   2.46331426758502E-14
     -2.74601096671838E-24  -1.60460236454656E-08  -1.60459990123229E-08  -5.02899286621782E-19
      3.47276571874999E-07
      0.00000000000000E+00  -1.61317933326044E-11   0.00000000000000E+00  -3.14556943316688E-16   2.47894796569788E-24
      1.61317625670558E-08   1.61317622524988E-08  -7.04985303538755E-20  -5.79128155047313E-01  -5.79128155047205E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08470627744284E-10   0.00000000000000E+00  -1.08470627744284E-10
      3.98156251786039E-19  -7.62959096349895E-03  -2.58114528421525E-03   0.00000000000000E+00   2.22580992264353E-14
     -2.52882329983640E-24  -1.60233138828538E-08  -1.60232916247546E-08  -3.27657721432164E-19
      3.49276571874999E-07
      0.00000000000000E+00  -1.61161797272791E-11   0.00000000000000E+00  -1.72596061977298E-16   2.34432612427725E-24
      1.61162098146377E-08   1.61162096420416E-08  -3.08107193480291E-20  -5.98490058016971E-01  -5.98490058016863E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08383855868908E-10   0.00000000000000E+00  -1.08383855868908E-10
      1.81388540048223E-19  -7.51394916247555E-03  -2.47037475953429E-03   0.00000000000000E+00   2.02887322273249E-14
     -2.35354528478784E-24  -1.60078460749049E-08  -1.60078257861727E-08  -1.50577820700193E-19
      3.51276571874999E-07
      0.00000000000000E+00  -1.60999232087934E-11   0.00000000000000E+00  -1.84057391047748E-16   2.23708328331581E-24
      1.60999187935992E-08   1.60999186095419E-08   6.29850352691853E-21  -6.16993208034681E-01  -6.16993208034575E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05711359128262E-10   0.00000000000000E+00  -1.05711359128262E-10
     -3.00341782083011E-20  -7.42413336920962E-03  -2.38484847770796E-03   0.00000000000000E+00   1.83325455961631E-14
     -2.21500420264333E-24  -1.59942255829592E-08  -1.59942072504136E-08   2.37356746813832E-20
      3.53276571874999E-07
      0.00000000000000E+00  -1.60722779428939E-11   0.00000000000000E+00  -5.14360883819405E-16   2.16142080841584E-24
      1.60723008331823E-08   1.60723003188214E-08   3.98544414906568E-20  -6.34038415124758E-01  -6.34038415124659E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.89734215795261E-11   0.00000000000000E+00  -9.89734215795261E-11
     -2.27981021367353E-19  -7.37424948947269E-03  -2.34154231410557E-03   0.00000000000000E+00   1.63407393249244E-14
     -2.11941979707062E-24  -1.59733432379813E-08  -1.59733268972419E-08   1.88126579876696E-19
      3.55276571874999E-07
      0.00000000000000E+00  -1.60518884112339E-11   0.00000000000000E+00  -3.64683374192085E-16   2.10233605280934E-24
      1.60519147816729E-08   1.60519144169895E-08   6.81660655148608E-20  -6.48649717336652E-01  -6.48649717336566E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.59971995632011E-11   0.00000000000000E+00  -8.59971995632011E-11
     -3.99975420493756E-19  -7.33768505757225E-03  -2.30731158714645E-03   0.00000000000000E+00   1.32656287460994E-14
     -2.04557905331980E-24  -1.59659304830550E-08  -1.59659172174263E-08   3.31809354978894E-19
      3.57276571874999E-07
      0.00000000000000E+00  -1.60236920769112E-11   0.00000000000000E+00  -6.02005269489782E-16   2.06040367527262E-24
      1.60237290550856E-08   1.60237284530803E-08   8.86516263255758E-20  -6.59347497313462E-01  -6.59347497313398E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.35907179309129E-11   0.00000000000000E+00  -6.35907179309129E-11
     -5.27156856355581E-19  -7.31116394461455E-03  -2.28261080110762E-03   0.00000000000000E+00   9.47155734754633E-15
     -1.99509065981120E-24  -1.59601472067067E-08  -1.59601377351494E-08   4.38505230030005E-19
      3.59276571874999E-07
      0.00000000000000E+00  -1.59828211688538E-11   0.00000000000000E+00  -9.67793617177974E-16   2.03871384131045E-24
      1.59827824594531E-08   1.59827814916595E-08   9.78921288818487E-20  -6.64205058313774E-01  -6.64205058313745E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.90513129625021E-11   0.00000000000000E+00  -2.90513129625021E-11
     -5.85259482280585E-19  -7.29574579887948E-03  -2.26921120644734E-03   0.00000000000000E+00   4.32890705333577E-15
     -1.97240434479674E-24  -1.59537345076041E-08  -1.59537301786970E-08   4.87367353398737E-19
      3.61276571874999E-07
      0.00000000000000E+00  -1.59266121896828E-11   0.00000000000000E+00  -1.41491481717340E-15   2.04265194691623E-24
      1.59265862498246E-08   1.59265848349098E-08   9.17861614481233E-20  -6.60988253465316E-01  -6.60988253465335E-01
      0.00000000000000E+00   0.00000000000000E+00   1.92095157599083E-11   0.00000000000000E+00   1.92095157599083E-11
     -5.46840450760769E-19  -7.29426747963703E-03  -2.27023339636555E-03   0.00000000000000E+00  -2.55473666087225E-15
     -1.98516426723963E-24  -1.59457917959331E-08  -1.59457943506697E-08   4.55054289312646E-19
      3.63276571874999E-07
      0.00000000000000E+00  -1.58528608657052E-11   0.00000000000000E+00  -1.45393725629520E-15   2.08201402133034E-24
      1.58529043505427E-08   1.58529028966054E-08   6.53322939511576E-20  -6.47166696376487E-01  -6.47166696376570E-01
      0.00000000000000E+00   0.00000000000000E+00   8.21101382316783E-11   0.00000000000000E+00   8.21101382316783E-11
     -3.82620174297412E-19  -7.31210325901912E-03  -2.29146696543432E-03   0.00000000000000E+00  -1.22605893414285E-14
     -2.04785436111300E-24  -1.59350007742478E-08  -1.59350130348371E-08   3.17287880346254E-19
      3.65276571874999E-07
      0.00000000000000E+00  -1.57587200100674E-11   0.00000000000000E+00   8.00236203215723E-15   2.17618075064408E-24
      1.57587350506819E-08   1.57587430530440E-08   1.18076005950582E-20  -6.19751909356020E-01  -6.19751909356180E-01
      0.00000000000000E+00   0.00000000000000E+00   1.60218074562671E-10   0.00000000000000E+00   1.60218074562671E-10
     -6.21840251720702E-20  -7.35929141975883E-03  -2.34371738740619E-03   0.00000000000000E+00  -3.51732358229888E-14
     -2.19124229697402E-24  -1.59189259543708E-08  -1.59189611276067E-08   5.03764245770117E-20
      3.67276571874999E-07
      0.00000000000000E+00  -1.55991857015380E-11   0.00000000000000E+00  -4.27905840070524E-15   2.41390834987484E-24
      1.55991649301016E-08   1.55991606510432E-08  -7.86146497316077E-20  -5.75194822106317E-01  -5.75194822106568E-01
      0.00000000000000E+00   0.00000000000000E+00   2.51620337192717E-10   0.00000000000000E+00   2.51620337192717E-10
      4.41056649213364E-19  -7.53718597043424E-03  -2.54309337380626E-03   0.00000000000000E+00  -4.31385638057599E-14
     -2.55890224582885E-24  -1.58507378496721E-08  -1.58507809882359E-08  -3.62441999481756E-19
      3.69276571874999E-07
      0.00000000000000E+00  -1.53391732505035E-11   0.00000000000000E+00  -7.43856105025119E-15   2.99767730172498E-24
      1.53391595784774E-08   1.53391521399163E-08  -2.20881987586678E-19  -5.09816563031304E-01  -5.09816563031647E-01
      0.00000000000000E+00   0.00000000000000E+00   3.42772236739244E-10   0.00000000000000E+00   3.42772236739244E-10
      1.12660112269185E-18  -8.04007269495875E-03  -3.09918819448605E-03   0.00000000000000E+00  -7.44332619955400E-14
     -3.58515388600099E-24  -1.56818499433935E-08  -1.56819243766555E-08  -9.05719135105174E-19
      3.71276571874999E-07
      0.00000000000000E+00  -1.44741795154830E-11   0.00000000000000E+00  -7.78254715966409E-14   4.65935268809314E-24
      1.44741681609474E-08   1.44740903354758E-08  -4.33192537652282E-19  -4.21181321693509E-01  -4.21181321693905E-01
      0.00000000000000E+00   0.00000000000000E+00   3.95917529039784E-10   0.00000000000000E+00   3.95917529039784E-10
      1.91843618077142E-18  -1.01180810723790E-02  -5.43300446487927E-03   0.00000000000000E+00  -7.93770534181902E-14
     -8.65694371733385E-24  -1.48699284874621E-08  -1.48700078645156E-08  -1.48524364311914E-18
      3.73276571874999E-07
      0.00000000000000E+00  -8.41931521507677E-12   0.00000000000000E+00  -1.50694263420433E-13   1.17791308925477E-24
      8.41955638450724E-09   8.41940569024383E-09  -6.99224378903476E-19  -3.09784689891626E-01  -3.09784689892027E-01
      0.00000000000000E+00   0.00000000000000E+00   4.01275698737862E-10   0.00000000000000E+00   4.01275698737862E-10
      2.72098757824714E-18  -2.39732422475693E-02  -2.11941535492522E-02   0.00000000000000E+00  -2.30508064199141E-13
     -5.06327026501124E-23  -8.82045088091744E-09  -8.82068138898170E-09  -2.02176319934367E-18
      3.75276571874999E-07
      0.00000000000000E+00  -6.87274168523923E-13   0.00000000000000E+00  -2.02509166975489E-13  -3.75119584365016E-23
      6.87462639141533E-10   6.87260129974520E-10  -9.63633657526077E-19  -1.84415370150521E-01  -1.84415370150921E-01
      0.00000000000000E+00   0.00000000000000E+00   4.00491422710516E-10   0.00000000000000E+00   4.00491422710516E-10
      3.52197042366818E-18  -5.26563158274401E-02  -5.23136057915328E-02   0.00000000000000E+00  -6.30652694831634E-13
     -8.64583548891744E-23  -1.08712089999012E-09  -1.08775155268504E-09  -2.55833676614210E-18
      3.77276571874999E-07
      0.00000000000000E+00   7.95375424217182E-14   0.00000000000000E+00  -2.62584538576620E-14  -4.53641893969963E-23
     -7.94348437251971E-11  -7.94611021791001E-11  -1.18416002870112E-18  -7.52596766698866E-02  -7.52596766702083E-02
      0.00000000000000E+00   0.00000000000000E+00   3.21725542571089E-10   0.00000000000000E+00   3.21725542571089E-10
      4.16542150881035E-18  -8.24127141032355E-02  -8.23363861808812E-02   0.00000000000000E+00  -1.24172366885585E-12
     -9.83149329774092E-23  -2.41022716723034E-10  -2.42264440391988E-10  -2.98126148010924E-18
      3.79276571874999E-07
      0.00000000000000E+00   4.78511080851214E-14   0.00000000000000E+00  -2.52079150201897E-15  -4.63093221256629E-23
     -4.78921654706656E-11  -4.78946862622140E-11  -1.27847929790948E-18  -2.87115901948991E-02  -2.87115901950751E-02
      0.00000000000000E+00   0.00000000000000E+00   1.75979220034834E-10   0.00000000000000E+00   1.75979220034834E-10
      4.51737994888003E-18  -1.11789460874954E-01  -1.11749106771617E-01   0.00000000000000E+00  -8.80569585416667E-13
     -1.04656661547238E-22  -1.27203964187099E-10  -1.28084533772620E-10  -3.23890065097055E-18
      3.81276571874999E-07
      0.00000000000000E+00   9.91923161841289E-15   0.00000000000000E+00   5.88634765944285E-16  -4.63648341522420E-23
     -9.94945410515777E-12  -9.94886547043818E-12  -1.30973428236528E-18  -1.45255272729365E-02  -1.45255272730362E-02
      0.00000000000000E+00   0.00000000000000E+00   9.96772525752381E-11   0.00000000000000E+00   9.96772525752381E-11
      4.71673445403050E-18  -1.40639937746117E-01  -1.40611668394969E-01   0.00000000000000E+00  -5.22950700083227E-13
     -1.07860026902660E-22  -8.92054364046092E-11  -8.97283871048003E-11  -3.40700017166522E-18
      3.82276571874999E-07
      0.00000000000000E+00  -3.67378948830107E-15   0.00000000000000E+00   9.95996852827872E-16  -4.62390510615620E-23
      3.64451936781251E-12   3.64551536461910E-12  -1.31703754681061E-18  -1.14312997241385E-02  -1.14312997242157E-02
      0.00000000000000E+00   0.00000000000000E+00   7.72200412580854E-11   0.00000000000000E+00   7.72200412580854E-11
      4.79395449528858E-18  -1.54922516292731E-01  -1.54897039352504E-01   0.00000000000000E+00  -4.36196847427047E-13
     -1.09121777481620E-22  -8.04293597751690E-11  -8.08655566227052E-11  -3.47691694847797E-18
      3.83626571874999E-07
      0.00000000000000E+00  -1.60728290113172E-14   0.00000000000000E+00   9.57683792943230E-16  -4.58701228164913E-23
      1.60833551493277E-11   1.60843128330748E-11  -1.32055293841671E-18  -9.78879077320923E-03  -9.78879077327039E-03
      0.00000000000000E+00   0.00000000000000E+00   6.11651165033708E-11   0.00000000000000E+00   6.11651165033708E-11
      4.87652740256813E-18  -1.73936789681257E-01  -1.73912452148258E-01   0.00000000000000E+00  -4.07170684341700E-13
     -1.10665526723862E-22  -7.68422586519920E-11  -7.72494293364443E-11  -3.55597446415143E-18
      3.85449071874999E-07
      0.00000000000000E+00  -2.83800237971258E-14   0.00000000000000E+00   7.64931966117415E-16  -4.48859964515418E-23
      2.83715899306948E-11   2.83723548626160E-11  -1.32079667979645E-18  -8.89521516386980E-03  -8.89521516391888E-03
      0.00000000000000E+00   0.00000000000000E+00   4.90743762600107E-11   0.00000000000000E+00   4.90743762600107E-11
      4.96596545330200E-18  -1.99121540864225E-01  -1.99097141334927E-01   0.00000000000000E+00  -4.16856632876547E-13
     -1.12732215102001E-22  -7.70298744896377E-11  -7.74467311226270E-11  -3.64516877350555E-18
      3.87449071874999E-07
      0.00000000000000E+00  -3.93095475248215E-14   0.00000000000000E+00   5.87885294803970E-16  -4.27622575588835E-23
      3.92963961508438E-11   3.92969840360958E-11  -1.31883895183801E-18  -8.39807021208067E-03  -8.39807021212145E-03
      0.00000000000000E+00   0.00000000000000E+00   4.07831558165959E-11   0.00000000000000E+00   4.07831558165959E-11
      5.04753176493519E-18  -2.26187929597057E-01  -2.26162700607949E-01   0.00000000000000E+00  -4.37697316319039E-13
     -1.15037176307315E-22  -7.96424425362582E-11  -8.00801398526922E-11  -3.72869281309719E-18
      3.89449071874999E-07
      0.00000000000000E+00  -4.87695554571967E-14   0.00000000000000E+00   4.66143644478890E-16  -3.89672316544288E-23
      4.87891218228400E-11   4.87895879664455E-11  -1.31597523779678E-18  -8.08638381026348E-03  -8.08638381029866E-03
      0.00000000000000E+00   0.00000000000000E+00   3.51806972684104E-11   0.00000000000000E+00   3.51806972684104E-11
      5.11789315947202E-18  -2.52697957445618E-01  -2.52671503095928E-01   0.00000000000000E+00  -4.57808451510570E-13
     -1.17377377236753E-22  -8.35124767832281E-11  -8.39702852348560E-11  -3.80191792167523E-18
      3.91449071874999E-07
      0.00000000000000E+00  -5.74029607547042E-14   0.00000000000000E+00   3.86223327492274E-16  -3.28822665892241E-23
      5.73727508676009E-11   5.73731370908955E-11  -1.31282095773574E-18  -7.86640407222104E-03  -7.86640407225226E-03
      0.00000000000000E+00   0.00000000000000E+00   3.12281186938679E-11   0.00000000000000E+00   3.12281186938679E-11
      5.18034939685975E-18  -2.78664155066466E-01  -2.78636241998385E-01   0.00000000000000E+00  -4.75635592787471E-13
     -1.19744119340918E-22  -8.81256201918564E-11  -8.86012557847636E-11  -3.86752843912401E-18
      3.93449071874999E-07
      0.00000000000000E+00  -6.53016081545515E-14   0.00000000000000E+00   3.34219560474373E-16  -2.39625275504028E-23
      6.53458178438547E-11   6.53461520633912E-11  -1.30966807629031E-18  -7.70097247607505E-03  -7.70097247610338E-03
      0.00000000000000E+00   0.00000000000000E+00   2.83327872409310E-11   0.00000000000000E+00   2.83327872409310E-11
      5.23701497134161E-18  -3.04092804831185E-01  -3.04063292346155E-01   0.00000000000000E+00  -4.92458377426028E-13
     -1.22133483913429E-22  -9.31864809267737E-11  -9.36789393043218E-11  -3.92734689505130E-18
      3.95449071874999E-07
      0.00000000000000E+00  -7.29247213427762E-14   0.00000000000000E+00   2.98954042792587E-16  -1.19087395923124E-23
      7.29056653443906E-11   7.29059642984215E-11  -1.30664698141987E-18  -7.57130248744882E-03  -7.57130248747495E-03
      0.00000000000000E+00   0.00000000000000E+00   2.61241790914176E-11   0.00000000000000E+00   2.61241790914176E-11
      5.28926332952445E-18  -3.28987476591856E-01  -3.28956278554028E-01   0.00000000000000E+00  -5.09749475404703E-13
     -1.24547440881960E-22  -9.85203939143097E-11  -9.90301433898389E-11  -3.98261634810458E-18
      3.97449071874999E-07
      0.00000000000000E+00  -8.01804555821709E-14   0.00000000000000E+00   2.75509568501863E-16   3.10624524280652E-24
      8.01888862317971E-11   8.01891617413687E-11  -1.30380568404591E-18  -7.46646860950517E-03  -7.46646860952954E-03
      0.00000000000000E+00   0.00000000000000E+00   2.43653925801542E-11   0.00000000000000E+00   2.43653925801542E-11
      5.33799411468476E-18  -3.53356585042328E-01  -3.53323646920437E-01   0.00000000000000E+00  -5.28900877019719E-13
     -1.26993025846317E-22  -1.04025653444376E-10  -1.04554554321523E-10  -4.03418843063885E-18
      3.99449071874999E-07
      0.00000000000000E+00  -8.73443450843579E-14   0.00000000000000E+00   2.62680447123087E-16   1.97477157236208E-23
      8.73457575249829E-11   8.73460202054498E-11  -1.30111320238360E-18  -7.39892044852355E-03  -7.39892044854640E-03
      0.00000000000000E+00   0.00000000000000E+00   2.28477124345307E-11   0.00000000000000E+00   2.28477124345307E-11
      5.38368953955382E-18  -3.77189006398985E-01  -3.77154292076179E-01   0.00000000000000E+00  -5.49691768859157E-13
     -1.29474600445338E-22  -1.09644040870992E-10  -1.10193732639981E-10  -4.08257633717022E-18
      4.01449071874999E-07
      0.00000000000000E+00  -9.44163898493375E-14   0.00000000000000E+00   2.52833375691930E-16   3.67532848258687E-23
      9.44048763344655E-11   9.44051291678780E-11  -1.29857127394698E-18  -7.35569647032268E-03  -7.35569647034425E-03
      0.00000000000000E+00   0.00000000000000E+00   2.15776749409982E-11   0.00000000000000E+00   2.15776749409982E-11
      5.42684488943582E-18  -4.00554776400353E-01  -4.00518238695696E-01   0.00000000000000E+00  -5.75979069315345E-13
     -1.32011542389466E-22  -1.15406825039429E-10  -1.15982804108876E-10  -4.12827361548884E-18
      4.03449071874999E-07
      0.00000000000000E+00  -1.01396589877110E-13   0.00000000000000E+00   2.45148176036163E-16   5.31911977519346E-23
      1.01400920828865E-10   1.01401165977095E-10  -1.29617770703129E-18  -7.32382402782008E-03  -7.32382402784062E-03
      0.00000000000000E+00   0.00000000000000E+00   2.05333828775542E-11   0.00000000000000E+00   2.05333828775542E-11
      5.46791165519093E-18  -4.23578686847317E-01  -4.23540274559169E-01   0.00000000000000E+00  -6.10341907590347E-13
     -1.34630236249435E-22  -1.21324206946924E-10  -1.21934548854649E-10  -4.17173394815963E-18
      4.05449071874999E-07
      0.00000000000000E+00  -1.08376789904882E-13   0.00000000000000E+00   2.38705164177436E-16   6.82741324428043E-23
      1.08337436059781E-10   1.08337674765014E-10  -1.29392045376051E-18  -7.30235968642644E-03  -7.30235968644595E-03
      0.00000000000000E+00   0.00000000000000E+00   1.95142492335406E-11   0.00000000000000E+00   1.95142492335406E-11
      5.50694015365801E-18  -4.46191117370752E-01  -4.46150841381943E-01   0.00000000000000E+00  -6.45992518703375E-13
     -1.37322939216856E-22  -1.27205931479714E-10  -1.27851923998555E-10  -4.21301969989750E-18
      4.07449071874999E-07
      0.00000000000000E+00  -1.15265145195446E-13   0.00000000000000E+00   2.33407573770599E-16   8.15066440060508E-23
      1.15219424256925E-10   1.15219657664580E-10  -1.29178187950909E-18  -7.29316495029910E-03  -7.29316495031761E-03
      0.00000000000000E+00   0.00000000000000E+00   1.85165566141321E-11   0.00000000000000E+00   1.85165566141321E-11
      5.54397326688627E-18  -4.68356958887029E-01  -4.68314829678586E-01   0.00000000000000E+00  -6.83474928481270E-13
     -1.40081060869740E-22  -1.33052739350091E-10  -1.33736214278713E-10  -4.25219138737718E-18
      4.09449071874999E-07
      0.00000000000000E+00  -1.22061655748803E-13   0.00000000000000E+00   2.29476106422898E-16   9.27148569631108E-23
      1.22061819502645E-10   1.22062048978844E-10  -1.28973983474149E-18  -7.30006855432995E-03  -7.30006855434750E-03
      0.00000000000000E+00   0.00000000000000E+00   1.75517276344870E-11   0.00000000000000E+00   1.75517276344870E-11
      5.57907672215524E-18  -4.90073862414135E-01  -4.90029882167571E-01   0.00000000000000E+00  -7.23000119358405E-13
     -1.42893851919356E-22  -1.38890776493829E-10  -1.39613776613330E-10  -4.28933688741376E-18
      4.11449071874999E-07
      0.00000000000000E+00  -1.28858166302160E-13   0.00000000000000E+00   2.27545524011653E-16   1.01987756108630E-22
      1.28898280637059E-10   1.28898508182685E-10  -1.28776498562362E-18  -7.33045620945823E-03  -7.33045620947485E-03
      0.00000000000000E+00   0.00000000000000E+00   1.66206174312697E-11   0.00000000000000E+00   1.66206174312697E-11
      5.61231795701778E-18  -5.11348725579438E-01  -5.11302885607963E-01   0.00000000000000E+00  -7.63572165041949E-13
     -1.45744748671534E-22  -1.44755553448767E-10  -1.45519125613955E-10  -4.32455297139417E-18
      4.13449071874999E-07
      0.00000000000000E+00  -1.35930211067140E-13   0.00000000000000E+00   2.34091660261948E-16   1.09662619345798E-22
      1.35916629032750E-10   1.35916863124520E-10  -1.28576318956727E-18  -7.42203738713852E-03  -7.42203738715420E-03
      0.00000000000000E+00   0.00000000000000E+00   1.56756493880957E-11   0.00000000000000E+00   1.56756493880957E-11
      5.64366925579397E-18  -5.32190398660457E-01  -5.32142646102484E-01   0.00000000000000E+00  -8.02483737254522E-13
     -1.48607937969724E-22  -1.50790028775213E-10  -1.51592512512616E-10  -4.35790606622670E-18
      4.15449071874999E-07
      0.00000000000000E+00  -1.43828858466987E-13   0.00000000000000E+00   2.71255336079950E-16   1.16440711159620E-22
      1.43814048231962E-10   1.43814319487415E-10  -1.28342339432471E-18  -7.71147729484654E-03  -7.71147729486109E-03
      0.00000000000000E+00   0.00000000000000E+00   1.45441072827327E-11   0.00000000000000E+00   1.45441072827327E-11
      5.67275747035944E-18  -5.52607052166952E-01  -5.52557168955144E-01   0.00000000000000E+00  -8.33350046970132E-13
     -1.51440464030335E-22  -1.57525076723025E-10  -1.58358426770147E-10  -4.38933407603473E-18
      4.17449071874999E-07
      0.00000000000000E+00  -1.54942071669098E-13   0.00000000000000E+00   4.05141827033223E-16   1.23931891732619E-22
      1.54932837067371E-10   1.54933242209322E-10  -1.27976936054677E-18  -8.63583062360224E-03  -8.63583062361492E-03
      0.00000000000000E+00   0.00000000000000E+00   1.26827135334705E-11   0.00000000000000E+00   1.26827135334705E-11
      5.69812289742638E-18  -5.72603230323570E-01  -5.72550431704625E-01   0.00000000000000E+00  -8.39088202789819E-13
     -1.54155077297092E-22  -1.66776867539849E-10  -1.67615955742793E-10  -4.41835353687961E-18
      4.19449071874999E-07
      0.00000000000000E+00  -1.91220742866071E-13   0.00000000000000E+00   1.40077799231365E-15   1.44453913398398E-22
      1.91248092938204E-10   1.91249493716341E-10  -1.26687052542632E-18  -1.38088894567617E-02  -1.38088894567660E-02
      0.00000000000000E+00   0.00000000000000E+00   4.34696043335179E-12   0.00000000000000E+00   4.34696043335179E-12
      5.70681681829308E-18  -5.92151805622376E-01  -5.92090194228447E-01   0.00000000000000E+00  -6.55289370437155E-13
     -1.56184489159119E-22  -1.94941164779100E-10  -1.95596454149693E-10  -4.43994629286677E-18
      4.21449071874999E-07
      0.00000000000000E+00  -3.99065383166704E-13   0.00000000000000E+00   7.13509099730308E-15   2.31594079456059E-22
      3.99111855798180E-10   3.99118990889409E-10  -1.21135338466495E-18  -3.76793382171906E-02  -3.76793382171587E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.18500159558459E-11   0.00000000000000E+00  -3.18500159558459E-11
      5.64311678638139E-18  -6.10983753464529E-01  -6.10868067900429E-01   0.00000000000000E+00   2.68030679696743E-13
     -1.55355199150940E-22  -3.67537005613104E-10  -3.67268974933563E-10  -4.43176340171644E-18
      4.23449071874999E-07
      0.00000000000000E+00  -8.65820337655355E-13   0.00000000000000E+00   1.35939037376613E-14   3.13350961164749E-22
      8.65818914974537E-10   8.65832508878588E-10  -1.13797974993772E-18  -6.73767553513670E-02  -6.73767553513166E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.04353903341798E-11   0.00000000000000E+00  -5.04353903341798E-11
      5.54224600571303E-18  -6.28578114259319E-01  -6.28321271368156E-01   0.00000000000000E+00   5.05548396168583E-13
     -1.53760779387809E-22  -8.15902666940423E-10  -8.15397118544409E-10  -4.40426625577531E-18
      4.25449071874999E-07
      0.00000000000000E+00  -1.76791934650768E-12   0.00000000000000E+00   2.39957076721442E-14   3.63115197107935E-22
      1.76787972215583E-09   1.76790371786387E-09  -1.06438176454403E-18  -9.69711452108352E-02  -9.69711452107750E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.01990579116132E-11   0.00000000000000E+00  -6.01990579116132E-11
      5.42184788988981E-18  -6.44098782787644E-01  -6.43560866509276E-01   0.00000000000000E+00   4.38583264243648E-13
     -1.52320951088728E-22  -1.70814324321635E-09  -1.70770465995225E-09  -4.35746612534578E-18
      4.26449071874999E-07
      0.00000000000000E+00  -2.48035897302647E-12   0.00000000000000E+00   3.67143544058074E-14   3.90781291289869E-22
      2.48036641967730E-09   2.48040313403210E-09  -1.02879801833260E-18  -1.11667338925423E-01  -1.11667338925356E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.63432768230088E-11   0.00000000000000E+00  -6.63432768230088E-11
      5.35550461306680E-18  -6.51091090794948E-01  -6.50330674451499E-01   0.00000000000000E+00   3.77642956256538E-13
     -1.51676670320109E-22  -2.41443750016519E-09  -2.41405985720908E-09  -4.32670659473420E-18
      4.27799071874999E-07
      0.00000000000000E+00  -3.78565637821984E-12   0.00000000000000E+00   4.91224021916318E-14   4.17261024454104E-22
      3.78561766956615E-09   3.78566679196876E-09  -9.84071964797004E-19  -1.31269533271625E-01  -1.31269533271549E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.51574640521343E-11   0.00000000000000E+00  -7.51574640521343E-11
      5.25404203659642E-18  -6.58698960109121E-01  -6.57530164393272E-01   0.00000000000000E+00   3.02752578340567E-13
     -1.50950821609656E-22  -3.71081208049481E-09  -3.71050932791662E-09  -4.26997007179941E-18
      4.29621571874999E-07
      0.00000000000000E+00  -6.27464875654381E-12   0.00000000000000E+00   6.86350206956289E-14   4.38605663087673E-22
      6.27461078498169E-09   6.27467942000282E-09  -9.29718283410409E-19  -1.57256956980163E-01  -1.57256956980075E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.85911304319038E-11   0.00000000000000E+00  -8.85911304319038E-11
      5.09258470138427E-18  -6.64407722641036E-01  -6.62459120777376E-01   0.00000000000000E+00   2.29882124351331E-13
     -1.50155009257529E-22  -6.18631817169513E-09  -6.18608828957093E-09  -4.16286641797386E-18
      4.31621571874999E-07
      0.00000000000000E+00  -1.01189020771021E-11   0.00000000000000E+00   9.58734480831472E-14   4.52922350692290E-22
      1.01188362173877E-08   1.01189320908362E-08  -8.76118837172595E-19  -1.85190594006495E-01  -1.85190594006390E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04229310895934E-10   0.00000000000000E+00  -1.04229310895934E-10
      4.88412607959240E-18  -6.63130930690087E-01  -6.59976307652885E-01   0.00000000000000E+00   2.49381675392515E-13
     -1.49162590559150E-22  -1.00149521616155E-08  -1.00147027799403E-08  -4.00800724241981E-18
      4.33621571874999E-07
      0.00000000000000E+00  -1.53019761319344E-11   0.00000000000000E+00   1.28856793082585E-13   4.57611759246477E-22
      1.53018223151028E-08   1.53019511718963E-08  -8.26696558100145E-19  -2.12545755752448E-01  -2.12545755752330E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18400022976071E-10   0.00000000000000E+00  -1.18400022976071E-10
      4.64732603364026E-18  -6.51860844680995E-01  -6.47077994000977E-01   0.00000000000000E+00   4.69301747899923E-13
     -1.47328907081811E-22  -1.51840204506680E-08  -1.51835511489202E-08  -3.82062947554012E-18
      4.35621571874999E-07
      0.00000000000000E+00  -2.20626672377805E-11   0.00000000000000E+00   1.67824031734675E-13   4.51322863837005E-22
      2.20624690155903E-08   2.20626368396225E-08  -7.79649762332270E-19  -2.39336483626501E-01  -2.39336483626371E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.29389323330543E-10   0.00000000000000E+00  -1.29389323330543E-10
      4.38854738697917E-18  -6.27723510418419E-01  -6.20814372669065E-01   0.00000000000000E+00   9.36016601051902E-13
     -1.43634743982677E-22  -2.19341835328929E-08  -2.19332475162920E-08  -3.60889762464691E-18
      4.37621571874999E-07
      0.00000000000000E+00  -3.07176560485317E-11   0.00000000000000E+00   2.14731762379907E-13   4.34056943987006E-22
      3.07174771353116E-08   3.07176918670744E-08  -7.33690586228544E-19  -2.65577258970766E-01  -2.65577258970628E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.37658398034723E-10   0.00000000000000E+00  -1.37658398034723E-10
      4.11323059090973E-18  -5.87279457375962E-01  -5.77646249477884E-01   0.00000000000000E+00   1.55100106862715E-12
     -1.37072233116358E-22  -3.05815844701081E-08  -3.05800334690396E-08  -3.37954000468119E-18
      4.39621571874999E-07
      0.00000000000000E+00  -4.14498972807057E-11   0.00000000000000E+00   2.66369424473808E-13   4.02949179163138E-22
      4.14496671273827E-08   4.14499334968076E-08  -6.88179248195242E-19  -2.91278000973458E-01  -2.91278000973312E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.45787835598311E-10   0.00000000000000E+00  -1.45787835598311E-10
      3.82165491971311E-18  -5.26784301312143E-01  -5.13772341558373E-01   0.00000000000000E+00   2.03734013883467E-12
     -1.27359578952570E-22  -4.13061830013481E-08  -4.13041456612094E-08  -3.13347567151787E-18
      4.41621571874999E-07
      0.00000000000000E+00  -5.38159645430643E-11   0.00000000000000E+00   3.07287822851607E-13   3.45289728517834E-22
      5.38156561307575E-08   5.38159634185807E-08  -6.43110047195940E-19  -3.16442377871624E-01  -3.16442377871467E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.57097169314755E-10   0.00000000000000E+00  -1.57097169314755E-10
      3.50746058108360E-18  -4.43379876666900E-01  -4.26475172425480E-01   0.00000000000000E+00   2.09972388885029E-12
     -1.15912746510920E-22  -5.36609659731546E-08  -5.36588662492659E-08  -2.86435053388766E-18
      4.43621571874999E-07
      0.00000000000000E+00  -6.65575849358644E-11   0.00000000000000E+00   3.17192783573110E-13   2.69594993109956E-22
      6.65572442300501E-08   6.65575614228340E-08  -5.98541829606119E-19  -3.41077444426207E-01  -3.41077444426037E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.69953180915432E-10   0.00000000000000E+00  -1.69953180915432E-10
      3.16755421925273E-18  -3.36669253680446E-01  -3.15753727825245E-01   0.00000000000000E+00   1.85529472604305E-12
     -1.03489895065769E-22  -6.63894635366445E-08  -6.63876082419186E-08  -2.56901238964661E-18
      4.45621571874999E-07
      0.00000000000000E+00  -7.62875245508926E-11   0.00000000000000E+00   2.42770377992874E-13   2.04675555418289E-22
      7.62872903797762E-08   7.62875331501544E-08  -5.54769925166940E-19  -3.65183841011603E-01  -3.65183841011415E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.87642373642144E-10   0.00000000000000E+00  -1.87642373642144E-10
      2.79226947196845E-18  -2.13022219377287E-01  -1.89046131258433E-01   0.00000000000000E+00   1.34619534682722E-12
     -8.88276528188032E-23  -7.61012369718589E-08  -7.60998907765122E-08  -2.23749954680151E-18
      4.47621571874999E-07
      0.00000000000000E+00  -7.50497330275468E-11   0.00000000000000E+00  -2.94029962421039E-14   9.20472232643119E-23
      7.50496886845858E-08   7.50496592815897E-08  -5.11652709814200E-19  -3.88761355713840E-01  -3.88761355713629E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.10612812477465E-10   0.00000000000000E+00  -2.10612812477465E-10
      2.37104384701352E-18  -9.41620095233129E-02  -7.05827995362803E-02   0.00000000000000E+00   8.22571293428797E-13
     -6.90081597530137E-23  -7.48398690404056E-08  -7.48390464691122E-08  -1.85939113719932E-18
      4.49621571874999E-07
      0.00000000000000E+00  -4.55480094549055E-11   0.00000000000000E+00  -7.22048079578089E-13   2.50577852252841E-23
      4.55486965418051E-08   4.55479744937255E-08  -4.58155705128982E-19  -4.11962518361761E-01  -4.11962518361600E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.60876491083431E-10   0.00000000000000E+00  -1.60876491083431E-10
      2.04929086484665E-18  -3.50933030102436E-02  -2.07933188811321E-02   0.00000000000000E+00   9.58727891247364E-13
     -2.41201079748041E-23  -4.53880567305333E-08  -4.53870980026421E-08  -1.59113515971767E-18
      4.50621571874999E-07
      0.00000000000000E+00  -3.02728519862357E-11   0.00000000000000E+00  -7.55764465032174E-13   1.27251528293068E-23
      3.02735840408000E-08   3.02728282763350E-08  -4.28803681576190E-19  -4.23482072366596E-01  -4.23482072366472E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.23736409642345E-10   0.00000000000000E+00  -1.23736409642345E-10
      1.92555445520431E-18  -2.08729160096354E-02  -1.13739135970342E-02   0.00000000000000E+00   8.57386751368022E-13
     -1.37205704373666E-23  -3.01499492534440E-08  -3.01490918666926E-08  -1.49675077362812E-18
      4.51971571874999E-07
      0.00000000000000E+00  -2.15041593908215E-11   0.00000000000000E+00  -3.20546139911963E-13   7.30765828841387E-24
      2.15044174978443E-08   2.15040969517044E-08  -3.90156916197824E-19  -4.38846492781654E-01  -4.38846492781549E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04574675964748E-10   0.00000000000000E+00  -1.04574675964748E-10
      1.78437864265190E-18  -1.35274408685572E-02  -6.78513786267616E-03   0.00000000000000E+00   3.83130385500916E-13
     -8.17858431132058E-24  -2.13999054061252E-08  -2.13995222757397E-08  -1.39422172645408E-18
      4.53794071874999E-07
      0.00000000000000E+00  -1.78215528077485E-11   0.00000000000000E+00  -9.93572544542249E-14   4.98587731699894E-24
      1.78216544940226E-08   1.78215551367681E-08  -3.40070663177794E-19  -4.59217471426982E-01  -4.59217471426883E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.90402918888158E-11   0.00000000000000E+00  -9.90402918888158E-11
      1.60387771068453E-18  -1.03218647804123E-02  -4.73806364732552E-03   0.00000000000000E+00   1.45273170540612E-13
     -5.57050249511740E-24  -1.77226601180499E-08  -1.77225148448793E-08  -1.26380704750674E-18
      4.55794071874999E-07
      0.00000000000000E+00  -1.66860763216518E-11   0.00000000000000E+00  -2.76597699759570E-14   3.96240933168651E-24
      1.66860980313861E-08   1.66860703716161E-08  -2.87569000848112E-19  -4.81120692781556E-01  -4.81120692781455E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00007863832276E-10   0.00000000000000E+00  -1.00007863832276E-10
      1.40386198301998E-18  -9.07152772964922E-03  -3.84578239347504E-03   0.00000000000000E+00   6.54352532696120E-14
     -4.39350793613154E-24  -1.65861279430371E-08  -1.65860625077838E-08  -1.11629298217187E-18
      4.57794071874999E-07
      0.00000000000000E+00  -1.63501082729467E-11   0.00000000000000E+00  -7.96628711016091E-15   3.41446208045688E-24
      1.63501224252043E-08   1.63501144589172E-08  -2.37545480763189E-19  -5.02578000951354E-01  -5.02578000951252E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02504615236169E-10   0.00000000000000E+00  -1.02504615236169E-10
      1.19885275254764E-18  -8.49127470122419E-03  -3.37216167385852E-03   0.00000000000000E+00   4.06088658289104E-14
     -3.73018459065948E-24  -1.62476504525469E-08  -1.62476098436811E-08  -9.61307271784453E-19
      4.59794071874999E-07
      0.00000000000000E+00  -1.62319040961606E-11   0.00000000000000E+00  -2.62757701477010E-15   3.05693393135780E-24
      1.62318612771622E-08   1.62318586495852E-08  -1.89930940236263E-19  -5.23598347688102E-01  -5.23598347687997E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04836647034607E-10   0.00000000000000E+00  -1.04836647034607E-10
      9.89179458478429E-19  -8.14686234084488E-03  -3.06573981147251E-03   0.00000000000000E+00   3.14903570755651E-14
     -3.27861514687856E-24  -1.61270534929077E-08  -1.61270220025506E-08  -7.99248518242166E-19
      4.61794071874999E-07
      0.00000000000000E+00  -1.61779912354198E-11   0.00000000000000E+00  -1.06696620601715E-15   2.79796114584165E-24
      1.61779660144463E-08   1.61779649474801E-08  -1.44603741522395E-19  -5.44190437004008E-01  -5.44190437003901E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06654948141416E-10   0.00000000000000E+00  -1.06654948141416E-10
      7.75869562195597E-19  -7.91007399129904E-03  -2.84650237926583E-03   0.00000000000000E+00   2.69485242665630E-14
     -2.94438829255087E-24  -1.60713369478629E-08  -1.60713099993387E-08  -6.31265820673202E-19
      4.63794071874999E-07
      0.00000000000000E+00  -1.61473150931925E-11   0.00000000000000E+00  -5.15644357718809E-16   2.59955719609989E-24
      1.61473421849289E-08   1.61473416692846E-08  -1.01410246600303E-19  -5.64361178397534E-01  -5.64361178397426E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07908589786690E-10   0.00000000000000E+00  -1.07908589786690E-10
      5.60052382622218E-19  -7.73435859427178E-03  -2.68082855376756E-03   0.00000000000000E+00   2.39796828591106E-14
     -2.68611446271675E-24  -1.60394570591808E-08  -1.60394330794979E-08  -4.58642136021914E-19
      4.65794071874999E-07
      0.00000000000000E+00  -1.61274766299557E-11   0.00000000000000E+00  -2.70305923023411E-16   2.44206051491698E-24
      1.61274434207223E-08   1.61274431504164E-08  -6.02064682798902E-20  -5.84105992829110E-01  -5.84105992829002E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08578693805631E-10   0.00000000000000E+00  -1.08578693805631E-10
      3.42894995010956E-19  -7.59783028847326E-03  -2.55077904673756E-03   0.00000000000000E+00   2.17380263699453E-14
     -2.48073424237953E-24  -1.60188861946371E-08  -1.60188644566107E-08  -2.82688526731066E-19
      4.67794071874999E-07
      0.00000000000000E+00  -1.61126896272652E-11   0.00000000000000E+00  -1.60593505535990E-16   2.31426574342520E-24
      1.61127054652541E-08   1.61127053046606E-08  -2.11015430740673E-20  -6.03294674898540E-01  -6.03294674898432E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08014425639463E-10   0.00000000000000E+00  -1.08014425639463E-10
      1.26866143732029E-19  -7.48815463898742E-03  -2.44556759551840E-03   0.00000000000000E+00   1.98017522303673E-14
     -2.31454075855663E-24  -1.60047106807733E-08  -1.60046908790211E-08  -1.05764600657962E-19
      4.69794071874999E-07
      0.00000000000000E+00  -1.60923919403424E-11   0.00000000000000E+00  -3.17914156194777E-16   2.21639947996154E-24
      1.60923675219460E-08   1.60923672040318E-08   1.52319591035961E-20  -6.21501505883636E-01  -6.21501505883532E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04477910138132E-10   0.00000000000000E+00  -1.04477910138132E-10
     -8.20896765442348E-20  -7.41052063494837E-03  -2.37322605211310E-03   0.00000000000000E+00   1.79184291869421E-14
     -2.18880381624515E-24  -1.59879072123229E-08  -1.59878892938937E-08   6.68577174406397E-20
      4.71794071874999E-07
      0.00000000000000E+00  -1.60678693955080E-11   0.00000000000000E+00  -4.43883342185063E-16   2.14486029518707E-24
      1.60678654835419E-08   1.60678650396585E-08   4.76718094999199E-20  -6.38052307034555E-01  -6.38052307034458E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.64676918455753E-11   0.00000000000000E+00  -9.64676918455753E-11
     -2.75025060235386E-19  -7.36411712023245E-03  -2.33201764803525E-03   0.00000000000000E+00   1.56200841815336E-14
     -2.09854486029851E-24  -1.59714129678972E-08  -1.59713973478130E-08   2.27353250735466E-19
      4.73794071874999E-07
      0.00000000000000E+00  -1.60460103480526E-11   0.00000000000000E+00  -4.09917693919141E-16   2.08984240429756E-24
      1.60459974855085E-08   1.60459970755908E-08   7.43175791861137E-20  -6.51851307623246E-01  -6.51851307623164E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.14520909641317E-11   0.00000000000000E+00  -8.14520909641317E-11
     -4.37929242163649E-19  -7.32995944750533E-03  -2.30001814146724E-03   0.00000000000000E+00   1.24276805436547E-14
     -2.03021524534362E-24  -1.59645574123072E-08  -1.59645449846267E-08   3.63611662977536E-19
      4.75794071874999E-07
      0.00000000000000E+00  -1.60148749821392E-11   0.00000000000000E+00  -6.80121862824412E-16   2.05257646989937E-24
      1.60149195653510E-08   1.60149188852291E-08   9.23635054636406E-20  -6.61296711263830E-01  -6.61296711263773E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.62557533278127E-11   0.00000000000000E+00  -5.62557533278127E-11
     -5.50440748819275E-19  -7.30600223890175E-03  -2.27791358951997E-03   0.00000000000000E+00   8.33414200209216E-15
     -1.98612195419227E-24  -1.59586714660433E-08  -1.59586631319013E-08   4.58077243355634E-19
      4.75919071874999E-07
      0.00000000000000E+00  -1.60125788637090E-11   0.00000000000000E+00  -8.31757035508849E-16   2.05028968427182E-24
      1.60126033982269E-08   1.60126025664699E-08   9.34440894700098E-20  -6.61864798575780E-01  -6.61864798575725E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.43340262037710E-11   0.00000000000000E+00  -5.43340262037710E-11
     -5.57232502094746E-19  -7.30454075291372E-03  -2.27657639531625E-03   0.00000000000000E+00   7.95698853434785E-15
     -1.98361374336447E-24  -1.59582764972546E-08  -1.59582685402661E-08   4.63788412624735E-19
      4.76087821874999E-07
      0.00000000000000E+00  -1.60091806084324E-11   0.00000000000000E+00  -9.25662787081015E-16   2.04739642466661E-24
      1.60091712117972E-08   1.60091702861344E-08   9.48227832904736E-20  -6.62589992239460E-01  -6.62589992239409E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.14040552500277E-11   0.00000000000000E+00  -5.14040552500277E-11
     -5.65906936418188E-19  -7.30264043500555E-03  -2.27483429900651E-03   0.00000000000000E+00   7.51454813534730E-15
     -1.98030320048161E-24  -1.59577737454325E-08  -1.59577662308843E-08   4.71084153127715E-19
      4.76315634374999E-07
      0.00000000000000E+00  -1.60043128373604E-11   0.00000000000000E+00  -9.71452235344534E-16   2.04375563021039E-24
      1.60043558433747E-08   1.60043548719225E-08   9.65329483759580E-20  -6.63490145610944E-01  -6.63490145610896E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.72927246727583E-11   0.00000000000000E+00  -4.72927246727583E-11
     -5.76680810257700E-19  -7.30021274775805E-03  -2.27262839648658E-03   0.00000000000000E+00   6.91614461013275E-15
     -1.97619299555845E-24  -1.59570690633944E-08  -1.59570621472498E-08   4.80147861881742E-19
      4.76623181249999E-07
      0.00000000000000E+00  -1.59975163268070E-11   0.00000000000000E+00  -1.03191363510429E-15   2.03933531570387E-24
      1.59975355504251E-08   1.59975345185115E-08   9.85539795970682E-20  -6.64554768092978E-01  -6.64554768092937E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.14641715816625E-11   0.00000000000000E+00  -4.14641715816625E-11
     -5.89432986652104E-19  -7.29719851525452E-03  -2.26992659016595E-03   0.00000000000000E+00   6.07389237199091E-15
     -1.97132568619060E-24  -1.59560764208222E-08  -1.59560703469298E-08   4.90879007055036E-19
      4.77038369531249E-07
      0.00000000000000E+00  -1.59877807846630E-11   0.00000000000000E+00  -1.11485871720217E-15   2.03430911309258E-24
      1.59877598373454E-08   1.59877587224866E-08   1.00727733462670E-19  -6.65700796119254E-01  -6.65700796119221E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.30936104522174E-11   0.00000000000000E+00  -3.30936104522174E-11
     -6.03173065896118E-19  -7.29363568353043E-03  -2.26680643979027E-03   0.00000000000000E+00   4.87662769321489E-15
     -1.96604882850844E-24  -1.59546699886621E-08  -1.59546651120344E-08   5.02445332433448E-19
      4.77598873710936E-07
      0.00000000000000E+00  -1.59735448503958E-11   0.00000000000000E+00  -1.25997893424361E-15   2.02933946922932E-24
      1.59735415609077E-08   1.59735403009288E-08   1.02576500122571E-19  -6.66676042677227E-01  -6.66676042677206E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.08860409206958E-11   0.00000000000000E+00  -2.08860409206958E-11
     -6.14879779129292E-19  -7.28981075516146E-03  -2.26361500250238E-03   0.00000000000000E+00   3.17902066515098E-15
     -1.96141830034873E-24  -1.59526574390288E-08  -1.59526542600081E-08   5.12303279006720E-19
      4.78355554353514E-07
      0.00000000000000E+00  -1.59525124055753E-11   0.00000000000000E+00  -1.97563482271715E-15   2.02621064229312E-24
      1.59524828624678E-08   1.59524808868330E-08   1.02904917470135E-19  -6.66848326447737E-01  -6.66848326447734E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.75778079738921E-12   0.00000000000000E+00  -2.75778079738921E-12
     -6.16966538475150E-19  -7.28659959248258E-03  -2.26132716626431E-03   0.00000000000000E+00   1.18858512272694E-15
     -1.96008568477236E-24  -1.59497242946208E-08  -1.59497231060356E-08   5.14061621005015E-19
      4.79377073220995E-07
      0.00000000000000E+00  -1.59205504370271E-11   0.00000000000000E+00  -1.23239034849546E-14   2.02931827667786E-24
      1.59205573432081E-08   1.59205450193047E-08   9.89076119985829E-20  -6.64736877776664E-01  -6.64736877776689E-01
      0.00000000000000E+00   0.00000000000000E+00   2.47457063811297E-11   0.00000000000000E+00   2.47457063811297E-11
     -5.91688332517694E-19  -7.28627711014836E-03  -2.26239810965718E-03   0.00000000000000E+00   7.44578530550806E-15
     -1.96839929707431E-24  -1.59452981714711E-08  -1.59452907256858E-08   4.92780720519111E-19
      4.80756123692094E-07
      0.00000000000000E+00  -1.58704950552490E-11   0.00000000000000E+00  -2.46646660679988E-13   2.04962964542351E-24
      1.58705834485571E-08   1.58703368018965E-08   8.40583209181162E-20  -6.56930824949774E-01  -6.56930824949841E-01
      0.00000000000000E+00   0.00000000000000E+00   6.75800284783309E-11   0.00000000000000E+00   6.75800284783309E-11
     -4.98492062407793E-19  -7.29468512175299E-03  -2.27305610900284E-03   0.00000000000000E+00   2.35289411209249E-13
     -2.00209571148073E-24  -1.59381521197860E-08  -1.59379168303748E-08   4.14433741489677E-19
      4.82617841828077E-07
      0.00000000000000E+00  -1.57887532391343E-11   0.00000000000000E+00  -2.39774760083785E-15   2.11757802171778E-24
      1.57886886141699E-08   1.57886862164223E-08   4.26144949835054E-20  -6.35437890702003E-01  -6.35437890702139E-01
      0.00000000000000E+00   0.00000000000000E+00   1.36355768417309E-10   0.00000000000000E+00   1.36355768417309E-10
     -2.44636055399369E-19  -7.32829313791887E-03  -2.31079893535718E-03   0.00000000000000E+00  -2.00903168506806E-14
     -2.10559433372812E-24  -1.59250218945228E-08  -1.59250419848396E-08   2.02021560415864E-19
      4.84617841828077E-07
      0.00000000000000E+00  -1.56622830359995E-11   0.00000000000000E+00  -4.14575799491752E-15   2.28534071863500E-24
      1.56622351070454E-08   1.56622309612874E-08  -3.49326103072439E-20  -5.96433020329817E-01  -5.96433020330042E-01
      0.00000000000000E+00   0.00000000000000E+00   2.24420541405790E-10   0.00000000000000E+00   2.24420541405790E-10
      2.04205027412210E-19  -7.43713513315513E-03  -2.43173890954392E-03   0.00000000000000E+00  -3.55784972793331E-14
     -2.36087240993367E-24  -1.58866159241959E-08  -1.58866515026932E-08  -1.69272417104966E-19
      4.86617841828077E-07
      0.00000000000000E+00  -1.54483766430432E-11   0.00000000000000E+00  -6.10845194641430E-14   2.70176060965326E-24
      1.54483872800534E-08   1.54483261955340E-08  -1.58638450151967E-19  -5.37712692787943E-01  -5.37712692788262E-01
      0.00000000000000E+00   0.00000000000000E+00   3.19407285928880E-10   0.00000000000000E+00   3.19407285928880E-10
      8.43019599269970E-19  -7.77462957163948E-03  -2.80668859371010E-03   0.00000000000000E+00  -6.71597309435435E-15
     -3.04211456909087E-24  -1.57677267654897E-08  -1.57677334814628E-08  -6.84381149118004E-19
      4.88617841828077E-07
      0.00000000000000E+00  -1.49485575831598E-11   0.00000000000000E+00  -1.35800221710347E-14   3.84170837676961E-24
      1.49485899290330E-08   1.49485763490108E-08  -3.47046212641860E-19  -4.56214562711462E-01  -4.56214562711853E-01
      0.00000000000000E+00   0.00000000000000E+00   3.91787237641734E-10   0.00000000000000E+00   3.91787237641734E-10
      1.62659407455344E-18  -8.93930835562411E-03  -4.10604751005470E-03   0.00000000000000E+00  -1.09418317990276E-13
     -5.62506402777588E-24  -1.53402541683346E-08  -1.53403635866526E-08  -1.27954786191158E-18
      4.90617841828077E-07
      0.00000000000000E+00  -1.18050796074950E-11   0.00000000000000E+00  -1.00637617643659E-13   5.75504433550109E-24
      1.18050848951006E-08   1.18049842574829E-08  -6.04623700436852E-19  -3.51220939520979E-01  -3.51220939521383E-01
      0.00000000000000E+00   0.00000000000000E+00   4.03341438873425E-10   0.00000000000000E+00   4.03341438873425E-10
      2.43327695230029E-18  -1.61994422112932E-02  -1.23530034691698E-02   0.00000000000000E+00  -1.73799928171666E-13
     -2.74572409674913E-23  -1.22081518964282E-08  -1.22083256963564E-08  -1.82865325186344E-18
      4.92617841828077E-07
      0.00000000000000E+00  -2.01672673960287E-12   0.00000000000000E+00  -2.46586183509967E-13  -2.72809743995074E-23
      2.01705662048955E-09   2.01681003430601E-09  -8.73270582787359E-19  -2.28033778221655E-01  -2.28033778222066E-01
      0.00000000000000E+00   0.00000000000000E+00   4.10893402174458E-10   0.00000000000000E+00   4.10893402174458E-10
      3.25506375664920E-18  -4.24214414808457E-02  -4.16565633431549E-02   0.00000000000000E+00  -4.18739608763334E-13
     -8.13397033420292E-23  -2.42728469687162E-09  -2.42770343648047E-09  -2.38179317386185E-18
      4.94617841828077E-07
      0.00000000000000E+00   2.89310922203709E-14   0.00000000000000E+00  -5.78136785185325E-14  -4.44386726195411E-23
     -2.88302237385480E-11  -2.88880374171110E-11  -1.12446341921037E-18  -1.05396855684958E-01  -1.05396855685321E-01
      0.00000000000000E+00   0.00000000000000E+00   3.63599660691455E-10   0.00000000000000E+00   3.63599660691455E-10
      3.98226307803212E-18  -7.22036242383731E-02  -7.20981698998349E-02   0.00000000000000E+00  -1.13131759094569E-12
     -9.46558036461699E-23  -3.33580305683303E-10  -3.34711623274344E-10  -2.85779965882175E-18
      4.96617841828077E-07
      0.00000000000000E+00   6.54852976289666E-14   0.00000000000000E+00  -5.82997749776350E-15  -4.61455437400161E-23
     -6.54331517811556E-11  -6.54389817586995E-11  -1.25713624168874E-18  -3.90442251379632E-02  -3.90442251381830E-02
      0.00000000000000E+00   0.00000000000000E+00   2.19790221785923E-10   0.00000000000000E+00   2.19790221785923E-10
      4.42184352160396E-18  -1.01736362598305E-01  -1.01687732783715E-01   0.00000000000000E+00  -1.05864693448366E-12
     -1.03051158168016E-22  -1.53292593092638E-10  -1.54351240027224E-10  -3.16470727991522E-18
      4.98617841828077E-07
      0.00000000000000E+00   2.03895316600709E-14   0.00000000000000E+00   8.92879248207853E-17  -4.63977996948705E-23
     -2.04238782041147E-11  -2.04237889162363E-11  -1.30302742086708E-18  -1.75090988369097E-02  -1.75090988370283E-02
      0.00000000000000E+00   0.00000000000000E+00   1.18536373169796E-10   0.00000000000000E+00   1.18536373169796E-10
      4.65891626794356E-18  -1.30776947884170E-01  -1.30746036932371E-01   0.00000000000000E+00  -6.07487417750431E-13
     -1.06920636045548E-22  -9.75050968357016E-11  -9.81125842535589E-11  -3.35588884707647E-18
      5.00617841828077E-07
      0.00000000000000E+00  -5.41883949524408E-15   0.00000000000000E+00   9.16194602701183E-16  -4.61816021067501E-23
      5.44411101929347E-12   5.44502721384999E-12  -1.31723557391396E-18  -1.12842544955215E-02  -1.12842544955970E-02
      0.00000000000000E+00   0.00000000000000E+00   7.54981657993572E-11   0.00000000000000E+00   7.54981657993572E-11
      4.80991259954227E-18  -1.59252621061620E-01  -1.59227119686373E-01   0.00000000000000E+00  -4.38018835507957E-13
     -1.09470670471951E-22  -8.05051741775901E-11  -8.09431930132075E-11  -3.49267702562830E-18
      5.02617841828077E-07
      0.00000000000000E+00  -2.17672027181838E-14   0.00000000000000E+00   8.54168605414658E-16  -4.55065479649498E-23
      2.17765450220895E-11   2.17773991906494E-11  -1.32050421412685E-18  -9.35712263560412E-03  -9.35712263565982E-03
      0.00000000000000E+00   0.00000000000000E+00   5.56989166387460E-11   0.00000000000000E+00   5.56989166387460E-11
      4.92131043281976E-18  -1.87145390267111E-01  -1.87120981335259E-01   0.00000000000000E+00  -4.13858715773336E-13
     -1.11763947892605E-22  -7.70624571135096E-11  -7.74763158293947E-11  -3.60080621869291E-18
      5.04617841828077E-07
      0.00000000000000E+00  -3.40743975039924E-14   0.00000000000000E+00   6.73714509379767E-16  -4.39955038045901E-23
      3.40624302623352E-11   3.40631039768006E-11  -1.31969879068586E-18  -8.60417610933351E-03  -8.60417610937827E-03
      0.00000000000000E+00   0.00000000000000E+00   4.47609336635284E-11   0.00000000000000E+00   4.47609336635284E-11
      5.01083230014682E-18  -2.14460642815881E-01  -2.14435809472650E-01   0.00000000000000E+00  -4.28301639543548E-13
     -1.14051103429948E-22  -7.83957360006711E-11  -7.88240376403287E-11  -3.69113350946096E-18
      5.06617841828077E-07
      0.00000000000000E+00  -4.43610080712354E-14   0.00000000000000E+00   5.37739686301552E-16  -4.11193438668033E-23
      4.43207307598072E-11   4.43212684994524E-11  -1.31727872826350E-18  -8.20861352619149E-03  -8.20861352622931E-03
      0.00000000000000E+00   0.00000000000000E+00   3.78252458424812E-11   0.00000000000000E+00   3.78252458424812E-11
      5.08648279183178E-18  -2.41212346753135E-01  -2.41186466881227E-01   0.00000000000000E+00  -4.48373377572424E-13
     -1.16371500097143E-22  -8.16981409642447E-11  -8.21465143419335E-11  -3.76920406356828E-18
      5.08617841828077E-07
      0.00000000000000E+00  -5.33617923175730E-14   0.00000000000000E+00   4.26493148802432E-16  -3.62525045853499E-23
      5.33933675802709E-11   5.33937940733834E-11  -1.31425843312016E-18  -7.95168335519311E-03  -7.95168335522620E-03
      0.00000000000000E+00   0.00000000000000E+00   3.30834229918824E-11   0.00000000000000E+00   3.30834229918824E-11
      5.15264963781554E-18  -2.67414844401499E-01  -2.67387600389791E-01   0.00000000000000E+00  -4.67109984455295E-13
     -1.18722297793037E-22  -8.60101070806922E-11  -8.64772170652663E-11  -3.83839120469539E-18
      5.10617841828077E-07
      0.00000000000000E+00  -6.17196634034580E-14   0.00000000000000E+00   3.60141755558775E-16  -2.87969040449377E-23
      6.16967569863476E-11   6.16971171280744E-11  -1.31109823254950E-18  -7.76535941396215E-03  -7.76535941399184E-03
      0.00000000000000E+00   0.00000000000000E+00   2.96880576729961E-11   0.00000000000000E+00   2.96880576729961E-11
      5.21202575316154E-18  -2.93077656565752E-01  -2.93048866592311E-01   0.00000000000000E+00  -4.84415436646457E-13
     -1.21098184410243E-22  -9.09007593643025E-11  -9.13851748010701E-11  -3.90092752061204E-18
      5.12617841828077E-07
      0.00000000000000E+00  -6.95264660660977E-14   0.00000000000000E+00   3.16403360600348E-16  -1.83103301825469E-23
      6.94813558926337E-11   6.94816722959760E-11  -1.30800883769828E-18  -7.62217068840318E-03  -7.62217068843033E-03
      0.00000000000000E+00   0.00000000000000E+00   2.71540966913257E-11   0.00000000000000E+00   2.71540966913257E-11
      5.26633394654418E-18  -3.18204287131680E-01  -3.18173843286438E-01   0.00000000000000E+00  -5.01513000451156E-13
     -1.23498149101480E-22  -9.61342559867272E-11  -9.66357689873019E-11  -3.95832510884591E-18
      5.14617841828077E-07
      0.00000000000000E+00  -7.68740450426999E-14   0.00000000000000E+00   2.87311055148922E-16  -4.69521443690153E-24
      7.69175063394367E-11   7.69177936504871E-11  -1.30507809884137E-18  -7.50787962980477E-03  -7.50787962982995E-03
      0.00000000000000E+00   0.00000000000000E+00   2.51823060393253E-11   0.00000000000000E+00   2.51823060393253E-11
      5.31669855862284E-18  -3.42802330036504E-01  -3.42770165018962E-01   0.00000000000000E+00  -5.19889776916503E-13
     -1.25927162336882E-22  -1.01580209912770E-10  -1.02100099689812E-10  -4.01162045978147E-18
      5.16617841828077E-07
      0.00000000000000E+00  -8.41297792820945E-14   0.00000000000000E+00   2.68669631591991E-16   1.13724150618052E-23
      8.41401247244639E-11   8.41403933941068E-11  -1.30231937246743E-18  -7.42094388532518E-03  -7.42094388534873E-03
      0.00000000000000E+00   0.00000000000000E+00   2.35560046360573E-11   0.00000000000000E+00   2.35560046360573E-11
      5.36381056789495E-18  -3.66870594212783E-01  -3.66836666485389E-01   0.00000000000000E+00  -5.40179157484492E-13
     -1.28391540279667E-22  -1.07156218872551E-10  -1.07696398030164E-10  -4.06149119542752E-18
      5.18617841828078E-07
      0.00000000000000E+00  -9.12936687842816E-14   0.00000000000000E+00   2.58505822095075E-16   2.83362650109289E-23
      9.12714710760940E-11   9.12717295819444E-11  -1.29969748476387E-18  -7.37178897129147E-03  -7.37178897131360E-03
      0.00000000000000E+00   0.00000000000000E+00   2.21345860807010E-11   0.00000000000000E+00   2.21345860807010E-11
      5.40807974005636E-18  -3.90414991484875E-01  -3.90379265294116E-01   0.00000000000000E+00  -5.62989960489094E-13
     -1.30898449086443E-22  -1.12843325702026E-10  -1.13406315662646E-10  -4.10838225529248E-18
      5.20617841828078E-07
      0.00000000000000E+00  -9.82738688120536E-14   0.00000000000000E+00   2.49084815400221E-16   4.51853151675144E-23
      9.83089301921269E-11   9.83091792769875E-11  -1.29723174156336E-18  -7.33567022232872E-03  -7.33567022234973E-03
      0.00000000000000E+00   0.00000000000000E+00   2.10127727326228E-11   0.00000000000000E+00   2.10127727326228E-11
      5.45010528552160E-18  -4.13592919372459E-01  -4.13555329952042E-01   0.00000000000000E+00  -5.94899787956745E-13
     -1.33481014718735E-22  -1.18727052221520E-10  -1.19321952009610E-10  -4.15287354395824E-18
      5.22617841828078E-07
      0.00000000000000E+00  -1.05254068839826E-13   0.00000000000000E+00   2.41938781675647E-16   6.10399989912551E-23
      1.05283692358217E-10   1.05283934297060E-10  -1.29491023599604E-18  -7.30957990082726E-03  -7.30957990084724E-03
      0.00000000000000E+00   0.00000000000000E+00   1.99806506954912E-11   0.00000000000000E+00   1.99806506954912E-11
      5.49006658691258E-18  -4.36392778846307E-01  -4.36353317743584E-01   0.00000000000000E+00  -6.30215492433792E-13
     -1.36142351583934E-22  -1.24634369499981E-10  -1.25264584992551E-10  -4.19515635091654E-18
      5.24617841828078E-07
      0.00000000000000E+00  -1.12234268867598E-13   0.00000000000000E+00   2.35942935969611E-16   7.52472942354577E-23
      1.12197050339376E-10   1.12197286282388E-10  -1.29271736653749E-18  -7.29463990342749E-03  -7.29463990344645E-03
      0.00000000000000E+00   0.00000000000000E+00   1.89645421315568E-11   0.00000000000000E+00   1.89645421315568E-11
      5.52799567117570E-18  -4.58754686180817E-01  -4.58713367752073E-01   0.00000000000000E+00  -6.66794080336431E-13
     -1.38872783660021E-22  -1.30495034333469E-10  -1.31161828413944E-10  -4.23527830463821E-18
      5.26617841828078E-07
      0.00000000000000E+00  -1.19030779420955E-13   0.00000000000000E+00   2.31248380746598E-16   8.74763884596594E-23
      1.19060161358404E-10   1.19060392606873E-10  -1.29063270581373E-18  -7.29374412249500E-03  -7.29374412251298E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79802365738935E-11   0.00000000000000E+00   1.79802365738935E-11
      5.56395614432348E-18  -4.80666659622610E-01  -4.80623489738031E-01   0.00000000000000E+00  -7.05521881178502E-13
     -1.41663261958680E-22  -1.36335107299446E-10  -1.37040629180766E-10  -4.27332343850976E-18
      5.28617841828078E-07
      0.00000000000000E+00  -1.25919134711519E-13   0.00000000000000E+00   2.28221749933709E-16   9.76962613031091E-23
      1.25897082859213E-10   1.25897311081061E-10  -1.28863054120672E-18  -7.31238531272836E-03  -7.31238531274540E-03
      0.00000000000000E+00   0.00000000000000E+00   1.70315659534297E-11   0.00000000000000E+00   1.70315659534297E-11
      5.59801927623034E-18  -5.02133087432379E-01  -5.02088063180469E-01   0.00000000000000E+00  -7.45829502337093E-13
     -1.44499878704556E-22  -1.42183047532009E-10  -1.42928877034490E-10  -4.30938873502362E-18
      5.30617841828078E-07
      0.00000000000000E+00  -1.32715645264876E-13   0.00000000000000E+00   2.27794022377802E-16   1.06094309539922E-22
      1.32757910048700E-10   1.32758137842829E-10  -1.28667538267583E-18  -7.36077562565834E-03  -7.36077562567446E-03
      0.00000000000000E+00   0.00000000000000E+00   1.61161865197641E-11   0.00000000000000E+00   1.61161865197641E-11
      5.63025164926987E-18  -5.23162472813624E-01  -5.23115576244699E-01   0.00000000000000E+00  -7.86336010584927E-13
     -1.47362821020954E-22  -1.48087988351861E-10  -1.48874324362593E-10  -4.34357626659404E-18
      5.32617841828078E-07
      0.00000000000000E+00  -1.40155068978686E-13   0.00000000000000E+00   2.51047594407703E-16   1.13269057072784E-22
      1.40183561467200E-10   1.40183812514908E-10  -1.28452601962508E-18  -7.54511975156166E-03  -7.54511975157672E-03
      0.00000000000000E+00   0.00000000000000E+00   1.50694448464419E-11   0.00000000000000E+00   1.50694448464419E-11
      5.66039053896276E-18  -5.43763445602972E-01  -5.43714540243932E-01   0.00000000000000E+00  -8.21120798690216E-13
     -1.50214125732874E-22  -1.54432136562508E-10  -1.55253257361349E-10  -4.37586451933768E-18
      5.34617841828078E-07
      0.00000000000000E+00  -1.49247697962231E-13   0.00000000000000E+00   3.17505673776546E-16   1.20091767353751E-22
      1.49206575970655E-10   1.49206893476449E-10  -1.28171980088297E-18  -8.06708310283169E-03  -8.06708310284541E-03
      0.00000000000000E+00   0.00000000000000E+00   1.37158101985057E-11   0.00000000000000E+00   1.37158101985057E-11
      5.68782215935976E-18  -5.63942963565730E-01  -5.63891642991281E-01   0.00000000000000E+00  -8.43392114179951E-13
     -1.53001621176981E-22  -1.62079311560622E-10  -1.62922703674955E-10  -4.40610235847679E-18
      5.36617841828078E-07
      0.00000000000000E+00  -1.67432955929321E-13   0.00000000000000E+00   6.92929859397394E-16   1.31138412781616E-22
      1.67435469335181E-10   1.67436162265171E-10  -1.27531332629428E-18  -1.02673537053200E-02  -1.02673537053300E-02
      0.00000000000000E+00   0.00000000000000E+00   1.00091463939398E-11   0.00000000000000E+00   1.00091463939398E-11
      5.70784045214764E-18  -5.83696989693089E-01  -5.83641095336476E-01   0.00000000000000E+00  -7.93540848084219E-13
     -1.55501905448775E-22  -1.76651767810871E-10  -1.77445308659110E-10  -4.43252712585337E-18
      5.38617841828078E-07
      0.00000000000000E+00  -2.74340230038882E-13   0.00000000000000E+00   3.95295886503426E-15   1.84809191098541E-22
      2.74364102795768E-10   2.74368055754818E-10  -1.24139916286324E-18  -2.48697124629245E-02  -2.48697124629111E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.34304657142808E-11   0.00000000000000E+00  -1.34304657142808E-11
      5.68097952071908E-18  -6.02900990613730E-01  -6.02818798062175E-01   0.00000000000000E+00  -1.89197598875065E-13
     -1.56076458556167E-22  -2.60748392441506E-10  -2.60937590040538E-10  -4.43958035785584E-18
      5.40617841828078E-07
      0.00000000000000E+00  -6.12237018225373E-13   0.00000000000000E+00   1.05433819249863E-14   2.80511108911320E-22
      6.12221890805827E-10   6.12232434188032E-10  -1.17216754950008E-18  -5.36891814127532E-02  -5.36891814127085E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.46801641214922E-11   0.00000000000000E+00  -4.46801641214922E-11
      5.59161919247610E-18  -6.21134023283389E-01  -6.20955250164903E-01   0.00000000000000E+00   4.91354746563202E-13
     -1.54549552175852E-22  -5.68043624812950E-10  -5.67552270066542E-10  -4.41945164297602E-18
      5.41617841828078E-07
      0.00000000000000E+00  -8.96496479882669E-13   0.00000000000000E+00   1.60210116995179E-14   3.24404606772825E-22
      8.96488618622997E-10   8.96504639635021E-10  -1.13498995942284E-18  -6.85690558585945E-02  -6.85690558585428E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.16610952101472E-11   0.00000000000000E+00  -5.16610952101472E-11
      5.53995809726595E-18  -6.29888619054459E-01  -6.29622500781547E-01   0.00000000000000E+00   4.95085743867776E-13
     -1.53761483274577E-22  -8.45338630168590E-10  -8.44843544424876E-10  -4.40496813784311E-18
      5.42967841828078E-07
      0.00000000000000E+00  -1.46317850845311E-12   0.00000000000000E+00   2.24938181807228E-14   3.63946359220214E-22
      1.46320169356255E-09   1.46322418738109E-09  -1.08456523427142E-18  -8.86314900679869E-02  -8.86314900679286E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.83407690275841E-11   0.00000000000000E+00  -5.83407690275841E-11
      5.46119805907871E-18  -6.40813087999414E-01  -6.40370559583433E-01   0.00000000000000E+00   4.49883008437225E-13
     -1.52770712983122E-22  -1.40533330136180E-09  -1.40488341835351E-09  -4.37663282480729E-18
      5.44790341828078E-07
      0.00000000000000E+00  -2.69270400545027E-12   0.00000000000000E+00   3.48425945274122E-14   3.95571250438989E-22
      2.69265799963560E-09   2.69269284223052E-09  -1.02032242844705E-18  -1.15355392022637E-01  -1.15355392022570E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.77541138798280E-11   0.00000000000000E+00  -6.77541138798280E-11
      5.33771618653273E-18  -6.53139905840708E-01  -6.52313063474752E-01   0.00000000000000E+00   3.71448872941802E-13
     -1.51622214939493E-22  -2.62531017722349E-09  -2.62493872835070E-09  -4.31739375808568E-18
      5.46790341828078E-07
      0.00000000000000E+00  -4.88081302468239E-12   0.00000000000000E+00   5.53264779567315E-14   4.22679542859467E-22
      4.88076218767798E-09   4.88081751415636E-09  -9.56894404838933E-19  -1.44139028958882E-01  -1.44139028958801E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.08728914367036E-11   0.00000000000000E+00  -8.08728914367036E-11
      5.17597040365932E-18  -6.62188378417464E-01  -6.60676412078239E-01   0.00000000000000E+00   2.78071089033396E-13
     -1.50616719361753E-22  -4.80022269380855E-09  -4.79994462271966E-09  -4.21907599882039E-18
      5.48790341828078E-07
      0.00000000000000E+00  -8.16573189564679E-12   0.00000000000000E+00   8.22061234080623E-14   4.44023582459789E-22
      8.16568171635547E-09   8.16576392247932E-09  -9.00441446052770E-19  -1.72343253490173E-01  -1.72343253490077E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.64603719876040E-11   0.00000000000000E+00  -9.64603719876040E-11
      4.98304965968411E-18  -6.64724875120054E-01  -6.62183058809402E-01   0.00000000000000E+00   2.33094729275177E-13
     -1.49707171844960E-22  -8.06953664522086E-09  -8.06930355049173E-09  -4.08260821363135E-18
      5.50790341828078E-07
      0.00000000000000E+00  -1.27115871637333E-11   0.00000000000000E+00   1.13191045282020E-13   4.55371572189881E-22
      1.27114456958096E-08   1.27115588868553E-08  -8.49227324294401E-19  -1.99964943269813E-01  -1.99964943269702E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11848808185238E-10   0.00000000000000E+00  -1.11848808185238E-10
      4.75935204331363E-18  -6.58431965973446E-01  -6.54463050999781E-01   0.00000000000000E+00   3.43278293480069E-13
     -1.48355101435445E-22  -1.26000533569634E-08  -1.25997100786701E-08  -3.91012471901924E-18
      5.52790341828078E-07
      0.00000000000000E+00  -1.87116201560266E-11   0.00000000000000E+00   1.49035101840761E-13   4.55023711066652E-22
      1.87115004227997E-08   1.87116494579020E-08  -8.01236043552285E-19  -2.27015147306945E-01  -2.27015147306820E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.24548621315579E-10   0.00000000000000E+00  -1.24548621315579E-10
      4.51025480068248E-18  -6.40655165520299E-01  -6.34800142714695E-01   0.00000000000000E+00   6.94513894019733E-13
     -1.45646823470532E-22  -1.85877953504804E-08  -1.85871008365865E-08  -3.70901875713019E-18
      5.54790341828078E-07
      0.00000000000000E+00  -2.64551417947304E-11   0.00000000000000E+00   1.92139479805328E-13   4.43215746776078E-22
      2.64549211990064E-08   2.64551133384866E-08  -7.54877867676352E-19  -2.53508844496070E-01  -2.53508844495936E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.33972402442957E-10   0.00000000000000E+00  -1.33972402442957E-10
      4.24230999579656E-18  -6.08224500586237E-01  -5.99933030976076E-01   0.00000000000000E+00   1.26288484855834E-12
     -1.40510871536151E-22  -2.63224038208921E-08  -2.63211409360436E-08  -3.48743212812021E-18
      5.56790341828078E-07
      0.00000000000000E+00  -3.62327488283693E-11   0.00000000000000E+00   2.42605600924142E-13   4.19525519403702E-22
      3.62324617388757E-08   3.62327043444771E-08  -7.09187990409746E-19  -2.79458648062410E-01  -2.79458648062268E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.41774536024001E-10   0.00000000000000E+00  -1.41774536024001E-10
      3.95876092374856E-18  -5.57457257505769E-01  -5.46087810248700E-01   0.00000000000000E+00   1.85179113058089E-12
     -1.32191822190749E-22  -3.60927815995835E-08  -3.60909298084531E-08  -3.24957293333882E-18
      5.58790341828078E-07
      0.00000000000000E+00  -4.79569132223845E-11   0.00000000000000E+00   2.91149626730182E-13   3.76152316380073E-22
      4.79565859099478E-08   4.79568770595749E-08  -6.63887840811327E-19  -3.04870820420503E-01  -3.04870820420352E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.51377326729711E-10   0.00000000000000E+00  -1.51377326729711E-10
      3.65600627028914E-18  -4.84881613699565E-01  -4.69821224594122E-01   0.00000000000000E+00   2.12819430790102E-12
     -1.21291655322696E-22  -4.78076279271530E-08  -4.78054997328452E-08  -2.99211842947781E-18
      5.60790341828078E-07
      0.00000000000000E+00  -6.07336183047980E-11   0.00000000000000E+00   3.17783146035741E-13   3.03409320704706E-22
      6.07332722168288E-08   6.07335899999751E-08  -6.19099148347533E-19  -3.29749270231065E-01  -3.29749270230901E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.64093106810427E-10   0.00000000000000E+00  -1.64093106810427E-10
      3.32782005666828E-18  -3.88765864853735E-01  -3.69683654616987E-01   0.00000000000000E+00   1.98835849255018E-12
     -1.09459420673490E-22  -6.05714852516571E-08  -6.05694968931647E-08  -2.70872090832075E-18
      5.62790341828078E-07
      0.00000000000000E+00  -7.25591792886903E-11   0.00000000000000E+00   2.94725086467141E-13   2.37102935219756E-22
      7.25588593763394E-08   7.25591541014261E-08  -5.74852240904388E-19  -3.54102223289752E-01  -3.54102223289574E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.77781157483309E-10   0.00000000000000E+00  -1.77781157483309E-10
      2.97225774170167E-18  -2.71390163928935E-01  -2.48585904122290E-01   0.00000000000000E+00   1.62688001681755E-12
     -9.57513084115311E-23  -7.23829998239595E-08  -7.23813729439428E-08  -2.39740550079728E-18
      5.64790341828078E-07
      0.00000000000000E+00  -7.82187438401553E-11   0.00000000000000E+00   1.41497586188992E-13   1.49028436201105E-22
      7.82186205709134E-08   7.82187620684998E-08  -5.31819507087637E-19  -3.77918096295416E-01  -3.77918096295214E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.02518127114497E-10   0.00000000000000E+00  -2.02518127114497E-10
      2.56722148747267E-18  -1.45227578950709E-01  -1.20647480694292E-01   0.00000000000000E+00   1.00316459784251E-12
     -8.16971757063830E-23  -7.80172471059830E-08  -7.80162439413852E-08  -2.03540198038503E-18
      5.66790341828078E-07
      0.00000000000000E+00  -6.09618524767587E-11   0.00000000000000E+00  -4.29001462195284E-13   4.54678034079363E-23
      6.09622419966047E-08   6.09618129951425E-08  -4.84389908019281E-19  -4.01273188249835E-01  -4.01273188249641E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.93559705996809E-10   0.00000000000000E+00  -1.93559705996809E-10
      2.18010207547905E-18  -5.51355086342096E-02  -3.59894541252891E-02   0.00000000000000E+00   8.71517395846539E-13
     -4.11135149319785E-23  -6.07691248065415E-08  -6.07682532891457E-08  -1.69571216745977E-18
      5.68790341828079E-07
      0.00000000000000E+00  -3.24492048791052E-11   0.00000000000000E+00  -7.06329203841574E-13   1.38412609403535E-23
      3.24499542305164E-08   3.24492479013126E-08  -4.26995574125720E-19  -4.24285734927048E-01  -4.24285734926920E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.28753359626942E-10   0.00000000000000E+00  -1.28753359626942E-10
      1.92259535622517E-18  -2.23374265245759E-02  -1.21542855527813E-02   0.00000000000000E+00   8.30025896654594E-13
     -1.43542189013711E-23  -3.23213245675823E-08  -3.23204945416856E-08  -1.49559978209945E-18
      5.69790341828079E-07
      0.00000000000000E+00  -2.34185710931752E-11   0.00000000000000E+00  -4.45962796446655E-13   8.27398345144641E-24
      2.34190538867671E-08   2.34186079239707E-08  -3.98093142710460E-19  -4.35694731652428E-01  -4.35694731652319E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08987747077163E-10   0.00000000000000E+00  -1.08987747077163E-10
      1.81360760914801E-18  -1.49811553111384E-02  -7.63704312778967E-03   0.00000000000000E+00   5.14482267334387E-13
     -9.22495550933546E-24  -2.33101346591608E-08  -2.33096201768935E-08  -1.41551446643755E-18
      5.71140341828079E-07
      0.00000000000000E+00  -1.88332225880894E-11   0.00000000000000E+00  -1.67319674549166E-13   5.65912761278938E-24
      1.88333976853150E-08   1.88332303656405E-08  -3.60383332125012E-19  -4.50897657937028E-01  -4.50897657936927E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00524832379657E-10   0.00000000000000E+00  -1.00524832379657E-10
      1.67789908543547E-18  -1.12423998400042E-02  -5.34032181571126E-03   0.00000000000000E+00   2.17529518449780E-13
     -6.36032761509914E-24  -1.87329230627792E-08  -1.87327055332608E-08  -1.31751575331046E-18
      5.72962841828079E-07
      0.00000000000000E+00  -1.70173602887594E-11   0.00000000000000E+00  -4.88004417359641E-14   4.33408951547321E-24
      1.70174028904501E-08   1.70173540900083E-08  -3.11537217486805E-19  -4.71046811997329E-01  -4.71046811997230E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.93064634820825E-11   0.00000000000000E+00  -9.93064634820825E-11
      1.49691305573938E-18  -9.50078531752716E-03  -4.17044381799967E-03   0.00000000000000E+00   8.95189898573783E-14
     -4.83444448595396E-24  -1.69181371455161E-08  -1.69180476265262E-08  -1.18537583825257E-18
      5.74962841828079E-07
      0.00000000000000E+00  -1.64541683602028E-11   0.00000000000000E+00  -1.35564134013971E-14   3.63315355334277E-24
      1.64541738496847E-08   1.64541602932713E-08  -2.60374692490336E-19  -4.92709334169144E-01  -4.92709334169043E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01313049799279E-10   0.00000000000000E+00  -1.01313049799279E-10
      1.29428695614082E-18  -8.71296947659553E-03  -3.56070097987786E-03   0.00000000000000E+00   4.83314336783483E-14
     -3.99937935576018E-24  -1.63528955749057E-08  -1.63528472434721E-08  -1.03391226365048E-18
      5.76962841828079E-07
      0.00000000000000E+00  -1.62724076252691E-11   0.00000000000000E+00  -4.17886929301746E-15   3.20622900165597E-24
      1.62724485772709E-08   1.62724443984016E-08  -2.11658800143978E-19  -5.13930612273044E-01  -5.13930612272941E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03809681936542E-10   0.00000000000000E+00  -1.03809681936542E-10
      1.08666759226773E-18  -8.28748983904514E-03  -3.19325774627661E-03   0.00000000000000E+00   3.46672036576704E-14
     -3.46886748804703E-24  -1.61686693836687E-08  -1.61686347164651E-08  -8.75008792123755E-19
      5.78962841828079E-07
      0.00000000000000E+00  -1.61983807670799E-11   0.00000000000000E+00  -1.55354785164130E-15   2.90847827315146E-24
      1.61983427835305E-08   1.61983412299827E-08  -1.65291729907878E-19  -5.34719715732580E-01  -5.34719715732474E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05883459035000E-10   0.00000000000000E+00  -1.05883459035000E-10
      8.74900674197734E-19  -8.00991970751790E-03  -2.93968595205381E-03   0.00000000000000E+00   2.87336902487555E-14
     -3.08757505530712E-24  -1.60924865046379E-08  -1.60924577709477E-08  -7.09608944289855E-19
      5.80962841828079E-07
      0.00000000000000E+00  -1.61596222879783E-11   0.00000000000000E+00  -7.05416146505638E-16   2.68528026139258E-24
      1.61596193639099E-08   1.61596186584937E-08  -1.21131450200310E-19  -5.55084679323091E-01  -5.55084679322983E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07398100823346E-10   0.00000000000000E+00  -1.07398100823346E-10
      6.60104472551041E-19  -7.80969653935238E-03  -2.75213842277583E-03   0.00000000000000E+00   2.52266587791137E-14
     -2.79784070785409E-24  -1.60522457843291E-08  -1.60522205576704E-08  -5.38973022350731E-19
      5.82962841828079E-07
      0.00000000000000E+00  -1.61356508115671E-11   0.00000000000000E+00  -3.61485829944864E-16   2.51067711365464E-24
      1.61356767262477E-08   1.61356763647619E-08  -7.90216893668220E-20  -5.75028941001932E-01  -5.75028941001824E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08347857720695E-10   0.00000000000000E+00  -1.08347857720695E-10
      4.43408757109651E-19  -7.65702179221501E-03  -2.60730456993594E-03   0.00000000000000E+00   2.27092996348695E-14
     -2.57019905183156E-24  -1.60273512163408E-08  -1.60273285070412E-08  -3.64387067742829E-19
      5.84962841828079E-07
      0.00000000000000E+00  -1.61192106036070E-11   0.00000000000000E+00  -1.95823344200441E-16   2.37013410928268E-24
      1.61191791946550E-08   1.61191789988317E-08  -3.88889175220824E-20  -5.94512752503686E-01  -5.94512752503577E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08549848222967E-10   0.00000000000000E+00  -1.08549848222967E-10
      2.26309060663716E-19  -7.53607720385065E-03  -2.49161982481789E-03   0.00000000000000E+00   2.06913255377257E-14
     -2.38708465693668E-24  -1.60106498419342E-08  -1.60106291506087E-08  -1.87420143141634E-19
      5.86962841828079E-07
      0.00000000000000E+00  -1.61053420482886E-11   0.00000000000000E+00  -1.47806497961652E-16   2.25560106304511E-24
      1.61053533597703E-08   1.61053532119638E-08  -1.19334658838838E-21  -6.13228560998077E-01  -6.13228560997971E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06518100615895E-10   0.00000000000000E+00  -1.06518100615895E-10
      1.32728594319265E-20  -7.43738552973479E-03  -2.39664276777044E-03   0.00000000000000E+00   1.87268793189745E-14
     -2.23864980817932E-24  -1.59988538382272E-08  -1.59988351113479E-08  -1.20795128435371E-20
      5.88962841828079E-07
      0.00000000000000E+00  -1.60763191113311E-11   0.00000000000000E+00  -5.43977045556959E-16   2.17581871051670E-24
      1.60763364716872E-08   1.60763359277102E-08   3.31881027099549E-20  -6.30628177261967E-01  -6.30628177261866E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00705186421163E-10   0.00000000000000E+00  -1.00705186421163E-10
     -1.88137513410399E-19  -7.38325268003116E-03  -2.34981983847970E-03   0.00000000000000E+00   1.68697683799862E-14
     -2.13761325623038E-24  -1.59756476110574E-08  -1.59756307412890E-08   1.54949410700444E-19
      5.90962841828079E-07
      0.00000000000000E+00  -1.60563888033570E-11   0.00000000000000E+00  -3.48113940109124E-16   2.11344595230200E-24
      1.60563585519646E-08   1.60563582038507E-08   6.27241360388200E-20  -6.45825320269071E-01  -6.45825320268982E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.92168305225799E-11   0.00000000000000E+00  -8.92168305225799E-11
     -3.66571174455559E-19  -7.34453551026827E-03  -2.31377650937686E-03   0.00000000000000E+00   1.39112835987794E-14
     -2.05936157544458E-24  -1.59671552846117E-08  -1.59671413733281E-08   3.03847038416739E-19
      5.92962841828079E-07
      0.00000000000000E+00  -1.60302130532529E-11   0.00000000000000E+00  -5.36717341504805E-16   2.06787862539402E-24
      1.60302431000810E-08   1.60302425633637E-08   8.50150486986387E-20  -6.57440962569489E-01  -6.57440962569420E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.89224831687608E-11   0.00000000000000E+00  -6.89224831687608E-11
     -5.04416140793080E-19  -7.31597850172679E-03  -2.28705294687929E-03   0.00000000000000E+00   1.03171099246749E-14
     -2.00390470374755E-24  -1.59613303973049E-08  -1.59613200801949E-08   4.19401092094442E-19
      5.94962841828079E-07
      0.00000000000000E+00  -1.59920974873118E-11   0.00000000000000E+00  -8.85887605602566E-16   2.04181115098494E-24
      1.59920554360340E-08   1.59920545501464E-08   9.67908420238107E-20  -6.63625298083100E-01  -6.63625298083063E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.69470286243813E-11   0.00000000000000E+00  -3.69470286243813E-11
     -5.78310198041843E-19  -7.29817316124334E-03  -2.27120464390663E-03   0.00000000000000E+00   5.47337516366427E-15
     -1.97520148958484E-24  -1.59551129948972E-08  -1.59551075215220E-08   4.81519356018032E-19
      5.95462841828079E-07
      0.00000000000000E+00  -1.59798821372632E-11   0.00000000000000E+00  -1.16014413893808E-15   2.03659858295359E-24
      1.59798963427692E-08   1.59798951826251E-08   9.88831187628360E-20  -6.64727310118358E-01  -6.64727310118331E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.64126911228673E-11   0.00000000000000E+00  -2.64126911228673E-11
     -5.91516543603277E-19  -7.29439857045491E-03  -2.26794198793881E-03   0.00000000000000E+00   3.92660936353900E-15
     -1.97007185482447E-24  -1.59534864181116E-08  -1.59534824915022E-08   4.92633424840441E-19
      5.96137841828079E-07
      0.00000000000000E+00  -1.59617887240333E-11   0.00000000000000E+00  -2.62987144046797E-15   2.03236437053707E-24
      1.59617549900664E-08   1.59617523601949E-08   1.00030880506335E-19  -6.65331640472961E-01  -6.65331640472950E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07518925426944E-11   0.00000000000000E+00  -1.07518925426944E-11
     -5.98774071069596E-19  -7.29076585446848E-03  -2.26509083042165E-03   0.00000000000000E+00   3.03115085022387E-15
     -1.96693709510366E-24  -1.59510034988031E-08  -1.59510004676522E-08   4.98743190563261E-19
      5.97049091828079E-07
      0.00000000000000E+00  -1.59344189923454E-11   0.00000000000000E+00  -5.19833814599327E-15   2.03227935955323E-24
      1.59344131137695E-08   1.59344079154314E-08   9.81819097460357E-20  -6.64355067230534E-01  -6.64355067230547E-01
      0.00000000000000E+00   0.00000000000000E+00   1.28085247004685E-11   0.00000000000000E+00   1.28085247004685E-11
     -5.87102302936294E-19  -7.28890841428684E-03  -2.26442492278719E-03   0.00000000000000E+00   2.08088869691969E-15
     -1.97046414841489E-24  -1.59472185210205E-08  -1.59472164401318E-08   4.88920393190258E-19
      5.98279279328079E-07
      0.00000000000000E+00  -1.58921704132300E-11   0.00000000000000E+00  -7.67396443454586E-14   2.04415613141822E-24
      1.58921765069776E-08   1.58920997673333E-08   8.85765763544705E-20  -6.59300693660548E-01  -6.59300693660597E-01
      0.00000000000000E+00   0.00000000000000E+00   4.90796894585365E-11   0.00000000000000E+00   4.90796894585365E-11
     -5.26725082460520E-19  -7.29296356480203E-03  -2.27035996204784E-03   0.00000000000000E+00   6.81692137247625E-14
     -1.99186843152332E-24  -1.59412476260055E-08  -1.59411794567918E-08   4.38148506106049E-19
      5.99940032453079E-07
      0.00000000000000E+00  -1.58243889971708E-11   0.00000000000000E+00  -2.18210284960185E-15   2.08852816745225E-24
      1.58243551871216E-08   1.58243530050188E-08   5.99660502560079E-20  -6.44383523481260E-01  -6.44383523481366E-01
      0.00000000000000E+00   0.00000000000000E+00   1.06549583417899E-10   0.00000000000000E+00   1.06549583417899E-10
     -3.49772528831797E-19  -7.31401980778022E-03  -2.29467859225694E-03   0.00000000000000E+00  -1.54087192866355E-14
     -2.06085262988598E-24  -1.59308871797174E-08  -1.59309025884367E-08   2.89806478575788E-19
      6.01940032453079E-07
      0.00000000000000E+00  -1.57215228914984E-11   0.00000000000000E+00  -2.99925817830197E-15   2.20669062082179E-24
      1.57214863694575E-08   1.57214833701994E-08  -3.92120202612718E-21  -6.11839300451932E-01  -6.11839300452122E-01
      0.00000000000000E+00   0.00000000000000E+00   1.89315162358065E-10   0.00000000000000E+00   1.89315162358065E-10
      2.88577958843320E-20  -7.37655866313089E-03  -2.36355352244874E-03   0.00000000000000E+00  -2.93977348072896E-14
     -2.24015238693090E-24  -1.59107691348226E-08  -1.59107985325574E-08  -2.49365938582055E-20
      6.03940032453079E-07
      0.00000000000000E+00  -1.55364557460252E-11   0.00000000000000E+00  -1.48797641705586E-14   2.51039998490498E-24
      1.55365198244578E-08   1.55365049446937E-08  -1.08455971984939E-19  -5.61000671501476E-01  -5.61000671501760E-01
      0.00000000000000E+00   0.00000000000000E+00   2.83491588510298E-10   0.00000000000000E+00   2.83491588510298E-10
      5.95840972904928E-19  -7.61376358993740E-03  -2.62936837037233E-03   0.00000000000000E+00  -4.07097841872469E-14
     -2.71737569888762E-24  -1.58199558234198E-08  -1.58199965332040E-08  -4.87385000919989E-19
      6.05940032453079E-07
      0.00000000000000E+00  -1.52091211026176E-11   0.00000000000000E+00  -9.04499932744025E-15   3.28238353129577E-24
      1.52091043191500E-08   1.52090952741506E-08  -2.70414770876639E-19  -4.88346239441047E-01  -4.88346239441416E-01
      0.00000000000000E+00   0.00000000000000E+00   3.69272443048480E-10   0.00000000000000E+00   3.69272443048480E-10
      1.33438585900189E-18  -8.31705789850754E-03  -3.40880404013850E-03   0.00000000000000E+00  -8.82259447356980E-14
     -4.18649416486200E-24  -1.55782794912544E-08  -1.55783677171991E-08  -1.06397108812525E-18
      6.07940032453079E-07
      0.00000000000000E+00  -1.37411666678297E-11   0.00000000000000E+00  -3.93023257095056E-14   5.43203651136039E-24
      1.37412028866604E-08   1.37411635843346E-08  -5.05351505944332E-19  -3.92114502686121E-01  -3.92114502686524E-01
      0.00000000000000E+00   0.00000000000000E+00   4.03249917426906E-10   0.00000000000000E+00   4.03249917426906E-10
      2.14088569385570E-18  -1.18070845330649E-02  -7.35064309972242E-03   0.00000000000000E+00  -1.58376050299466E-13
     -1.35690288179659E-23  -1.41442551257112E-08  -1.41444135017616E-08  -1.63553418791137E-18
      6.09940032453079E-07
      0.00000000000000E+00  -5.09490310711313E-12   0.00000000000000E+00  -2.17145305754884E-13  -9.83611216323778E-24
      5.09511937309747E-09   5.09490222779170E-09  -7.75477656088872E-19  -2.74501763955461E-01  -2.74501763955870E-01
      0.00000000000000E+00   0.00000000000000E+00   4.09410278696976E-10   0.00000000000000E+00   4.09410278696976E-10
      2.95970625124965E-18  -3.21072470474546E-02  -3.03730364137615E-02   0.00000000000000E+00  -2.80786191054993E-13
     -6.88865438085900E-23  -5.50403172029756E-09  -5.50431250648868E-09  -2.18422859516078E-18
      6.11940032453079E-07
      0.00000000000000E+00  -2.00956285010069E-13   0.00000000000000E+00  -1.27150620346613E-13  -4.19578694311017E-23
      2.01120470817644E-10   2.00993320197255E-10  -1.03873923335079E-18  -1.47818089294620E-01  -1.47818089295010E-01
      0.00000000000000E+00   0.00000000000000E+00   3.89604954796200E-10   0.00000000000000E+00   3.89604954796200E-10
      3.73891616084205E-18  -6.15975607097557E-02  -6.14114866494829E-02   0.00000000000000E+00  -8.69416631389433E-13
     -9.00019154501317E-23  -5.89728858361976E-10  -5.90598274993456E-10  -2.70017692749127E-18
      6.13940032453079E-07
      0.00000000000000E+00   8.11907476914537E-14   0.00000000000000E+00  -1.35729599980182E-14  -4.58065681385004E-23
     -8.11646912137508E-11  -8.11782641737946E-11  -1.22212557555712E-18  -5.62140165436127E-02  -5.62140165438899E-02
      0.00000000000000E+00   0.00000000000000E+00   2.77214213304277E-10   0.00000000000000E+00   2.77214213304277E-10
      4.29334458745061E-18  -9.12636505260243E-02  -9.12018874052667E-02   0.00000000000000E+00  -1.21654517913486E-12
     -1.00749614122610E-22  -1.94819403951246E-10  -1.96035949130482E-10  -3.07121901189349E-18
      6.15940032453079E-07
      0.00000000000000E+00   3.45336211900301E-14   0.00000000000000E+00  -9.83047980574255E-16  -4.63770523210846E-23
     -3.44979787597559E-11  -3.44989618077829E-11  -1.29144342964444E-18  -2.26523078590949E-02  -2.26523078592416E-02
      0.00000000000000E+00   0.00000000000000E+00   1.46671749469913E-10   0.00000000000000E+00   1.46671749469913E-10
      4.58668808639043E-18  -1.20491087777788E-01  -1.20455746922249E-01   0.00000000000000E+00  -7.44875660930350E-13
     -1.05781479137476E-22  -1.11427912001094E-10  -1.12172787662130E-10  -3.29524465674599E-18
      6.16940032453079E-07
      0.00000000000000E+00   1.33174868950914E-14   0.00000000000000E+00   6.62647192109559E-16  -4.64083786567964E-23
     -1.33618041679852E-11  -1.33611415208395E-11  -1.30827562243228E-18  -1.51183857944753E-02  -1.51183857945795E-02
      0.00000000000000E+00   0.00000000000000E+00   1.04214608209464E-10   0.00000000000000E+00   1.04214608209464E-10
      4.69090269459989E-18  -1.34973781524629E-01  -1.34945157669319E-01   0.00000000000000E+00  -5.33401897249527E-13
     -1.07398083470828E-22  -9.03200647912675E-11  -9.08534666886245E-11  -3.38262707216761E-18
      6.18290032453079E-07
      0.00000000000000E+00  -4.04116843713118E-15   0.00000000000000E+00   1.01754893870246E-15  -4.62423602212434E-23
      4.00643917036922E-12   4.00745671926168E-12  -1.31747591545443E-18  -1.12931808328826E-02  -1.12931808329589E-02
      0.00000000000000E+00   0.00000000000000E+00   7.62631876871168E-11   0.00000000000000E+00   7.62631876871168E-11
      4.79385799797750E-18  -1.54264952412353E-01  -1.54239662904779E-01   0.00000000000000E+00  -4.24829214557279E-13
     -1.09065419118671E-22  -7.98458151917125E-11  -8.02706444063789E-11  -3.47638208252307E-18
      6.20112532453079E-07
      0.00000000000000E+00  -1.91955500763731E-14   0.00000000000000E+00   9.08125950884242E-16  -4.56958214144855E-23
      1.92237139838883E-11   1.92246221097935E-11  -1.32084809369816E-18  -9.51843651092469E-03  -9.51843651098245E-03
      0.00000000000000E+00   0.00000000000000E+00   5.77684763968035E-11   0.00000000000000E+00   5.77684763968035E-11
      4.89914104621068E-18  -1.79821929207570E-01  -1.79797672470107E-01   0.00000000000000E+00  -4.06620141959334E-13
     -1.11138265803962E-22  -7.65864783645255E-11  -7.69930985065960E-11  -3.57829295251251E-18
      6.22112532453079E-07
      0.00000000000000E+00  -3.17782790738043E-14   0.00000000000000E+00   7.06354632558874E-16  -4.43893225519305E-23
      3.17783811106894E-11   3.17790874652775E-11  -1.32031367232595E-18  -8.72059174783942E-03  -8.72059174788570E-03
      0.00000000000000E+00   0.00000000000000E+00   4.62777045667587E-11   0.00000000000000E+00   4.62777045667587E-11
      4.99169645534419E-18  -2.07287654830988E-01  -2.07263063157413E-01   0.00000000000000E+00  -4.22928615621820E-13
     -1.13418345290509E-22  -7.76338634163019E-11  -7.80567920320371E-11  -3.67138278301825E-18
      6.24112532453079E-07
      0.00000000000000E+00  -4.22485791154623E-14   0.00000000000000E+00   5.47760815584788E-16  -4.18293802526965E-23
      4.22221743578297E-11   4.22227221186035E-11  -1.31801914655287E-18  -8.29184584732016E-03  -8.29184584735908E-03
      0.00000000000000E+00   0.00000000000000E+00   3.89115344449222E-11   0.00000000000000E+00   3.89115344449222E-11
      5.06951952423404E-18  -2.34186263294139E-01  -2.34160702270217E-01   0.00000000000000E+00  -4.44121071519286E-13
     -1.15735638846201E-22  -8.06901354918905E-11  -8.11342565635255E-11  -3.75150037768117E-18
      6.26112532453079E-07
      0.00000000000000E+00  -5.14330528362150E-14   0.00000000000000E+00   4.39810369494840E-16  -3.74120398314035E-23
      5.14147470487945E-11   5.14151868591266E-11  -1.31503626822090E-18  -8.01287649698355E-03  -8.01287649701742E-03
      0.00000000000000E+00   0.00000000000000E+00   3.38723451368464E-11   0.00000000000000E+00   3.38723451368464E-11
      5.13726421450773E-18  -2.60532517060624E-01  -2.60505647788712E-01   0.00000000000000E+00  -4.63331759769293E-13
     -1.18084480661572E-22  -8.48242002360855E-11  -8.52875319959729E-11  -3.82222794628683E-18
      6.28112532453080E-07
      0.00000000000000E+00  -5.97909239220999E-14   0.00000000000000E+00   3.68875154977983E-16  -3.05272818335834E-23
      5.97981913117285E-11   5.97985601868530E-11  -1.31186726602849E-18  -7.81188443525743E-03  -7.81188443528771E-03
      0.00000000000000E+00   0.00000000000000E+00   3.02797497693283E-11   0.00000000000000E+00   3.02797497693283E-11
      5.19782371404639E-18  -2.86337457767814E-01  -2.86309079441796E-01   0.00000000000000E+00  -4.80686647699010E-13
     -1.20458017910896E-22  -8.95976233083613E-11  -9.00783099561808E-11  -3.88595644801790E-18
      6.30112532453080E-07
      0.00000000000000E+00  -6.75977265847397E-14   0.00000000000000E+00   3.22217217738225E-16  -2.06834369732633E-23
      6.76351713450692E-11   6.76354935622663E-11  -1.30874756867007E-18  -7.65872108818773E-03  -7.65872108821535E-03
      0.00000000000000E+00   0.00000000000000E+00   2.76178597456485E-11   0.00000000000000E+00   2.76178597456485E-11
      5.25305943353768E-18  -3.11605557198072E-01  -3.11575548792898E-01   0.00000000000000E+00  -4.97491744402309E-13
     -1.22854123342134E-22  -9.47558615633893E-11  -9.52533533079144E-11  -3.94431186486761E-18
      6.32112532453080E-07
      0.00000000000000E+00  -7.51289950357569E-14   0.00000000000000E+00   2.91241393118360E-16  -7.69507375236152E-24
      7.51037470388790E-11   7.51040382802644E-11  -1.30577855130085E-18  -7.53743545697981E-03  -7.53743545700538E-03
      0.00000000000000E+00   0.00000000000000E+00   2.55627475384256E-11   0.00000000000000E+00   2.55627475384256E-11
      5.30418492861453E-18  -3.36342296513257E-01  -3.36310582961481E-01   0.00000000000000E+00  -5.15232188956464E-13
     -1.25276608358415E-22  -1.00151553629609E-10  -1.00666785818691E-10  -3.99840637731368E-18
      6.34112532453080E-07
      0.00000000000000E+00  -8.22928845379440E-14   0.00000000000000E+00   2.70243667454057E-16   7.98888785297055E-24
      8.23243468218233E-11   8.23246170654988E-11  -1.30299437888521E-18  -7.43848552531140E-03  -7.43848552533530E-03
      0.00000000000000E+00   0.00000000000000E+00   2.39012692380568E-11   0.00000000000000E+00   2.39012692380568E-11
      5.35198746709065E-18  -3.60552624896599E-01  -3.60519160343388E-01   0.00000000000000E+00  -5.35048702199714E-13
     -1.27733015608513E-22  -1.05690837601228E-10  -1.06225886303556E-10  -4.04899308820544E-18
      6.36112532453080E-07
      0.00000000000000E+00  -8.94567740401311E-14   0.00000000000000E+00   2.60389084494414E-16   2.48451983349691E-23
      8.94672952228602E-11   8.94675556119695E-11  -1.30033930412169E-18  -7.38381966502950E-03  -7.38381966505193E-03
      0.00000000000000E+00   0.00000000000000E+00   2.24306041239603E-11   0.00000000000000E+00   2.24306041239603E-11
      5.39684867533857E-18  -3.84226446693512E-01  -3.84191195525578E-01   0.00000000000000E+00  -5.56455212368515E-13
     -1.30226888943855E-22  -1.11341704523431E-10  -1.11898159735930E-10  -4.09650937121688E-18
      6.38112532453080E-07
      0.00000000000000E+00  -9.65288188051106E-14   0.00000000000000E+00   2.50380538075844E-16   4.17747919213959E-23
      9.65042861572148E-11   9.65045365377946E-11  -1.29784152320211E-18  -7.34487610221763E-03  -7.34487610223889E-03
      0.00000000000000E+00   0.00000000000000E+00   2.12549202378108E-11   0.00000000000000E+00   2.12549202378108E-11
      5.43935851581419E-18  -4.07490342650748E-01  -4.07453245360007E-01   0.00000000000000E+00  -5.85853322639854E-13
     -1.32787680269850E-22  -1.17173603452833E-10  -1.17759456775605E-10  -4.14151699261209E-18
      6.40112532453080E-07
      0.00000000000000E+00  -1.03509018832883E-13   0.00000000000000E+00   2.43151116660682E-16   5.78772474515518E-23
      1.03483197804827E-10   1.03483440956002E-10  -1.29548967417390E-18  -7.31610870969971E-03  -7.31610870971993E-03
      0.00000000000000E+00   0.00000000000000E+00   2.02277495615584E-11   0.00000000000000E+00   2.02277495615584E-11
      5.47981401493731E-18  -4.30398473555340E-01  -4.30359501700594E-01   0.00000000000000E+00  -6.20913369426602E-13
     -1.35429616597991E-22  -1.23090277147997E-10  -1.23711190517559E-10  -4.18432434076341E-18
      6.42112532453080E-07
      0.00000000000000E+00  -1.10397374123447E-13   0.00000000000000E+00   2.37009535680180E-16   7.24421564361244E-23
      1.10402724609624E-10   1.10402961619232E-10  -1.29326967124406E-18  -7.29803764007090E-03  -7.29803764009011E-03
      0.00000000000000E+00   0.00000000000000E+00   1.92127339241680E-11   0.00000000000000E+00   1.92127339241680E-11
      5.51823948278564E-18  -4.52878608404986E-01  -4.52837776921236E-01   0.00000000000000E+00  -6.56984956755411E-13
     -1.38142777656552E-22  -1.28958710586507E-10  -1.29615695543401E-10  -4.22496981154158E-18
      6.42612532453080E-07
      0.00000000000000E+00  -1.12142424130390E-13   0.00000000000000E+00   2.37408584423673E-16   7.60927102789788E-23
      1.12151013521465E-10   1.12151250930125E-10  -1.29272379379864E-18  -7.29419316994376E-03  -7.29419316996266E-03
      0.00000000000000E+00   0.00000000000000E+00   1.89032237715277E-11   0.00000000000000E+00   1.89032237715277E-11
      5.52769109467141E-18  -4.58469964817477E-01  -4.58428680193345E-01   0.00000000000000E+00  -6.79431973581492E-13
     -1.38829443237388E-22  -1.30375042727932E-10  -1.31054474701652E-10  -4.23496730087277E-18
      6.43287532453080E-07
      0.00000000000000E+00  -1.14530387297786E-13   0.00000000000000E+00   2.35237024833433E-16   8.07471674767248E-23
      1.14499989930432E-10   1.14500225167538E-10  -1.29200092216012E-18  -7.29045529788527E-03  -7.29045529790383E-03
      0.00000000000000E+00   0.00000000000000E+00   1.85533121412170E-11   0.00000000000000E+00   1.85533121412170E-11
      5.54021458036673E-18  -4.65967026124719E-01  -4.65925111912733E-01   0.00000000000000E+00  -6.91634821917637E-13
     -1.39764285139268E-22  -1.32361902486697E-10  -1.33053537308754E-10  -4.24821365820661E-18
      6.44198782453080E-07
      0.00000000000000E+00  -1.17653108362842E-13   0.00000000000000E+00   2.32547244375136E-16   8.65037874056411E-23
      1.17650193760790E-10   1.17650426308121E-10  -1.29104810240084E-18  -7.28842993009798E-03  -7.28842993011607E-03
      0.00000000000000E+00   0.00000000000000E+00   1.80961744390717E-11   0.00000000000000E+00   1.80961744390717E-11
      5.55670471932434E-18  -4.75994083319092E-01  -4.75951320961449E-01   0.00000000000000E+00  -7.08241567877351E-13
     -1.41038433370121E-22  -1.35038359179176E-10  -1.35746600747195E-10  -4.26565661692349E-18
      6.45428969953080E-07
      0.00000000000000E+00  -1.21877966274388E-13   0.00000000000000E+00   2.29695748291444E-16   9.33694953035678E-23
      1.21873574383940E-10   1.21873804079781E-10  -1.28979747072814E-18  -7.29219459189713E-03  -7.29219459191463E-03
      0.00000000000000E+00   0.00000000000000E+00   1.75052257719208E-11   0.00000000000000E+00   1.75052257719208E-11
      5.57823942925363E-18  -4.89360407225836E-01  -4.89316500903144E-01   0.00000000000000E+00  -7.30612241962314E-13
     -1.42776907617080E-22  -1.38648417609595E-10  -1.39379029851700E-10  -4.28844195852549E-18
      6.47089723078080E-07
      0.00000000000000E+00  -1.27572339981255E-13   0.00000000000000E+00   2.27327045641041E-16   1.01184870364715E-22
      1.27545754692522E-10   1.27545982019669E-10  -1.28815722093426E-18  -7.31267998226831E-03  -7.31267998228505E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67456993858989E-11   0.00000000000000E+00   1.67456993858989E-11
      5.60604990183907E-18  -5.07099470531344E-01  -5.07054017101403E-01   0.00000000000000E+00  -7.60549108165203E-13
     -1.45148137347221E-22  -1.43531132297258E-10  -1.44291681405568E-10  -4.31789268090482E-18
      6.49089723078080E-07
      0.00000000000000E+00  -1.34368850534612E-13   0.00000000000000E+00   2.27882027897274E-16   1.08870087286433E-22
      1.34411715910330E-10   1.34411943792466E-10  -1.28621146000120E-18  -7.37199831787228E-03  -7.37199831788814E-03
      0.00000000000000E+00   0.00000000000000E+00   1.58610282613059E-11   0.00000000000000E+00   1.58610282613059E-11
      5.63777195836168E-18  -5.28027853860147E-01  -5.27980516841603E-01   0.00000000000000E+00  -7.97231690980714E-13
     -1.48020699103018E-22  -1.49475740362644E-10  -1.50272972053772E-10  -4.35156049836048E-18
      6.51089723078080E-07
      0.00000000000000E+00  -1.41991963722836E-13   0.00000000000000E+00   2.59325032585993E-16   1.15582463669979E-22
      1.42037351716133E-10   1.42037611041282E-10  -1.28398793120015E-18  -7.60342570607955E-03  -7.60342570609433E-03
      0.00000000000000E+00   0.00000000000000E+00   1.47769732355662E-11   0.00000000000000E+00   1.47769732355662E-11
      5.66732590483282E-18  -5.48529696638515E-01  -5.48480299605409E-01   0.00000000000000E+00  -8.29390660531390E-13
     -1.50868498543714E-22  -1.55985193616165E-10  -1.56814584276848E-10  -4.38333797363266E-18
      6.53089723078080E-07
      0.00000000000000E+00  -1.51819350604042E-13   0.00000000000000E+00   3.50546644775972E-16   1.22407602468416E-22
      1.51855704614068E-10   1.51856055160835E-10  -1.28085878689915E-18  -8.28320815469271E-03  -8.28320815470596E-03
      0.00000000000000E+00   0.00000000000000E+00   1.32462748871547E-11   0.00000000000000E+00   1.32462748871547E-11
      5.69381845460713E-18  -5.68611062687463E-01  -5.68559055700671E-01   0.00000000000000E+00  -8.44955604968341E-13
     -1.53629340599855E-22  -1.64257374442869E-10  -1.65102330047990E-10  -4.41295966770797E-18
      6.55089723078080E-07
      0.00000000000000E+00  -1.76617429650074E-13   0.00000000000000E+00   9.53197825817237E-16   1.36764671162454E-22
      1.76645528140368E-10   1.76646481338331E-10  -1.27202980745609E-18  -1.15990768920815E-02  -1.15990768920893E-02
      0.00000000000000E+00   0.00000000000000E+00   7.83068765038806E-12   0.00000000000000E+00   7.83068765038806E-12
      5.70947982990790E-18  -5.88259664065998E-01  -5.88201554939284E-01   0.00000000000000E+00  -7.44633803663355E-13
     -1.55952308741990E-22  -1.83732535184899E-10  -1.84477168988718E-10  -4.43745002245181E-18
      6.57089723078080E-07
      0.00000000000000E+00  -3.33212706588907E-13   0.00000000000000E+00   5.57269950205578E-15   2.09195664207871E-22
      3.33245668944207E-10   3.33251241643918E-10  -1.22633527698917E-18  -3.13424497798120E-02  -3.13424497797885E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.34261903342081E-11   0.00000000000000E+00  -2.34261903342081E-11
      5.66262744923948E-18  -6.07279336707610E-01  -6.07181745318841E-01   0.00000000000000E+00   6.55081013057510E-14
     -1.55744990606327E-22  -3.09890559410860E-10  -3.09825051309710E-10  -4.43629217225031E-18
      6.59089723078080E-07
      0.00000000000000E+00  -7.34114984499761E-13   0.00000000000000E+00   1.20422975423220E-14   2.98717444589664E-22
      7.34075893923491E-10   7.34087936221332E-10  -1.15446226045198E-18  -6.07892887619091E-02  -6.07892887618612E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.79417673511953E-11   0.00000000000000E+00  -4.79417673511953E-11
      5.56674391453709E-18  -6.25196748739053E-01  -6.24980619260865E-01   0.00000000000000E+00   5.07332696783671E-13
     -1.54157747040060E-22  -6.86653501566767E-10  -6.86146168870137E-10  -4.41228165408511E-18
      6.60089723078080E-07
      0.00000000000000E+00  -1.06879720688399E-12   0.00000000000000E+00   1.84292485805683E-14   3.38378449252402E-22
      1.06881915177578E-09   1.06883758102470E-09  -1.11699320639625E-18  -7.56944741269343E-02  -7.56944741268803E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.40249524733859E-11   0.00000000000000E+00  -5.40249524733859E-11
      5.51271896206371E-18  -6.33744862003972E-01  -6.33425204258342E-01   0.00000000000000E+00   4.82304585423072E-13
     -1.53382489091900E-22  -1.01529493313658E-09  -1.01481262855131E-09  -4.39572575566745E-18
      6.61439723078080E-07
      0.00000000000000E+00  -1.72815057529682E-12   0.00000000000000E+00   2.58085328143787E-14   3.74309040639717E-22
      1.72812363222010E-09   1.72814944075329E-09  -1.06708575700767E-18  -9.57006217837584E-02  -9.57006217836977E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.07068780338456E-11   0.00000000000000E+00  -6.07068780338456E-11
      5.43076467671802E-18  -6.44272446966554E-01  -6.43747213282884E-01   0.00000000000000E+00   4.29086537420463E-13
     -1.52426747141784E-22  -1.66787164925671E-09  -1.66744256271944E-09  -4.36367891971035E-18
      6.63262223078080E-07
      0.00000000000000E+00  -3.13061971245576E-12   0.00000000000000E+00   3.94707353250890E-14   4.03837069179547E-22
      3.13056418180199E-09   3.13060365253772E-09  -1.00434004183690E-18  -1.22313613321486E-01  -1.22313613321415E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.07131241535153E-11   0.00000000000000E+00  -7.07131241535153E-11
      5.30189000794823E-18  -6.55768169926965E-01  -6.54804318522708E-01   0.00000000000000E+00   3.46149553535902E-13
     -1.51340824693759E-22  -3.06023667793759E-09  -3.05989052838420E-09  -4.29754996611133E-18
      6.65262223078080E-07
      0.00000000000000E+00  -5.56450524845522E-12   0.00000000000000E+00   6.13435467630487E-14   4.29198198529579E-22
      5.56448373173497E-09   5.56454507528217E-09  -9.42727939863117E-19  -1.50960356751527E-01  -1.50960356751443E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.45501780267692E-11   0.00000000000000E+00  -8.45501780267692E-11
      5.13278965189470E-18  -6.63447544438830E-01  -6.61721362408196E-01   0.00000000000000E+00   2.57600725888078E-13
     -1.50390365341090E-22  -5.48025249798114E-09  -5.47999489725540E-09  -4.19006171203158E-18
      6.67262223078080E-07
      0.00000000000000E+00  -9.13726552582801E-12   0.00000000000000E+00   8.92695182994485E-14   4.48055510407627E-22
      9.13715536796979E-09   9.13724463748853E-09  -8.87740342550340E-19  -1.79024392958883E-01  -1.79024392958783E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00339107550528E-10   0.00000000000000E+00  -1.00339107550528E-10
      4.93211143679364E-18  -6.64084375785639E-01  -6.61237762424841E-01   0.00000000000000E+00   2.40090996308390E-13
     -1.49443141474700E-22  -9.03714562093417E-09  -9.03690552993802E-09  -4.04437109424330E-18
      6.69262223078080E-07
      0.00000000000000E+00  -1.40103635925850E-11   0.00000000000000E+00   1.21210506991498E-13   4.56479215699570E-22
      1.40101732111899E-08   1.40102944216974E-08  -8.37482364081808E-19  -2.06507645907636E-01  -2.06507645907521E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15231246923874E-10   0.00000000000000E+00  -1.15231246923874E-10
      4.70164894294589E-18  -6.55293246945552E-01  -6.50916284213557E-01   0.00000000000000E+00   4.03465614230278E-13
     -1.47861689537393E-22  -1.38954666403876E-08  -1.38950631747735E-08  -3.86416657886409E-18
      6.71262223078080E-07
      0.00000000000000E+00  -2.03983487548429E-11   0.00000000000000E+00   1.58615943672649E-13   4.53253223801656E-22
      2.03981880099466E-08   2.03983466258908E-08  -7.90009331662510E-19  -2.33422928938613E-01  -2.33422928938486E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.27096466925025E-10   0.00000000000000E+00  -1.27096466925025E-10
      4.44745600909584E-18  -6.34312045104306E-01  -6.27926478767324E-01   0.00000000000000E+00   8.14983133173392E-13
     -1.44668609044152E-22  -2.02720651420988E-08  -2.02712501589657E-08  -3.65744667743333E-18
      6.73262223078080E-07
      0.00000000000000E+00  -2.86081661243493E-11   0.00000000000000E+00   2.01809829038776E-13   4.38721281133920E-22
      2.86079602433598E-08   2.86081620531893E-08  -7.43875661247805E-19  -2.59785142831898E-01  -2.59785142831763E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.35891989881985E-10   0.00000000000000E+00  -1.35891989881985E-10
      4.17567202933187E-18  -5.97830754281387E-01  -5.88861589222859E-01   0.00000000000000E+00   1.41263966731349E-12
     -1.38808918529362E-22  -2.84736827029745E-08  -2.84722700633073E-08  -3.43179636808407E-18
      6.75262223078080E-07
      0.00000000000000E+00  -3.88870617336668E-11   0.00000000000000E+00   2.55076870301741E-13   4.11495043392130E-22
      3.88868235127853E-08   3.88870785896560E-08  -6.98279596360284E-19  -2.85605632108978E-01  -2.85605632108834E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.43773048784867E-10   0.00000000000000E+00  -1.43773048784867E-10
      3.88812593176214E-18  -5.42110545239758E-01  -5.29905428116864E-01   0.00000000000000E+00   1.95857352523329E-12
     -1.29739991233748E-22  -3.87452641143962E-08  -3.87433055408711E-08  -3.18984633540185E-18
      6.77262223078080E-07
      0.00000000000000E+00  -5.09739209949146E-11   0.00000000000000E+00   3.00252149757578E-13   3.61003361239668E-22
      5.09736603701415E-08   5.09739606222917E-08  -6.53094037754771E-19  -3.10889139385619E-01  -3.10889139385464E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.54260627384289E-10   0.00000000000000E+00  -1.54260627384289E-10
      3.57960467699356E-18  -4.63953402618543E-01  -4.47943286062905E-01   0.00000000000000E+00   2.12357241476789E-12
     -1.18509388857861E-22  -5.08218235673220E-08  -5.08196999949073E-08  -2.92651063923879E-18
      6.79262223078080E-07
      0.00000000000000E+00  -6.37896600906412E-11   0.00000000000000E+00   3.18897561592709E-13   2.85146578489912E-22
      6.37893626902796E-08   6.37896815878415E-08  -6.08420625263512E-19  -3.35641040350212E-01  -3.35641040350045E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.67134968194783E-10   0.00000000000000E+00  -1.67134968194783E-10
      3.24533474060399E-18  -3.62260582927643E-01  -3.42216348444756E-01   0.00000000000000E+00   1.92368778107314E-12
     -1.06428347251052E-22  -6.36244703074277E-08  -6.36225466196468E-08  -2.63691411534048E-18
      6.81262223078080E-07
      0.00000000000000E+00  -7.46982432182536E-11   0.00000000000000E+00   2.72022982899308E-13   2.21915275319244E-22
      7.46979865274730E-08   7.46982585504561E-08  -5.64391848040450E-19  -3.59866729641584E-01  -3.59866729641401E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.82426257726514E-10   0.00000000000000E+00  -1.82426257726514E-10
      2.88048222515097E-18  -2.41222383224547E-01  -2.17745493757945E-01   0.00000000000000E+00   1.48895926691193E-12
     -9.21154106508035E-23  -7.45173212519964E-08  -7.45158322927296E-08  -2.31609037711052E-18
      6.83262223078081E-07
      0.00000000000000E+00  -7.75000587715064E-11   0.00000000000000E+00   7.02954418588011E-14   1.19258475808044E-22
      7.74999991846882E-08   7.75000694801302E-08  -5.21559318689182E-19  -3.83555439283391E-01  -3.83555439283183E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.08358919408303E-10   0.00000000000000E+00  -2.08358919408303E-10
      2.46376438633436E-18  -1.17041258771516E-01  -9.26893558095247E-02   0.00000000000000E+00   8.86991217007564E-13
     -7.66928682007786E-23  -7.72925975519389E-08  -7.72917105607219E-08  -1.94220506764518E-18
      6.85262223078081E-07
      0.00000000000000E+00  -5.27657199730962E-11   0.00000000000000E+00  -6.14600046581421E-13   3.32351814735804E-23
      5.27663166222804E-08   5.27657020222339E-08  -4.70949156598050E-19  -4.06828966007181E-01  -4.06828966007004E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.77359638828741E-10   0.00000000000000E+00  -1.77359638828741E-10
      2.10904510867688E-18  -4.34666162060393E-02  -2.68977636275263E-02   0.00000000000000E+00   9.36420486867113E-13
     -3.11219068269136E-23  -5.25892788038919E-08  -5.25883423834051E-08  -1.63809595207883E-18
      6.87262223078081E-07
      0.00000000000000E+00  -2.83777276786956E-11   0.00000000000000E+00  -6.03490136215909E-13   1.10922826390021E-23
      2.83783191707135E-08   2.83777156805773E-08  -4.13188349701490E-19  -4.29748606282653E-01  -4.29748606282534E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19153549953580E-10   0.00000000000000E+00  -1.19153549953580E-10
      1.87073800876972E-18  -1.88246811793094E-02  -9.92132004602390E-03   0.00000000000000E+00   7.01381250546008E-13
     -1.17430533021297E-23  -2.82592635118742E-08  -2.82585621306237E-08  -1.45754965906823E-18
      6.89262223078081E-07
      0.00000000000000E+00  -1.96393438465599E-11   0.00000000000000E+00  -2.15430748071422E-13   5.86860600361437E-24
      1.96396240528827E-08   1.96394086221346E-08  -3.57191864664289E-19  -4.52241490807284E-01  -4.52241490807183E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01696563155827E-10   0.00000000000000E+00  -1.01696563155827E-10
      1.66734488245806E-18  -1.16729344621732E-02  -5.51722431712514E-03   0.00000000000000E+00   2.68739227701356E-13
     -6.51709970024693E-24  -1.95379807982065E-08  -1.95377120589788E-08  -1.31015301779377E-18
      6.89762223078081E-07
      0.00000000000000E+00  -1.82122603198293E-11   0.00000000000000E+00  -1.40522374186715E-13   5.12490659095283E-24
      1.82123723472818E-08   1.82122318249076E-08  -3.43457089702911E-19  -4.57836077292020E-01  -4.57836077291919E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01580946174815E-10   0.00000000000000E+00  -1.01580946174815E-10
      1.61655440937066E-18  -1.05994251106059E-02  -4.89333500316364E-03   0.00000000000000E+00   1.85543449418880E-13
     -5.81422835049166E-24  -1.81108364221822E-08  -1.81106508787328E-08  -1.27309731966774E-18
      6.90437223078081E-07
      0.00000000000000E+00  -1.72543197107548E-11   0.00000000000000E+00  -7.00560046417326E-14   4.56730543129901E-24
      1.72543615972923E-08   1.72542915412877E-08  -3.25248989484821E-19  -4.65337519420120E-01  -4.65337519420019E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00492493307183E-10   0.00000000000000E+00  -1.00492493307183E-10
      1.54872197638831E-18  -9.79599289530718E-03  -4.39137460255165E-03   0.00000000000000E+00   1.11148707103334E-13
     -5.16296569104072E-24  -1.71539101966876E-08  -1.71537990479805E-08  -1.22347298690349E-18
      6.91348473078081E-07
      0.00000000000000E+00  -1.67019654611887E-11   0.00000000000000E+00  -2.97336456765652E-14   4.10991568987150E-24
      1.67020000692287E-08   1.67019703355830E-08  -3.01197010773652E-19  -4.75370471666123E-01  -4.75370471666023E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00618697026063E-10   0.00000000000000E+00  -1.00618697026063E-10
      1.45703318872331E-18  -9.21324201357721E-03  -3.98268051880374E-03   0.00000000000000E+00   6.76094729823583E-14
     -4.60963604843014E-24  -1.66014192480299E-08  -1.66013516385570E-08  -1.15583617794965E-18
      6.92578660578081E-07
      0.00000000000000E+00  -1.64216553232314E-11   0.00000000000000E+00  -1.26273600576607E-14   3.70668154003747E-24
      1.64216275027245E-08   1.64216148753645E-08  -2.69621266748014E-19  -4.88744671453004E-01  -4.88744671452902E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01666701560721E-10   0.00000000000000E+00  -1.01666701560721E-10
      1.33196408329708E-18  -8.76952022972160E-03  -3.62761729013589E-03   0.00000000000000E+00   4.74047078498756E-14
     -4.10949066655558E-24  -1.63199955785116E-08  -1.63199481738038E-08  -1.06234281654906E-18
      6.94239413703081E-07
      0.00000000000000E+00  -1.62839800621573E-11   0.00000000000000E+00  -3.77642036746373E-15   3.32901538392361E-24
      1.62839440594097E-08   1.62839402829894E-08  -2.28566266202731E-19  -5.06494186272475E-01  -5.06494186272372E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03305358095545E-10   0.00000000000000E+00  -1.03305358095545E-10
      1.16039938701066E-18  -8.39717210490700E-03  -3.29916019885467E-03   0.00000000000000E+00   3.52965983090772E-14
     -3.62959621487999E-24  -1.61806702214921E-08  -1.61806349248938E-08  -9.31833120807925E-19
      6.96239413703081E-07
      0.00000000000000E+00  -1.62112390302889E-11   0.00000000000000E+00  -1.50786430717948E-15   3.00173829989364E-24
      1.62112842527525E-08   1.62112827448882E-08  -1.81387593527405E-19  -5.27434896167209E-01  -5.27434896167104E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05199382435200E-10   0.00000000000000E+00  -1.05199382435200E-10
      9.50000622140257E-19  -8.09308039980041E-03  -3.01855449011778E-03   0.00000000000000E+00   2.97522641435557E-14
     -3.20810726675798E-24  -1.61061131147172E-08  -1.61060833624530E-08  -7.68613028612852E-19
      6.98239413703081E-07
      0.00000000000000E+00  -1.61693578301223E-11   0.00000000000000E+00  -7.76598783204492E-16   2.75717894090477E-24
      1.61693412241279E-08   1.61693404475291E-08  -1.36467080973158E-19  -5.47948828361947E-01  -5.47948828361840E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06926177008667E-10   0.00000000000000E+00  -1.06926177008667E-10
      7.36148268122922E-19  -7.87298301148922E-03  -2.81221384081037E-03   0.00000000000000E+00   2.61728112679719E-14
     -2.89147360276495E-24  -1.60624404433317E-08  -1.60624142705205E-08  -5.99681187149764E-19
      7.00239413703081E-07
      0.00000000000000E+00  -1.61425391668577E-11   0.00000000000000E+00  -4.24696986701113E-16   2.56771836070014E-24
      1.61425578490352E-08   1.61425574243382E-08  -9.36503589679214E-20  -5.68042172148191E-01  -5.68042172148083E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08079099938687E-10   0.00000000000000E+00  -1.08079099938687E-10
      5.19990068245548E-19  -7.70639741936421E-03  -2.65442812776881E-03   0.00000000000000E+00   2.34917639217209E-14
     -2.64461383775224E-24  -1.60345018161635E-08  -1.60344783243995E-08  -4.26339709277627E-19
      7.02239413703081E-07
      0.00000000000000E+00  -1.61242620641534E-11   0.00000000000000E+00  -2.33541171457824E-16   2.41640408312776E-24
      1.61242818190001E-08   1.61242815854590E-08  -5.28065339666742E-20  -5.87703784892881E-01  -5.87703784892773E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08621092947406E-10   0.00000000000000E+00  -1.08621092947406E-10
      3.02747882350735E-19  -7.57570946834663E-03  -2.52966739621720E-03   0.00000000000000E+00   2.13649991379483E-14
     -2.44731369346696E-24  -1.60156818575107E-08  -1.60156604925116E-08  -2.49941348384062E-19
      7.04239413703081E-07
      0.00000000000000E+00  -1.61100261298862E-11   0.00000000000000E+00  -1.50630065922848E-16   2.29335105963782E-24
      1.61100463952217E-08   1.61100462445917E-08  -1.41604897775385E-20  -6.06745629922749E-01  -6.06745629922642E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07606653649689E-10   0.00000000000000E+00  -1.07606653649689E-10
      8.75345750513578E-20  -7.47010324737686E-03  -2.42822526738189E-03   0.00000000000000E+00   1.94346411852172E-14
     -2.28745529993920E-24  -1.60024590255832E-08  -1.60024395909420E-08  -7.33740852738198E-20
      7.06239413703081E-07
      0.00000000000000E+00  -1.60867894113727E-11   0.00000000000000E+00  -3.93743798382762E-16   2.20196587952754E-24
      1.60867946205350E-08   1.60867942267912E-08   2.15437162357421E-20  -6.24699782780425E-01  -6.24699782780322E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03343589713790E-10   0.00000000000000E+00  -1.03343589713790E-10
     -1.19152604376222E-19  -7.40086149142929E-03  -2.36496519803309E-03   0.00000000000000E+00   1.75702564562962E-14
     -2.17056759669774E-24  -1.59834682073338E-08  -1.59834506370774E-08   9.76088881404787E-20
      7.07239413703081E-07
      0.00000000000000E+00  -1.60730127007916E-11   0.00000000000000E+00  -5.11803872217511E-16   2.16443893997564E-24
      1.60730452117711E-08   1.60730446999673E-08   3.83576256475314E-20  -6.33271677579328E-01  -6.33271677579228E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.98602547090834E-11   0.00000000000000E+00  -9.98602547090834E-11
     -2.19012859085305E-19  -7.37600290699478E-03  -2.34334065964955E-03   0.00000000000000E+00   1.62919185209307E-14
     -2.12366515750819E-24  -1.59732007371767E-08  -1.59731844452582E-08   1.80655233437774E-19
      7.08589413703081E-07
      0.00000000000000E+00  -1.60596033691593E-11   0.00000000000000E+00  -3.41840284267476E-16   2.12128426540334E-24
      1.60596134137146E-08   1.60596130718744E-08   5.88988789059611E-20  -6.43844485097894E-01  -6.43844485097802E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.19812968317935E-11   0.00000000000000E+00  -9.19812968317935E-11
     -3.43187609808226E-19  -7.34926815230829E-03  -2.31835475629657E-03   0.00000000000000E+00   1.43135778064266E-14
     -2.06923391002031E-24  -1.59676460886204E-08  -1.59676317750426E-08   2.84288730902266E-19
      7.10411913703081E-07
      0.00000000000000E+00  -1.60379280111783E-11   0.00000000000000E+00  -4.68122450401795E-16   2.07593674518116E-24
      1.60379541291330E-08   1.60379536610106E-08   8.11793603166362E-20  -6.55433600828394E-01  -6.55433600828318E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.53460885364181E-11   0.00000000000000E+00  -7.53460885364181E-11
     -4.80505856165848E-19  -7.32118225103390E-03  -2.29185116091716E-03   0.00000000000000E+00   1.13213215342284E-14
     -2.01330608747802E-24  -1.59626188937957E-08  -1.59626075724742E-08   3.99326495849211E-19
      7.12411913703081E-07
      0.00000000000000E+00  -1.60034862347255E-11   0.00000000000000E+00  -7.78541387427561E-16   2.04444995175003E-24
      1.60035031385738E-08   1.60035023600324E-08   9.61050587075755E-20  -6.63264742455323E-01  -6.63264742455276E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.67392424881659E-11   0.00000000000000E+00  -4.67392424881659E-11
     -5.73984341142180E-19  -7.30046717834796E-03  -2.27297705469148E-03   0.00000000000000E+00   6.89605274577930E-15
     -1.97708445974360E-24  -1.59567700135970E-08  -1.59567631175442E-08   4.77879282434605E-19
      7.14411913703081E-07
      0.00000000000000E+00  -1.59548085240055E-11   0.00000000000000E+00  -3.03615608551358E-16   2.03559018550246E-24
      1.59547988763825E-08   1.59547985727668E-08   9.77148888812038E-20  -6.64110070135863E-01  -6.64110070135858E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.08240778288924E-12   0.00000000000000E+00  -5.08240778288924E-12
     -5.84149156707959E-19  -7.29204881626737E-03  -2.26677919977132E-03   0.00000000000000E+00   9.52616647911964E-18
     -1.97206472932956E-24  -1.59497161745101E-08  -1.59497161649840E-08   4.86434267826755E-19
      7.16411913703081E-07
      0.00000000000000E+00  -1.58897824500626E-11   0.00000000000000E+00  -1.68409115207265E-15   2.05665831883489E-24
      1.58897320722302E-08   1.58897303881391E-08   8.14974619730096E-20  -6.55591618831865E-01  -6.55591618831916E-01
      0.00000000000000E+00   0.00000000000000E+00   5.08101255362933E-11   0.00000000000000E+00   5.08101255362933E-11
     -4.82528905635372E-19  -7.29991534023872E-03  -2.27753687765384E-03   0.00000000000000E+00  -7.10121008166860E-15
     -2.00876084227315E-24  -1.59405334124653E-08  -1.59405405136754E-08   4.01031443662362E-19
      7.18411913703081E-07
      0.00000000000000E+00  -1.58055608260433E-11   0.00000000000000E+00  -5.22789833418732E-14   2.12164384137400E-24
      1.58055883117402E-08   1.58055360327569E-08   4.16797307862191E-20  -6.34959245029678E-01  -6.34959245029800E-01
      0.00000000000000E+00   0.00000000000000E+00   1.21757221109930E-10   0.00000000000000E+00   1.21757221109930E-10
     -2.39014463415512E-19  -7.33169574233010E-03  -2.31347651148394E-03   0.00000000000000E+00   3.20269750788760E-14
     -2.10852375880118E-24  -1.59273252808419E-08  -1.59272932538668E-08   1.97334732629293E-19
      7.20411913703081E-07
      0.00000000000000E+00  -1.56851523755642E-11   0.00000000000000E+00  -3.33193634532374E-15   2.27397360371444E-24
      1.56851517862944E-08   1.56851484543581E-08  -2.98956858218096E-20  -5.98917760838995E-01  -5.98917760839203E-01
      0.00000000000000E+00   0.00000000000000E+00   2.07572286119784E-10   0.00000000000000E+00   2.07572286119784E-10
      1.76130108824056E-19  -7.42888824987898E-03  -2.42157981768061E-03   0.00000000000000E+00  -3.33847351247263E-14
     -2.34056174617631E-24  -1.58926873557427E-08  -1.58927207404779E-08  -1.46234423002247E-19
      7.22411913703081E-07
      0.00000000000000E+00  -1.54840124010797E-11   0.00000000000000E+00  -5.58680987839801E-15   2.65055472155197E-24
      1.54840137711268E-08   1.54840081843170E-08  -1.45517801905127E-19  -5.43732252819733E-01  -5.43732252820035E-01
      0.00000000000000E+00   0.00000000000000E+00   3.01933656126021E-10   0.00000000000000E+00   3.01933656126021E-10
      7.79997421076098E-19  -7.73131385980192E-03  -2.75765284466914E-03   0.00000000000000E+00  -5.73762222607529E-14
     -2.94943026059276E-24  -1.57858844642207E-08  -1.57859418404430E-08  -6.34479619170971E-19
      7.24411913703081E-07
      0.00000000000000E+00  -1.50537198072625E-11   0.00000000000000E+00  -1.17333353523739E-14   3.65372093489753E-24
      1.50537608492559E-08   1.50537491159206E-08  -3.23005679395699E-19  -4.66171520518355E-01  -4.66171520518734E-01
      0.00000000000000E+00   0.00000000000000E+00   3.79277795859549E-10   0.00000000000000E+00   3.79277795859549E-10
      1.53855301279520E-18  -8.71599489265556E-03  -3.85353698661819E-03   0.00000000000000E+00  -1.01124828221469E-13
     -5.08477479112075E-24  -1.54329257869519E-08  -1.54330269117802E-08  -1.21554733339950E-18
      7.26411913703081E-07
      0.00000000000000E+00  -1.26252531107583E-11   0.00000000000000E+00  -6.21565429456640E-14   5.81194478386150E-24
      1.26253260335799E-08   1.26252638770370E-08  -5.71548112090083E-19  -3.65065032587171E-01  -3.65065032587570E-01
      0.00000000000000E+00   0.00000000000000E+00   3.98747826990126E-10   0.00000000000000E+00   3.98747826990126E-10
      2.33604866677545E-18  -1.43870309275914E-02  -1.02835991615134E-02   0.00000000000000E+00  -1.81351128640377E-13
     -2.16959312515134E-23  -1.30238303528985E-08  -1.30240117040271E-08  -1.76450055468537E-18
      7.28411913703081E-07
      0.00000000000000E+00  -2.88107756146291E-12   0.00000000000000E+00  -2.44659287317816E-13  -2.15551784518435E-23
      2.88129867360114E-09   2.88105401431380E-09  -8.39015983375896E-19  -2.44379145220328E-01  -2.44379145220737E-01
      0.00000000000000E+00   0.00000000000000E+00   4.08956109166980E-10   0.00000000000000E+00   4.08956109166980E-10
      3.15396088510941E-18  -3.89610459021740E-02  -3.79244856891453E-02   0.00000000000000E+00  -3.58250344696873E-13
     -7.82713100716860E-23  -3.28965187313601E-09  -3.29001012348078E-09  -2.31494490173351E-18
      7.30411913703081E-07
      0.00000000000000E+00  -2.49817685204473E-14   0.00000000000000E+00  -7.75075147217962E-14  -4.37946705427145E-23
      2.50322831551356E-11   2.49547756403700E-11  -1.09539237880258E-18  -1.19845303604382E-01  -1.19845303604755E-01
      0.00000000000000E+00   0.00000000000000E+00   3.73468120606478E-10   0.00000000000000E+00   3.73468120606478E-10
      3.90089712632236E-18  -6.86885926339048E-02  -6.85630654421953E-02   0.00000000000000E+00  -1.04639121199219E-12
     -9.30168651259658E-23  -3.97376505034764E-10  -3.98422896246849E-10  -2.80550474751978E-18
      7.32411913703081E-07
      0.00000000000000E+00   7.17307397590784E-14   0.00000000000000E+00  -7.96753131246164E-15  -4.60406684790188E-23
     -7.17593435393090E-11  -7.17673110706675E-11  -1.24575377849202E-18  -4.45530602901073E-02  -4.45530602903468E-02
      0.00000000000000E+00   0.00000000000000E+00   2.39528504986416E-10   0.00000000000000E+00   2.39528504986416E-10
      4.37995413629520E-18  -9.82664166168490E-02  -9.82135618172773E-02   0.00000000000000E+00  -1.12590751097056E-12
     -1.02314513599712E-22  -1.66635286404676E-10  -1.67761193915749E-10  -3.13420035780318E-18
      7.34411913703081E-07
      0.00000000000000E+00   2.50736132576548E-14   0.00000000000000E+00  -2.29795093040000E-16  -4.63945114982654E-23
     -2.50442636908777E-11  -2.50444934860171E-11  -1.29923261061838E-18  -1.91469077411579E-02  -1.91469077412856E-02
      0.00000000000000E+00   0.00000000000000E+00   1.27643094189943E-10   0.00000000000000E+00   1.27643094189943E-10
      4.63524032467508E-18  -1.27369381076490E-01  -1.27337056729438E-01   0.00000000000000E+00  -6.53160839418155E-13
     -1.06551388108301E-22  -1.01945439864400E-10  -1.02598600703925E-10  -3.33600771405670E-18
      7.36411913703081E-07
      0.00000000000000E+00  -2.84718685343333E-15   0.00000000000000E+00   8.84503741822230E-16  -4.62275852760751E-23
      2.85024870572298E-12   2.85113320941857E-12  -1.31605727869222E-18  -1.17664896215990E-02  -1.17664896216783E-02
      0.00000000000000E+00   0.00000000000000E+00   7.93259432876763E-11   0.00000000000000E+00   7.93259432876763E-11
      4.79389221125043E-18  -1.55913171226357E-01  -1.55887281084117E-01   0.00000000000000E+00  -4.49670001147046E-13
     -1.09189635975231E-22  -8.17274064958389E-11  -8.21770764970951E-11  -3.47783493255822E-18
      7.36911913703082E-07
      0.00000000000000E+00  -8.81709477192257E-15   0.00000000000000E+00   1.01523622629453E-15  -4.61216127374182E-23
      8.85169185714257E-12   8.85270709332274E-12  -1.31865686630085E-18  -1.06593718801665E-02  -1.06593718802367E-02
      0.00000000000000E+00   0.00000000000000E+00   7.01952091968612E-11   0.00000000000000E+00   7.01952091968612E-11
      4.82898981584886E-18  -1.63012629892790E-01  -1.62987725661870E-01   0.00000000000000E+00  -4.25607551324924E-13
     -1.09792948871755E-22  -7.86223087387479E-11  -7.90479162901826E-11  -3.51033294954802E-18
      7.37586913703081E-07
      0.00000000000000E+00  -1.52462263764494E-14   0.00000000000000E+00   9.98863783976425E-16  -4.59115709633426E-23
      1.53102194115720E-11   1.53112182753101E-11  -1.32049036077274E-18  -9.83255370432790E-03  -9.83255370438981E-03
      0.00000000000000E+00   0.00000000000000E+00   6.19091500224523E-11   0.00000000000000E+00   6.19091500224523E-11
      4.87077849211402E-18  -1.72529650469328E-01  -1.72505322085759E-01   0.00000000000000E+00  -4.07883131044661E-13
     -1.10562480855597E-22  -7.68124851666070E-11  -7.72203682977622E-11  -3.55028813134128E-18
      7.38498163703082E-07
      0.00000000000000E+00  -2.24101158786365E-14   0.00000000000000E+00   8.86797402898961E-16  -4.54960353632903E-23
      2.23972987370534E-11   2.23981855344109E-11  -1.32132930606618E-18  -9.23546538736698E-03  -9.23546538742126E-03
      0.00000000000000E+00   0.00000000000000E+00   5.42853180546986E-11   0.00000000000000E+00   5.42853180546986E-11
      4.92024598819136E-18  -1.85254876400690E-01  -1.85230717237265E-01   0.00000000000000E+00  -4.08224001665690E-13
     -1.11585609829972E-22  -7.62752795873337E-11  -7.66835035891109E-11  -3.59891668212518E-18
      7.39728351203081E-07
      0.00000000000000E+00  -3.03087632784838E-14   0.00000000000000E+00   7.39112292490128E-16  -4.46329036827338E-23
      3.03264196525645E-11   3.03271587648123E-11  -1.32094281242550E-18  -8.78361572344705E-03  -8.78361572349423E-03
      0.00000000000000E+00   0.00000000000000E+00   4.71755255017769E-11   0.00000000000000E+00   4.71755255017769E-11
      4.97828072996958E-18  -2.02212774258724E-01  -2.02188357122158E-01   0.00000000000000E+00  -4.20277276733361E-13
     -1.12979722697153E-22  -7.70824069897435E-11  -7.75026842665898E-11  -3.65733791754409E-18
      7.41389104328081E-07
      0.00000000000000E+00  -3.93095475248215E-14   0.00000000000000E+00   5.83299882843981E-16  -4.27363834172597E-23
      3.93123240144972E-11   3.93129073143373E-11  -1.31912363752706E-18  -8.40653338869267E-03  -8.40653338873323E-03
      0.00000000000000E+00   0.00000000000000E+00   4.05619602116464E-11   0.00000000000000E+00   4.05619602116464E-11
      5.04564413214720E-18  -2.24711912283764E-01  -2.24686747953783E-01   0.00000000000000E+00  -4.38162611607512E-13
     -1.14894482261920E-22  -7.94367049142613E-11  -7.98748675259837E-11  -3.72652049462015E-18
      7.43389104328082E-07
      0.00000000000000E+00  -4.86777107199892E-14   0.00000000000000E+00   4.60108852775569E-16  -3.89270331171499E-23
      4.86850787422424E-11   4.86855388510562E-11  -1.31616336017804E-18  -8.09957706222981E-03  -8.09957706226489E-03
      0.00000000000000E+00   0.00000000000000E+00   3.50798027846172E-11   0.00000000000000E+00   3.50798027846172E-11
      5.11580373771644E-18  -2.51250969034408E-01  -2.51224579239052E-01   0.00000000000000E+00  -4.57271888582409E-13
     -1.17235477618080E-22  -8.33080697469741E-11  -8.37653416356738E-11  -3.79964037753840E-18
      7.45389104328082E-07
      0.00000000000000E+00  -5.72192712802892E-14   0.00000000000000E+00   3.82062936625285E-16  -3.28291926994687E-23
      5.71938359741737E-11   5.71942180370775E-11  -1.31296473876016E-18  -7.87778266956250E-03  -7.87778266959368E-03
      0.00000000000000E+00   0.00000000000000E+00   3.11757121931453E-11   0.00000000000000E+00   3.11757121931453E-11
      5.17815516210273E-18  -2.77246311261694E-01  -2.77218471057353E-01   0.00000000000000E+00  -4.75328328105389E-13
     -1.19604093826257E-22  -8.78946019019976E-11  -8.83699302302226E-11  -3.86519042334257E-18
      7.47389104328082E-07
      0.00000000000000E+00  -6.51179186801365E-14   0.00000000000000E+00   3.31023652728316E-16  -2.38976828728705E-23
      6.51161429124062E-11   6.51164739360351E-11  -1.30979086693872E-18  -7.71009600743740E-03  -7.71009600746571E-03
      0.00000000000000E+00   0.00000000000000E+00   2.83095047345245E-11   0.00000000000000E+00   2.83095047345245E-11
      5.23477417157178E-18  -3.02704288829813E-01  -3.02674856022508E-01   0.00000000000000E+00  -4.92061901740555E-13
     -1.21994803224629E-22  -9.29339167686973E-11  -9.34259786705599E-11  -3.92498330463306E-18
      7.49389104328082E-07
      0.00000000000000E+00  -7.26491871311537E-14   0.00000000000000E+00   2.97219480021325E-16  -1.18353940906908E-23
      7.26400101879089E-11   7.26403074073771E-11  -1.30675983965331E-18  -7.57865877598386E-03  -7.57865877600998E-03
      0.00000000000000E+00   0.00000000000000E+00   2.61203041637055E-11   0.00000000000000E+00   2.61203041637055E-11
      5.28701477989919E-18  -3.27627893343278E-01  -3.27596780202096E-01   0.00000000000000E+00  -5.09155100460279E-13
     -1.24409118599457E-22  -9.82514564704972E-11  -9.87606115710819E-11  -3.98025494024588E-18
      7.51389104328082E-07
      0.00000000000000E+00  -7.99049213705483E-14   0.00000000000000E+00   2.74485407875646E-16   3.18097402007158E-24
      7.98972299162905E-11   7.98975044017015E-11  -1.30391369454681E-18  -7.47252306485081E-03  -7.47252306487518E-03
      0.00000000000000E+00   0.00000000000000E+00   2.43756065564073E-11   0.00000000000000E+00   2.43756065564073E-11
      5.33576599301200E-18  -3.52025715970256E-01  -3.51992866495679E-01   0.00000000000000E+00  -5.28076049770374E-13
     -1.26854052396252E-22  -1.03745034908212E-10  -1.04273110958109E-10  -4.03185229846519E-18
      7.53389104328082E-07
      0.00000000000000E+00  -8.70688108727354E-14   0.00000000000000E+00   2.61669770668086E-16   1.98097037896007E-23
      8.70290726745365E-11   8.70293343443270E-11  -1.30122226688343E-18  -7.40216187098246E-03  -7.40216187100533E-03
      0.00000000000000E+00   0.00000000000000E+00   2.28725966955176E-11   0.00000000000000E+00   2.28725966955176E-11
      5.38151118640304E-18  -3.75887695572583E-01  -3.75853073158051E-01   0.00000000000000E+00  -5.48710911749221E-13
     -1.29334432270484E-22  -1.09353220127966E-10  -1.09901931039845E-10  -4.08028891951961E-18
      7.55389104328082E-07
      0.00000000000000E+00  -9.40490109005074E-14   0.00000000000000E+00   2.52357331909730E-16   3.67983386559696E-23
      9.40732936678548E-11   9.40735460252235E-11  -1.29867939511281E-18  -7.35803572573184E-03  -7.35803572575344E-03
      0.00000000000000E+00   0.00000000000000E+00   2.16002868941538E-11   0.00000000000000E+00   2.16002868941538E-11
      5.42471176019134E-18  -3.99272935376998E-01  -3.99236494987387E-01   0.00000000000000E+00  -5.74380645362875E-13
     -1.31867767151967E-22  -1.15099452273883E-10  -1.15673832919378E-10  -4.12603236507854E-18
      7.57389104328082E-07
      0.00000000000000E+00  -1.01029210928279E-13   0.00000000000000E+00   2.44852624700258E-16   5.32152337638973E-23
      1.01057828520233E-10   1.01058073372911E-10  -1.29628449309952E-18  -7.32550961150555E-03  -7.32550961152612E-03
      0.00000000000000E+00   0.00000000000000E+00   2.05621096881148E-11   0.00000000000000E+00   2.05621096881148E-11
      5.46583597956757E-18  -4.22316807084528E-01  -4.22278493808037E-01   0.00000000000000E+00  -6.08499091917984E-13
     -1.34482406944602E-22  -1.21011683968972E-10  -1.21620183061025E-10  -4.16955148646805E-18
      7.59389104328082E-07
      0.00000000000000E+00  -1.08009410956051E-13   0.00000000000000E+00   2.38548306204492E-16   6.82757626242321E-23
      1.07986676214876E-10   1.07986914763250E-10  -1.29402557867266E-18  -7.30332694390036E-03  -7.30332694391991E-03
      0.00000000000000E+00   0.00000000000000E+00   1.95506047891023E-11   0.00000000000000E+00   1.95506047891023E-11
      5.50493718914578E-18  -4.44953245713119E-01  -4.44913068744980E-01   0.00000000000000E+00  -6.44070407015201E-13
     -1.37171533453678E-22  -1.26893449145201E-10  -1.27537519552353E-10  -4.21091161047311E-18
      7.61389104328082E-07
      0.00000000000000E+00  -1.14897766246616E-13   0.00000000000000E+00   2.33314794611936E-16   8.14864868811775E-23
      1.14863065832834E-10   1.14863299147710E-10  -1.29188540271382E-18  -7.29323031734168E-03  -7.29323031736023E-03
      0.00000000000000E+00   0.00000000000000E+00   1.85570118232988E-11   0.00000000000000E+00   1.85570118232988E-11
      5.54205121279238E-18  -4.67143930627638E-01  -4.67101900908731E-01   0.00000000000000E+00  -6.81412780955080E-13
     -1.39926486405701E-22  -1.32738898189914E-10  -1.33420310971009E-10  -4.25016581007855E-18
      7.63389104328082E-07
      0.00000000000000E+00  -1.21694276799973E-13   0.00000000000000E+00   2.29379474770438E-16   9.26749676014110E-23
      1.21700404978972E-10   1.21700634358539E-10  -1.28984230716278E-18  -7.29888855629628E-03  -7.29888855631387E-03
      0.00000000000000E+00   0.00000000000000E+00   1.75943923233878E-11   0.00000000000000E+00   1.75943923233878E-11
      5.57723999743915E-18  -4.88885479524699E-01  -4.88841599660868E-01   0.00000000000000E+00  -7.20830592899276E-13
     -1.42736808779328E-22  -1.38574196088884E-10  -1.39295026681926E-10  -4.28739769027637E-18
      7.65389104328082E-07
      0.00000000000000E+00  -1.28490787353330E-13   0.00000000000000E+00   2.27423757563314E-16   1.01930246009536E-22
      1.28530123722517E-10   1.28530351146377E-10  -1.28786780518294E-18  -7.32737016642972E-03  -7.32737016644638E-03
      0.00000000000000E+00   0.00000000000000E+00   1.66645559030677E-11   0.00000000000000E+00   1.66645559030677E-11
      5.61056910924529E-18  -5.10184531100244E-01  -5.10138793230433E-01   0.00000000000000E+00  -7.61376822224363E-13
     -1.45586299004566E-22  -1.44433530227074E-10  -1.45194907049444E-10  -4.32270130406234E-18
      7.67389104328082E-07
      0.00000000000000E+00  -1.35470987381102E-13   0.00000000000000E+00   2.32462869228687E-16   1.09570483045152E-22
      1.35508872147419E-10   1.35509104610398E-10  -1.28588104692691E-18  -7.41026154145516E-03  -7.41026154147089E-03
      0.00000000000000E+00   0.00000000000000E+00   1.57306094241429E-11   0.00000000000000E+00   1.57306094241429E-11
      5.64203032809357E-18  -5.31049925510271E-01  -5.31002284052520E-01   0.00000000000000E+00  -8.00625932630470E-13
     -1.48450298635444E-22  -1.50439088101762E-10  -1.51239714034541E-10  -4.35614928116667E-18
      7.69389104328082E-07
      0.00000000000000E+00  -1.43277790043742E-13   0.00000000000000E+00   2.70689583237960E-16   1.16291930018070E-22
      1.43320150186848E-10   1.43320420876547E-10  -1.28357811578460E-18  -7.68146611033861E-03  -7.68146611035323E-03
      0.00000000000000E+00   0.00000000000000E+00   1.46148224223812E-11   0.00000000000000E+00   1.46148224223812E-11
      5.67125997293833E-18  -5.51489912927189E-01  -5.51440162983215E-01   0.00000000000000E+00  -8.32092416058789E-13
     -1.51286258484217E-22  -1.57103150882719E-10  -1.57935243298929E-10  -4.38768185715373E-18
      7.71389104328082E-07
      0.00000000000000E+00  -1.54023624297022E-13   0.00000000000000E+00   4.02471841856581E-16   1.23531521093036E-22
      1.54006360481536E-10   1.54006762953501E-10  -1.28009845349401E-18  -8.52479413666686E-03  -8.52479413667973E-03
      0.00000000000000E+00   0.00000000000000E+00   1.28640952788108E-11   0.00000000000000E+00   1.28640952788108E-11
      5.69698816349596E-18  -5.71509536491499E-01  -5.71456972538472E-01   0.00000000000000E+00  -8.41213738931004E-13
     -1.54014951843105E-22  -1.66029644493226E-10  -1.66870858232311E-10  -4.41688971000194E-18
      7.73389104328082E-07
      0.00000000000000E+00  -1.86261127056864E-13   0.00000000000000E+00   1.23091185177341E-15   1.41863894304291E-22
      1.86230928533592E-10   1.86232159445585E-10  -1.26861964366817E-18  -1.30509203361996E-02  -1.30509203362052E-02
      0.00000000000000E+00   0.00000000000000E+00   5.55481396701765E-12   0.00000000000000E+00   5.55481396701765E-12
      5.70809779142999E-18  -5.91086991641316E-01  -5.91026580134659E-01   0.00000000000000E+00  -6.86649098444751E-13
     -1.56145318829581E-22  -1.91100324314003E-10  -1.91786973412604E-10  -4.43947814776182E-18
      7.75389104328082E-07
      0.00000000000000E+00  -3.78675851506633E-13   0.00000000000000E+00   6.67808346729416E-15   2.25107759257947E-22
      3.78685312115617E-10   3.78691990199309E-10  -1.21581685716863E-18  -3.58005529573842E-02  -3.58005529573547E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.95059642761647E-11   0.00000000000000E+00  -2.95059642761647E-11
      5.64908586287766E-18  -6.09974884168739E-01  -6.09864894547281E-01   0.00000000000000E+00   2.13631551337512E-13
     -1.55483487697551E-22  -3.49399657474328E-10  -3.49186025923146E-10  -4.43326900570904E-18
      7.77389104328082E-07
      0.00000000000000E+00  -8.25133119072420E-13   0.00000000000000E+00   1.31196378137946E-14   3.09239132511751E-22
      8.25142369095595E-10   8.25155488733718E-10  -1.14281900211847E-18  -6.54419586632851E-02  -6.54419586632354E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.97288210025278E-11   0.00000000000000E+00  -4.97288210025278E-11
      5.54962822087261E-18  -6.27666469148370E-01  -6.27422216776953E-01   0.00000000000000E+00   5.07144469296124E-13
     -1.53888273324544E-22  -7.75933812200332E-10  -7.75426667731190E-10  -4.40680921875414E-18
      7.79389104328082E-07
      0.00000000000000E+00  -1.69141268041381E-12   0.00000000000000E+00   2.31319450399178E-14   3.60461384097189E-22
      1.69140851284461E-09   1.69143164479001E-09  -1.06902575679293E-18  -9.50604263906285E-02  -9.50604263905689E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.95476272506733E-11   0.00000000000000E+00  -5.95476272506733E-11
      5.43053296637126E-18  -6.43351912756962E-01  -6.42837879814923E-01   0.00000000000000E+00   4.44220074040381E-13
     -1.52434945214665E-22  -1.63232823761323E-09  -1.63188401753934E-09  -4.36150720957833E-18
      7.81389104328082E-07
      0.00000000000000E+00  -3.24285398132335E-12   0.00000000000000E+00   3.97730106654051E-14   3.97538274092206E-22
      3.24279579259069E-09   3.24283556560175E-09  -1.00041426007359E-18  -1.24220526236351E-01  -1.24220526236280E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.08049466874431E-11   0.00000000000000E+00  -7.08049466874431E-11
      5.28892307299637E-18  -6.55746081861293E-01  -6.54746906256059E-01   0.00000000000000E+00   3.51408259447676E-13
     -1.51224470155850E-22  -3.17238202717360E-09  -3.17203061891431E-09  -4.28850881292279E-18
      7.83389104328082E-07
      0.00000000000000E+00  -5.74571491496567E-12   0.00000000000000E+00   6.30354381506631E-14   4.27190140409743E-22
      5.74563971042123E-09   5.74570274585981E-09  -9.39109512260368E-19  -1.52827038566124E-01  -1.52827038566039E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.50804412426831E-11   0.00000000000000E+00  -8.50804412426831E-11
      5.11876219051101E-18  -6.63075820111899E-01  -6.61292739815922E-01   0.00000000000000E+00   2.60402136759286E-13
     -1.50259926948551E-22  -5.66088270675374E-09  -5.66062230461713E-09  -4.17965267825064E-18
      7.85389104328082E-07
      0.00000000000000E+00  -9.40030885319036E-12   0.00000000000000E+00   9.12828829065103E-14   4.47462116785842E-22
      9.40017498968866E-09   9.40026627257201E-09  -8.84403370073532E-19  -1.80852341790761E-01  -1.80852341790660E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01073592002099E-10   0.00000000000000E+00  -1.01073592002099E-10
      4.91661500650681E-18  -6.63211532006855E-01  -6.60282296165303E-01   0.00000000000000E+00   2.48287779148398E-13
     -1.49279339601319E-22  -9.29944096834891E-09  -9.29919268056991E-09  -4.03221163643328E-18
      7.87389104328082E-07
      0.00000000000000E+00  -1.43667211729502E-11   0.00000000000000E+00   1.23294468244708E-13   4.55982811014578E-22
      1.43666723372608E-08   1.43667956317295E-08  -8.34340260256992E-19  -2.08297870674669E-01  -2.08297870674553E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15943683031990E-10   0.00000000000000E+00  -1.15943683031990E-10
      4.68472764044283E-18  -6.53747667020936E-01  -6.49258625110484E-01   0.00000000000000E+00   4.24011990681060E-13
     -1.47617506580560E-22  -1.42512759606881E-08  -1.42508519486975E-08  -3.85038738018584E-18
      7.89389104328083E-07
      0.00000000000000E+00  -2.08647363303827E-11   0.00000000000000E+00   1.58107786668172E-13   4.52350204102616E-22
      2.08645743392966E-08   2.08647324470837E-08  -7.86974533041850E-19  -2.35176428322277E-01  -2.35176428322149E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.27668347824670E-10   0.00000000000000E+00  -1.27668347824670E-10
      4.42939094479349E-18  -6.31893107665620E-01  -6.25360794846074E-01   0.00000000000000E+00   8.52896591510572E-13
     -1.44280295861355E-22  -2.07379169958504E-08  -2.07370640992591E-08  -3.64241641175164E-18
      7.91389104328083E-07
      0.00000000000000E+00  -2.92036874004029E-11   0.00000000000000E+00   2.06858997271604E-13   4.37207257919063E-22
      2.92034934017585E-08   2.92037002607562E-08  -7.40886321415133E-19  -2.61502777996456E-01  -2.61502777996319E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.36363846233604E-10   0.00000000000000E+00  -1.36363846233604E-10
      4.15666325232628E-18  -5.94303757327341E-01  -5.85147116722040E-01   0.00000000000000E+00   1.45042615440114E-12
     -1.38222834274929E-22  -2.90687868406768E-08  -2.90673364145225E-08  -3.41577693091115E-18
      7.93389104328083E-07
      0.00000000000000E+00  -3.96141965181388E-11   0.00000000000000E+00   2.54587326985443E-13   4.08919813568575E-22
      3.96139938975141E-08   3.96142484848415E-08  -6.95312262669747E-19  -2.87287882223433E-01  -2.87287882223289E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.44334507143573E-10   0.00000000000000E+00  -1.44334507143573E-10
      3.86799423803914E-18  -5.37238883670538E-01  -5.24804830422155E-01   0.00000000000000E+00   1.98310623692373E-12
     -1.28968616423706E-22  -3.94718970839348E-08  -3.94699139776980E-08  -3.17268197536939E-18
      7.95389104328083E-07
      0.00000000000000E+00  -5.17838997323477E-11   0.00000000000000E+00   3.00838963500075E-13   3.56277715613841E-22
      5.17836037816846E-08   5.17839046206484E-08  -6.50158805543615E-19  -3.12536161440415E-01  -3.12536161440260E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.55077375994317E-10   0.00000000000000E+00  -1.55077375994317E-10
      3.55783948605050E-18  -4.57595869910522E-01  -4.41330803858187E-01   0.00000000000000E+00   2.11541752453249E-12
     -1.17694954874059E-22  -5.16309426621785E-08  -5.16288272446541E-08  -2.90768068050689E-18
      7.97389104328083E-07
      0.00000000000000E+00  -6.45863213411793E-11   0.00000000000000E+00   3.18578039989193E-13   2.80226607538163E-22
      6.45859725555239E-08   6.45862911335641E-08  -6.05512437163816E-19  -3.37253538754560E-01  -3.37253538754392E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.67930568052440E-10   0.00000000000000E+00  -1.67930568052440E-10
      3.22197834994562E-18  -3.54465927175034E-01  -3.34170923714052E-01   0.00000000000000E+00   1.90067198360839E-12
     -1.05538981164925E-22  -6.44202612374952E-08  -6.44183605655117E-08  -2.61646591278181E-18
      7.99389104328083E-07
      0.00000000000000E+00  -7.51730805096165E-11   0.00000000000000E+00   2.64024539808921E-13   2.17084284874103E-22
      7.51728374564411E-08   7.51731014809811E-08  -5.61550730629163E-19  -3.61444126485853E-01  -3.61444126485669E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.83852718211951E-10   0.00000000000000E+00  -1.83852718211951E-10
      2.85427291352172E-18  -2.32651021434323E-01  -2.09024938060562E-01   0.00000000000000E+00   1.44519282115616E-12
     -9.10994589812686E-23  -7.49906939555902E-08  -7.49892487627691E-08  -2.29272218289256E-18
      8.01389104328083E-07
      0.00000000000000E+00  -7.69415509245474E-11   0.00000000000000E+00   4.46257197691086E-14   1.10795660304560E-22
      7.69415279863207E-08   7.69415726120406E-08  -5.18697564428567E-19  -3.85099092251407E-01  -3.85099092251198E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.09433963005412E-10   0.00000000000000E+00  -2.09433963005412E-10
      2.43540498751090E-18  -1.09723897450032E-01  -8.55482771963456E-02   0.00000000000000E+00   8.61699338774816E-13
     -7.45866590175475E-23  -7.67330003483740E-08  -7.67321386490353E-08  -1.91670742308233E-18
      8.03389104328083E-07
      0.00000000000000E+00  -5.04990837035516E-11   0.00000000000000E+00  -6.56913048342754E-13   3.04941439116541E-23
      5.04997399665779E-08   5.04990830535296E-08  -4.67179741947359E-19  -4.08351388038967E-01  -4.08351388038795E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.72372357963474E-10   0.00000000000000E+00  -1.72372357963474E-10
      2.09066027158395E-18  -4.07074244567725E-02  -2.48511339103971E-02   0.00000000000000E+00   9.50338806207737E-13
     -2.88002286211593E-23  -5.03276610343724E-08  -5.03267106955662E-08  -1.62348052963659E-18
      8.05389104328083E-07
      0.00000000000000E+00  -2.74053674458795E-11   0.00000000000000E+00  -5.71293589579876E-13   1.04768955858019E-23
      2.74059233208954E-08   2.74053520273058E-08  -4.09415558071619E-19  -4.31244776788710E-01  -4.31244776788594E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16938310821623E-10   0.00000000000000E+00  -1.16938310821623E-10
      1.85678364994070E-18  -1.80127349067971E-02  -9.41503538601474E-03   0.00000000000000E+00   6.63618229240398E-13
     -1.11535752494819E-23  -2.72890773347134E-08  -2.72884137164842E-08  -1.44736809186909E-18
      8.07389104328083E-07
      0.00000000000000E+00  -1.93512269059398E-11   0.00000000000000E+00  -1.98278854311957E-13   5.70245371954119E-24
      1.93513862272979E-08   1.93511879484436E-08  -3.53593148921640E-19  -4.53708375973687E-01  -4.53708375973586E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01291240430262E-10   0.00000000000000E+00  -1.01291240430262E-10
      1.65420116908018E-18  -1.14374046732113E-02  -5.37237566045578E-03   0.00000000000000E+00   2.50232962510448E-13
     -6.33863454599856E-24  -1.92501469409759E-08  -1.92498967080134E-08  -1.30060802015854E-18
      8.09389104328083E-07
      0.00000000000000E+00  -1.70744877153025E-11   0.00000000000000E+00  -5.58212009001883E-14   4.20837108969528E-24
      1.70744978154826E-08   1.70744419942817E-08  -3.00400266625139E-19  -4.75722566557981E-01  -4.75722566557881E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.99719427483143E-11   0.00000000000000E+00  -9.99719427483143E-11
      1.45425728358355E-18  -9.41268263463827E-03  -4.06456334363226E-03   0.00000000000000E+00   9.56637956432308E-14
     -4.67854207026176E-24  -1.69745657153290E-08  -1.69744700515334E-08  -1.15385701695841E-18
      8.11389104328083E-07
      0.00000000000000E+00  -1.64515967075610E-11   0.00000000000000E+00  -1.50410969873027E-14   3.53764653943277E-24
      1.64516264689146E-08   1.64516114278176E-08  -2.49747169991626E-19  -4.97289631963399E-01  -4.97289631963297E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01979776587441E-10   0.00000000000000E+00  -1.01979776587441E-10
      1.25029773040867E-18  -8.63094425056502E-03  -3.47968816273860E-03   0.00000000000000E+00   4.88671850324091E-14
     -3.88117886587897E-24  -1.63496805184152E-08  -1.63496316512302E-08  -1.00055056041704E-18
      8.13389104328083E-07
      0.00000000000000E+00  -1.62630394620740E-11   0.00000000000000E+00  -4.35446412409564E-15   3.13644888852935E-24
      1.62630683987855E-08   1.62630640443214E-08  -2.01539683093463E-19  -5.18417595898579E-01  -5.18417595898475E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04322143464518E-10   0.00000000000000E+00  -1.04322143464518E-10
      1.04165344347963E-18  -8.22501426777722E-03  -3.13389847771704E-03   0.00000000000000E+00   3.40795322767166E-14
     -3.37981126697714E-24  -1.61587759803892E-08  -1.61587419008569E-08  -8.40113760386171E-19
      8.15389104328083E-07
      0.00000000000000E+00  -1.61907576538916E-11   0.00000000000000E+00  -1.51481854038716E-15   2.85602409962048E-24
      1.61907645418315E-08   1.61907630270129E-08  -1.55657124331093E-19  -5.39115246476843E-01  -5.39115246476737E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06260507268853E-10   0.00000000000000E+00  -1.06260507268853E-10
      8.29132428941928E-19  -7.96319088673246E-03  -2.89546317112250E-03   0.00000000000000E+00   2.80795393569930E-14
     -3.01959731274268E-24  -1.60845305992834E-08  -1.60845025197441E-08  -6.73475304610835E-19
      8.17389104328083E-07
      0.00000000000000E+00  -1.61542952932203E-11   0.00000000000000E+00  -6.79811772279334E-16   2.64453882118287E-24
      1.61542860083556E-08   1.61542853285438E-08  -1.11948563106206E-19  -5.59390152419117E-01  -5.59390152419009E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07649908601040E-10   0.00000000000000E+00  -1.07649908601040E-10
      6.13832611739847E-19  -7.77401656827690E-03  -2.71821774996034E-03   0.00000000000000E+00   2.47003382292800E-14
     -2.74472979914911E-24  -1.60466601202810E-08  -1.60466354199428E-08  -5.01884048633641E-19
      8.19389104328083E-07
      0.00000000000000E+00  -1.61319770220788E-11   0.00000000000000E+00  -3.26276328204703E-16   2.47812050070056E-24
      1.61319351525190E-08   1.61319348262427E-08  -7.02606113484710E-20  -5.79242897198193E-01  -5.79242897198084E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08473043444957E-10   0.00000000000000E+00  -1.08473043444957E-10
      3.96886524849933E-19  -7.62897251355123E-03  -2.58047321299798E-03   0.00000000000000E+00   2.22585362545020E-14
     -2.52773300989044E-24  -1.60234840413340E-08  -1.60234617827977E-08  -3.26625913501462E-19
      8.21389104328083E-07
      0.00000000000000E+00  -1.61162715720163E-11   0.00000000000000E+00  -2.02641601659830E-16   2.34364136349763E-24
      1.61162625857677E-08   1.61162623831261E-08  -3.05870181414916E-20  -5.98600466473543E-01  -5.98600466473435E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08373803892031E-10   0.00000000000000E+00  -1.08373803892031E-10
      1.80138917065871E-19  -7.51340975086255E-03  -2.46981554713370E-03   0.00000000000000E+00   2.03072687174905E-14
     -2.35265142339633E-24  -1.60079088865028E-08  -1.60078885792341E-08  -1.49551898924381E-19
      8.23389104328083E-07
      0.00000000000000E+00  -1.60998313640562E-11   0.00000000000000E+00  -2.16773547463750E-16   2.23661768514086E-24
      1.60998220839373E-08   1.60998218671637E-08   6.50250502452154E-21  -6.17095919003339E-01  -6.17095919003233E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05678241673122E-10   0.00000000000000E+00  -1.05678241673122E-10
     -3.12175662803725E-20  -7.42386140375325E-03  -2.38459654309099E-03   0.00000000000000E+00   1.83515757048134E-14
     -2.21441278398929E-24  -1.59941619770663E-08  -1.59941436254906E-08   2.47150612558509E-20
      8.25389104328083E-07
      0.00000000000000E+00  -1.60722779428939E-11   0.00000000000000E+00  -5.60074487425796E-16   2.16105360290915E-24
      1.60722474260162E-08   1.60722468659417E-08   4.00290232778590E-20  -6.34127883943872E-01  -6.34127883943774E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.89051388104968E-11   0.00000000000000E+00  -9.89051388104968E-11
     -2.29027843901366E-19  -7.37404751434152E-03  -2.34133564648198E-03   0.00000000000000E+00   1.63695591351362E-14
     -2.11895731452079E-24  -1.59733580966903E-08  -1.59733417271312E-08   1.88998820623507E-19
      8.27389104328083E-07
      0.00000000000000E+00  -1.60517965664967E-11   0.00000000000000E+00  -3.66471745156499E-16   2.10207247832713E-24
      1.60517978924449E-08   1.60517975259732E-08   6.82952979196279E-20  -6.48716879840607E-01  -6.48716879840521E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.58714030218620E-11   0.00000000000000E+00  -8.58714030218620E-11
     -4.00770649945090E-19  -7.33753647722842E-03  -2.30716019706008E-03   0.00000000000000E+00   1.32435418605636E-14
     -2.04525884668455E-24  -1.59659393664932E-08  -1.59659261229513E-08   3.32475352025462E-19
      8.29389104328083E-07
      0.00000000000000E+00  -1.60235083874367E-11   0.00000000000000E+00  -5.99488203850151E-16   2.06026567054956E-24
      1.60235155663804E-08   1.60235149668922E-08   8.87126884253330E-20  -6.59379531731031E-01  -6.59379531730967E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.33843349148602E-11   0.00000000000000E+00  -6.33843349148602E-11
     -5.27539319774811E-19  -7.31107925497848E-03  -2.28252834928664E-03   0.00000000000000E+00   9.43515172740935E-15
     -1.99494419329299E-24  -1.59601400671290E-08  -1.59601306319773E-08   4.38826631349477E-19
      8.31389104328083E-07
      0.00000000000000E+00  -1.59824537899050E-11   0.00000000000000E+00  -9.69443687912907E-16   2.03873628414956E-24
      1.59824545268520E-08   1.59824535574083E-08   9.78566758894528E-20  -6.64186354558192E-01  -6.64186354558163E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.87482649540818E-11   0.00000000000000E+00  -2.87482649540818E-11
     -5.85035849682974E-19  -7.29574476129662E-03  -2.26921801126220E-03   0.00000000000000E+00   4.28414911142935E-15
     -1.97248031284886E-24  -1.59537095766033E-08  -1.59537052924542E-08   4.87179173793522E-19
      8.33389104328084E-07
      0.00000000000000E+00  -1.59261529659968E-11   0.00000000000000E+00  -1.41945347367488E-15   2.04289170127451E-24
      1.59261312551685E-08   1.59261298357150E-08   9.16205815375023E-20  -6.60901206797400E-01  -6.60901206797420E-01
      0.00000000000000E+00   0.00000000000000E+00   1.96174195364627E-11   0.00000000000000E+00   1.96174195364627E-11
     -5.45801010610049E-19  -7.29438221118076E-03  -2.27036297077764E-03   0.00000000000000E+00  -2.61220958801348E-15
     -1.98554429012982E-24  -1.59457446430419E-08  -1.59457472552515E-08   4.54180429072547E-19
      8.35389104328084E-07
      0.00000000000000E+00  -1.58523097972819E-11   0.00000000000000E+00  -2.01512785863282E-15   2.08257644445730E-24
      1.58523042026981E-08   1.58523021875702E-08   6.49938969246384E-20  -6.46991040775586E-01  -6.46991040775669E-01
      0.00000000000000E+00   0.00000000000000E+00   8.26286159838472E-11   0.00000000000000E+00   8.26286159838472E-11
     -3.80543778642354E-19  -7.31239222624251E-03  -2.29178167599863E-03   0.00000000000000E+00  -1.17835792856817E-14
     -2.04869815556884E-24  -1.59349190199748E-08  -1.59349308035540E-08   3.15549881717716E-19
      8.37389104328084E-07
      0.00000000000000E+00  -1.57579852521698E-11   0.00000000000000E+00  -2.59277682472193E-15   2.17726990225708E-24
      1.57579752769594E-08   1.57579726841826E-08   1.12360602254787E-20  -6.19463291732421E-01  -6.19463291732582E-01
      0.00000000000000E+00   0.00000000000000E+00   1.60846140814429E-10   0.00000000000000E+00   1.60846140814429E-10
     -5.88514970134973E-20  -7.35984410357760E-03  -2.34431158732030E-03   0.00000000000000E+00  -2.46983324964640E-14
     -2.19289071819473E-24  -1.59187941266645E-08  -1.59188188249970E-08   4.76154367880188E-20
      8.39389104328084E-07
      0.00000000000000E+00  -1.55976243410054E-11   0.00000000000000E+00  -3.65389358905592E-14   2.41671175825286E-24
      1.55976258977868E-08   1.55975893588509E-08  -7.95096649519225E-20  -5.74765376749606E-01  -5.74765376749858E-01
      0.00000000000000E+00   0.00000000000000E+00   2.52317140239137E-10   0.00000000000000E+00   2.52317140239137E-10
      4.45782783464777E-19  -7.53938208200872E-03  -2.54555489083467E-03   0.00000000000000E+00  -1.10704679652460E-14
     -2.56335252494582E-24  -1.58498954286221E-08  -1.58499064990900E-08  -3.66273118512855E-19
      8.41389104328084E-07
      0.00000000000000E+00  -1.53362342189128E-11   0.00000000000000E+00  -7.39511797828548E-15   3.00485035037825E-24
      1.53362601579690E-08   1.53362527628510E-08  -2.22235169573107E-19  -5.09221765988846E-01  -5.09221765989189E-01
      0.00000000000000E+00   0.00000000000000E+00   3.43351263563582E-10   0.00000000000000E+00   3.43351263563582E-10
      1.13248531059194E-18  -8.04676559144609E-03  -3.10661226728828E-03   0.00000000000000E+00  -7.48318549323454E-14
     -3.59922305172642E-24  -1.56795291945597E-08  -1.56796040264146E-08  -9.10250141018834E-19
      8.43389104328084E-07
      0.00000000000000E+00  -1.44596680470042E-11   0.00000000000000E+00  -2.31640100007483E-14   4.68182933777203E-24
      1.44597166551416E-08   1.44596934911317E-08  -4.35102301296685E-19  -4.20411890221272E-01  -4.20411890221668E-01
      0.00000000000000E+00   0.00000000000000E+00   3.96027312494886E-10   0.00000000000000E+00   3.96027312494886E-10
      1.92453993558171E-18  -1.01526682204093E-02  -5.47211026932787E-03   0.00000000000000E+00  -1.34746923504904E-13
     -8.76311856409222E-24  -1.48555860567030E-08  -1.48557208036265E-08  -1.48943763428503E-18
      8.45389104328084E-07
      0.00000000000000E+00  -8.33187902525520E-12   0.00000000000000E+00  -1.54291186207775E-13   9.79189544273472E-25
      8.33206398692593E-09   8.33190969573972E-09  -7.01250381456091E-19  -3.08865711428758E-01  -3.08865711429159E-01
      0.00000000000000E+00   0.00000000000000E+00   4.01390633213763E-10   0.00000000000000E+00   4.01390633213763E-10
      2.72732120200924E-18  -2.41778584525181E-02  -2.14263001651297E-02   0.00000000000000E+00  -2.29662712483889E-13
     -5.11916978757009E-23  -8.73307066624096E-09  -8.73330032895349E-09  -2.02607082055315E-18
      8.47389104328084E-07
      0.00000000000000E+00  -6.69180755294040E-13   0.00000000000000E+00  -1.94568594336589E-13  -3.76675313469556E-23
      6.69350583709416E-10   6.69156015115042E-10  -9.65611537741063E-19  -1.83454975622225E-01  -1.83454975622625E-01
      0.00000000000000E+00   0.00000000000000E+00   4.00228967206884E-10   0.00000000000000E+00   4.00228967206884E-10
      3.52777913642301E-18  -5.28927111575020E-02  -5.25557897078787E-02   0.00000000000000E+00  -6.42574911969001E-13
     -8.65505650882374E-23  -1.06874240740987E-09  -1.06938498232193E-09  -2.56216759868194E-18
      8.49389104328084E-07
      0.00000000000000E+00   7.98130766333407E-14   0.00000000000000E+00  -2.58269436710426E-14  -4.53784002300553E-23
     -7.97832319544252E-11  -7.98090588981417E-11  -1.18527477253647E-18  -7.46958330639688E-02  -7.46958330642894E-02
      0.00000000000000E+00   0.00000000000000E+00   3.20642091358508E-10   0.00000000000000E+00   3.20642091358508E-10
      4.16906331914002E-18  -8.26471452690582E-02  -8.25712683215035E-02   0.00000000000000E+00  -1.24242865068243E-12
     -9.83858758098823E-23  -2.39590603809586E-10  -2.40833032460367E-10  -2.98378854660355E-18
      8.51389104328084E-07
      0.00000000000000E+00   4.74837291362913E-14   0.00000000000000E+00  -2.46978997288126E-15  -4.63117768888486E-23
     -4.75205017030180E-11  -4.75229714930372E-11  -1.27886413722995E-18  -2.85275287251099E-02  -2.85275287252850E-02
      0.00000000000000E+00   0.00000000000000E+00   1.75130437806599E-10   0.00000000000000E+00   1.75130437806599E-10
      4.51932419475322E-18  -1.12020065836756E-01  -1.11979862040867E-01   0.00000000000000E+00  -8.76814589472833E-13
     -1.04688596800587E-22  -1.26730651723984E-10  -1.27607466313561E-10  -3.24046005752327E-18
      8.53389104328084E-07
      0.00000000000000E+00   9.73554214399784E-15   0.00000000000000E+00   5.88045224306370E-16  -4.63635721748856E-23
     -9.74094801817889E-12  -9.74035997300095E-12  -1.30985276822362E-18  -1.44724834690395E-02  -1.44724834691388E-02
      0.00000000000000E+00   0.00000000000000E+00   9.93177212494326E-11   0.00000000000000E+00   9.93177212494326E-11
      4.71795963725208E-18  -1.40866105274294E-01  -1.40837883504362E-01   0.00000000000000E+00  -5.21470982652485E-13
     -1.07880520498639E-22  -8.90558902936708E-11  -8.95773612764312E-11  -3.40810686902847E-18
      8.55389104328084E-07
      0.00000000000000E+00  -1.18479710997710E-14   0.00000000000000E+00   9.31718467543943E-16  -4.60120338497308E-23
      1.18140828422212E-11   1.18150145606427E-11  -1.31900019590146E-18  -1.03848978879781E-02  -1.03848978880452E-02
      0.00000000000000E+00   0.00000000000000E+00   6.70588010940112E-11   0.00000000000000E+00   6.70588010940112E-11
      4.85207723944011E-18  -1.69136972395277E-01  -1.69112123055628E-01   0.00000000000000E+00  -4.21209256196617E-13
     -1.10284842745169E-22  -7.84526063983472E-11  -7.88738156546541E-11  -3.53307704353865E-18
      8.57389104328084E-07
      0.00000000000000E+00  -2.63594395785602E-14   0.00000000000000E+00   7.89799535584825E-16  -4.50996806984703E-23
      2.63788221409690E-11   2.63796119404595E-11  -1.32044074434076E-18  -9.03406961742939E-03  -9.03406961748065E-03
      0.00000000000000E+00   0.00000000000000E+00   5.12552763683564E-11   0.00000000000000E+00   5.12552763683564E-11
      4.95458779217682E-18  -1.96825183465633E-01  -1.96800724639596E-01   0.00000000000000E+00  -4.17318539280958E-13
     -1.12565402426833E-22  -7.72175697694221E-11  -7.76348883088157E-11  -3.63414704783606E-18
      8.59389104328084E-07
      0.00000000000000E+00  -3.78400317295010E-14   0.00000000000000E+00   6.17421375744328E-16  -4.31772724349646E-23
      3.78225358869524E-11   3.78231533082850E-11  -1.31892164219650E-18  -8.44788135153485E-03  -8.44788135157687E-03
      0.00000000000000E+00   0.00000000000000E+00   4.20231331288941E-11   0.00000000000000E+00   4.20231331288941E-11
      5.03863405843461E-18  -2.23940338809652E-01  -2.23915183478460E-01   0.00000000000000E+00  -4.35379867991324E-13
     -1.14863692594374E-22  -7.94109065690725E-11  -7.98462864371787E-11  -3.71971241623811E-18
      8.61389104328084E-07
      0.00000000000000E+00  -4.75755738734989E-14   0.00000000000000E+00   4.87474138924975E-16  -3.96700490615362E-23
      4.76069353371393E-11   4.76074228112385E-11  -1.31622948269107E-18  -8.11196932143428E-03  -8.11196932147026E-03
      0.00000000000000E+00   0.00000000000000E+00   3.59820138907028E-11   0.00000000000000E+00   3.59820138907028E-11
      5.11059808621601E-18  -2.50497257393101E-01  -2.50470923009136E-01   0.00000000000000E+00  -4.55187250257572E-13
     -1.17195639176914E-22  -8.31342494515672E-11  -8.35894367019419E-11  -3.79436860352495E-18
      8.63389104328084E-07
      0.00000000000000E+00  -5.63926686454214E-14   0.00000000000000E+00   4.00288943355164E-16  -3.39596864195433E-23
      5.63787450080550E-11   5.63791452969644E-11  -1.31313343859497E-18  -7.88330646296585E-03  -7.88330646299763E-03
      0.00000000000000E+00   0.00000000000000E+00   3.17785650079286E-11   0.00000000000000E+00   3.17785650079286E-11
      5.17415521623187E-18  -2.76509072368035E-01  -2.76481299014748E-01   0.00000000000000E+00  -4.73314061187419E-13
     -1.19555777409870E-22  -8.76843962435859E-11  -8.81577103048929E-11  -3.86102177763691E-18
      8.65389104328084E-07
      0.00000000000000E+00  -6.44750055196838E-14   0.00000000000000E+00   3.42880661924838E-16  -2.54811298441646E-23
      6.44798273627104E-11   6.44801702433468E-11  -1.30998751012729E-18  -7.71356863135275E-03  -7.71356863138147E-03
      0.00000000000000E+00   0.00000000000000E+00   2.87255514137850E-11   0.00000000000000E+00   2.87255514137850E-11
      5.23160631905944E-18  -3.01982856363711E-01  -3.01953492938151E-01   0.00000000000000E+00  -4.90385004387818E-13
     -1.21939940556430E-22  -9.27153366526220E-11  -9.32057216571317E-11  -3.92161880893215E-18
      8.67389104328084E-07
      0.00000000000000E+00  -7.20981187079085E-14   0.00000000000000E+00   3.04952532887446E-16  -1.38857050630176E-23
      7.21280249001756E-11   7.21283298526946E-11  -1.30695103449727E-18  -7.58125311481939E-03  -7.58125311484580E-03
      0.00000000000000E+00   0.00000000000000E+00   2.64137988590503E-11   0.00000000000000E+00   2.64137988590503E-11
      5.28443391677754E-18  -3.26922137451909E-01  -3.26891093132280E-01   0.00000000000000E+00  -5.07761456300149E-13
     -1.24349306338691E-22  -9.80343672553210E-11  -9.85421287117455E-11  -3.97748288228027E-18
      8.69389104328084E-07
      0.00000000000000E+00  -7.94456976845106E-14   0.00000000000000E+00   2.79593519403472E-16   7.51657522453714E-25
      7.94729220839828E-11   7.94732016775030E-11  -1.30408618442786E-18  -7.47461313871124E-03  -7.47461313873582E-03
      0.00000000000000E+00   0.00000000000000E+00   2.45868785149462E-11   0.00000000000000E+00   2.45868785149462E-11
      5.33360767380744E-18  -3.51335611198535E-01  -3.51302828826688E-01   0.00000000000000E+00  -5.26864721828792E-13
     -1.26790372453691E-22  -1.03533215470493E-10  -1.04060080192449E-10  -4.02952148937958E-18
      8.71389104328084E-07
      0.00000000000000E+00  -8.67014319239053E-14   0.00000000000000E+00   2.65000651389874E-16   1.72721901703454E-23
      8.66653618706058E-11   8.66656268712745E-11  -1.30137384003376E-18  -7.40330767979149E-03  -7.40330767981452E-03
      0.00000000000000E+00   0.00000000000000E+00   2.30293052575126E-11   0.00000000000000E+00   2.30293052575126E-11
      5.37966628432246E-18  -3.75213406286545E-01  -3.75178849073250E-01   0.00000000000000E+00  -5.47621915393180E-13
     -1.29267676632211E-22  -1.09147310213265E-10  -1.09694932128788E-10  -4.07829244428870E-18
      8.73389104328084E-07
      0.00000000000000E+00  -9.37734766888848E-14   0.00000000000000E+00   2.54695199550240E-16   3.43004008987643E-23
      9.37543979242380E-11   9.37546526194718E-11  -1.29881015311144E-18  -7.35889246699141E-03  -7.35889246701312E-03
      0.00000000000000E+00   0.00000000000000E+00   2.17151139220178E-11   0.00000000000000E+00   2.17151139220178E-11
      5.42309651216650E-18  -3.98610798687632E-01  -3.98574422574186E-01   0.00000000000000E+00  -5.73194328011025E-13
     -1.31797771731284E-22  -1.14896572213347E-10  -1.15469766541490E-10  -4.12428635905506E-18
      8.75389104328084E-07
      0.00000000000000E+00  -1.00753676716657E-13   0.00000000000000E+00   2.46484960878804E-16   5.08930881568022E-23
      1.00771432392052E-10   1.00771678877063E-10  -1.29639700868630E-18  -7.32618166765757E-03  -7.32618166767822E-03
      0.00000000000000E+00   0.00000000000000E+00   2.06498851990240E-11   0.00000000000000E+00   2.06498851990240E-11
      5.46439628256454E-18  -4.21666083153508E-01  -4.21627832435634E-01   0.00000000000000E+00  -6.07271754433193E-13
     -1.34409347943320E-22  -1.20814292321520E-10  -1.21421564076087E-10  -4.16799927387825E-18
      8.76389104328084E-07
      0.00000000000000E+00  -1.04335621467750E-13   0.00000000000000E+00   2.44184343446484E-16   5.92138799782520E-23
      1.04296064862469E-10   1.04296309046871E-10  -1.29522870660265E-18  -7.31246766470291E-03  -7.31246766472299E-03
      0.00000000000000E+00   0.00000000000000E+00   2.00829566281505E-11   0.00000000000000E+00   2.00829566281505E-11
      5.48447923919270E-18  -4.33099512687367E-01  -4.33060330415310E-01   0.00000000000000E+00  -6.34034621053580E-13
     -1.35743826254982E-22  -1.23745231053832E-10  -1.24379265675021E-10  -4.18925053259005E-18
      8.77739104328084E-07
      0.00000000000000E+00  -1.09019703065334E-13   0.00000000000000E+00   2.39014501603640E-16   6.95319994192475E-23
      1.09002720400465E-10   1.09002959415036E-10  -1.29371408583494E-18  -7.29881482810197E-03  -7.29881482812135E-03
      0.00000000000000E+00   0.00000000000000E+00   1.93842746210410E-11   0.00000000000000E+00   1.93842746210410E-11
      5.51064800993110E-18  -4.48337254824425E-01  -4.48296810237930E-01   0.00000000000000E+00  -6.56023978229549E-13
     -1.37575419400299E-22  -1.27731210057709E-10  -1.28387234036076E-10  -4.21693392409616E-18
      8.79561604328084E-07
      0.00000000000000E+00  -1.15265145195446E-13   0.00000000000000E+00   2.33449802993255E-16   8.16327714679955E-23
      1.15279800161498E-10   1.15280033611383E-10  -1.29176721243518E-18  -7.29073117763390E-03  -7.29073117765238E-03
      0.00000000000000E+00   0.00000000000000E+00   1.84869217121712E-11   0.00000000000000E+00   1.84869217121712E-11
      5.54434042475153E-18  -4.68533731001946E-01  -4.68491592110869E-01   0.00000000000000E+00  -6.86265777026050E-13
     -1.40095193169060E-22  -1.33080689546388E-10  -1.33766955323554E-10  -4.25257321231636E-18
      8.81561604328084E-07
      0.00000000000000E+00  -1.22153500486011E-13   0.00000000000000E+00   2.29337835197996E-16   9.28194625907170E-23
      1.22118616280157E-10   1.22118845618085E-10  -1.28972643101980E-18  -7.29798902271212E-03  -7.29798902272965E-03
      0.00000000000000E+00   0.00000000000000E+00   1.75328502682298E-11   0.00000000000000E+00   1.75328502682298E-11
      5.57940612528799E-18  -4.90247435629604E-01  -4.90203443440966E-01   0.00000000000000E+00  -7.23971944922648E-13
     -1.42911375199206E-22  -1.38927723941249E-10  -1.39651695886314E-10  -4.28967969426819E-18
      8.83561604328085E-07
      0.00000000000000E+00  -1.28950011039368E-13   0.00000000000000E+00   2.27455012668087E-16   1.02071397870985E-22
      1.28952654860435E-10   1.28952882315549E-10  -1.28775246528357E-18  -7.32872370140109E-03  -7.32872370141769E-03
      0.00000000000000E+00   0.00000000000000E+00   1.66059772459355E-11   0.00000000000000E+00   1.66059772459355E-11
      5.61261807977986E-18  -5.11518860755326E-01  -5.11473008270969E-01   0.00000000000000E+00  -7.64327548135443E-13
     -1.45764370410407E-22  -1.44794532013204E-10  -1.45558859561485E-10  -4.32486561449629E-18
      8.85561604328085E-07
      0.00000000000000E+00  -1.35930211067140E-13   0.00000000000000E+00   2.33912070258096E-16   1.09726918292122E-22
      1.35966289302420E-10   1.35966523214600E-10  -1.28575266373917E-18  -7.41998279222545E-03  -7.41998279224112E-03
      0.00000000000000E+00   0.00000000000000E+00   1.56650645982258E-11   0.00000000000000E+00   1.56650645982258E-11
      5.64394820897631E-18  -5.32357108265110E-01  -5.32309343402470E-01   0.00000000000000E+00  -8.03124343000388E-13
     -1.48628928502258E-22  -1.50828463469677E-10  -1.51631587812826E-10  -4.35819554523715E-18
      8.87561604328085E-07
      0.00000000000000E+00  -1.43828858466987E-13   0.00000000000000E+00   2.70743997083852E-16   1.16494553063607E-22
      1.43867626091712E-10   1.43867896835826E-10  -1.28341172107156E-18  -7.71050052490409E-03  -7.71050052491862E-03
      0.00000000000000E+00   0.00000000000000E+00   1.45331541418622E-11   0.00000000000000E+00   1.45331541418622E-11
      5.67301451726004E-18  -5.52770391921798E-01  -5.52720495287997E-01   0.00000000000000E+00  -8.33815001933974E-13
     -1.51462013032621E-22  -1.57567235975603E-10  -1.58401050977688E-10  -4.38960279618848E-18
      8.89561604328085E-07
      0.00000000000000E+00  -1.55033916406305E-13   0.00000000000000E+00   4.06259612094380E-16   1.23996086645876E-22
      1.55020436918613E-10   1.55020843178349E-10  -1.27974441732039E-18  -8.64139455766542E-03  -8.64139455767808E-03
      0.00000000000000E+00   0.00000000000000E+00   1.26634561220428E-11   0.00000000000000E+00   1.26634561220428E-11
      5.69834142950413E-18  -5.72763221799168E-01  -5.72710401657855E-01   0.00000000000000E+00  -8.39188946216659E-13
     -1.54175928313171E-22  -1.66845110354022E-10  -1.67684299300392E-10  -4.41859701218373E-18
      8.91561604328085E-07
      0.00000000000000E+00  -1.91771811289316E-13   0.00000000000000E+00   1.41787637482935E-15   1.44750535999113E-22
      1.91780712120192E-10   1.91782129996711E-10  -1.26669349202665E-18  -1.38841294443247E-02  -1.38841294443289E-02
      0.00000000000000E+00   0.00000000000000E+00   4.21431984568244E-12   0.00000000000000E+00   4.21431984568244E-12
      5.70677006919549E-18  -5.92307877816744E-01  -5.92246140436119E-01   0.00000000000000E+00  -6.52063586446680E-13
     -1.56194746366285E-22  -1.95344386255790E-10  -1.95996449842393E-10  -4.44007657716884E-18
      8.93561604328085E-07
      0.00000000000000E+00  -4.01453346334099E-13   0.00000000000000E+00   7.18774365503556E-15   2.32342657260686E-22
      4.01434620755283E-10   4.01441808499171E-10  -1.21086553273344E-18  -3.78835950464029E-02  -3.78835950463708E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.21208093529480E-11   0.00000000000000E+00  -3.21208093529480E-11
      5.64252845048959E-18  -6.11132786371784E-01  -6.11016454444034E-01   0.00000000000000E+00   2.74246027998485E-13
     -1.55346383647555E-22  -3.69595245174066E-10  -3.69320999146223E-10  -4.43166291775616E-18
      8.95561604328085E-07
      0.00000000000000E+00  -8.70504419252939E-13   0.00000000000000E+00   1.36484482143437E-14   3.13826797148065E-22
      8.70449503434617E-10   8.70463151883145E-10  -1.13744834585978E-18  -6.75883122675292E-02  -6.75883122674787E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.05182791660780E-11   0.00000000000000E+00  -5.05182791660780E-11
      5.54149189215744E-18  -6.28715415577707E-01  -6.28457140170188E-01   0.00000000000000E+00   5.05405818146405E-13
     -1.53752094799084E-22  -8.20450278535060E-10  -8.19944872717067E-10  -4.40404354629766E-18
      8.97561604328085E-07
      0.00000000000000E+00  -1.77655275180519E-12   0.00000000000000E+00   2.40934987997318E-14   3.63423519249808E-22
      1.77655963267124E-09   1.77658372617040E-09  -1.06387176706286E-18  -9.71804086003823E-02  -9.71804086003221E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.02744535457544E-11   0.00000000000000E+00  -6.02744535457544E-11
      5.42094298506593E-18  -6.44216723656521E-01  -6.43676096957787E-01   0.00000000000000E+00   4.37970732714280E-13
     -1.52313873164242E-22  -1.71674724335721E-09  -1.71630927262465E-09  -4.35707121800307E-18
      8.99561604328085E-07
      0.00000000000000E+00  -3.38787682137404E-12   0.00000000000000E+00   4.12347241694558E-14   3.99896543393047E-22
      3.38786826552995E-09   3.38790950025452E-09  -9.95753631975636E-19  -1.26302946912516E-01  -1.26302946912444E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.17294935125459E-11   0.00000000000000E+00  -7.17294935125459E-11
      5.27748399804083E-18  -6.56314652864111E-01  -6.55270070291439E-01   0.00000000000000E+00   3.44034774778876E-13
     -1.51122959849003E-22  -3.31652404151660E-09  -3.31618000674198E-09  -4.28173036606520E-18
      9.01561604328085E-07
      0.00000000000000E+00  -5.96770364479626E-12   0.00000000000000E+00   6.49186347567599E-14   4.28972059311770E-22
      5.96761735442511E-09   5.96768227306029E-09  -9.34970964769559E-19  -1.54868076738679E-01  -1.54868076738592E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.62001773773650E-11   0.00000000000000E+00  -8.62001773773650E-11
      5.10508364328611E-18  -6.63205300159312E-01  -6.61352648759921E-01   0.00000000000000E+00   2.55532926565087E-13
     -1.50170364719177E-22  -5.88173762860934E-09  -5.88148209568292E-09  -4.17011267851655E-18
      9.02561604328085E-07
      0.00000000000000E+00  -7.73415347550862E-12   0.00000000000000E+00   8.83152981444941E-14   4.46048400548629E-22
      7.73402118067080E-09   7.73410949596939E-09  -9.06576899859075E-19  -1.69004510791644E-01  -1.69004510791549E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.53923925850721E-11   0.00000000000000E+00  -9.53923925850721E-11
      5.00969125070104E-18  -6.64897329087188E-01  -6.62491147457570E-01   0.00000000000000E+00   2.07240560133847E-13
     -1.49752609579346E-22  -7.63892434394431E-09  -7.63871710338432E-09  -4.10311435084196E-18
      9.03911604328085E-07
      0.00000000000000E+00  -1.05957599526835E-11   0.00000000000000E+00   1.05667174854202E-13   4.58099399070816E-22
      1.05956785568612E-08   1.05957842240365E-08  -8.70986461736874E-19  -1.87820939006056E-01  -1.87820939005949E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06686388600033E-10   0.00000000000000E+00  -1.06686388600033E-10
      4.86566462609099E-18  -6.63399060868768E-01  -6.60095002443829E-01   0.00000000000000E+00   2.34282771111237E-13
     -1.49105101797462E-22  -1.04893321182074E-08  -1.04890978354364E-08  -3.99467816435411E-18
      9.05734104328085E-07
      0.00000000000000E+00  -1.53983212612651E-11   0.00000000000000E+00   1.31032919632537E-13   4.60641190821796E-22
      1.53981452411141E-08   1.53982762740341E-08  -8.26163357070500E-19  -2.12743043246785E-01  -2.12743043246666E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19330624464112E-10   0.00000000000000E+00  -1.19330624464112E-10
      4.64818456300514E-18  -6.52938044252810E-01  -6.48125146922572E-01   0.00000000000000E+00   4.56657122225150E-13
     -1.47473100113825E-22  -1.52794023066921E-08  -1.52789456495700E-08  -3.82202120593465E-18
      9.07734104328085E-07
      0.00000000000000E+00  -2.21641556723948E-11   0.00000000000000E+00   1.67952783555080E-13   4.52681140753622E-22
      2.21639885403249E-08   2.21641564931089E-08  -7.79212684844715E-19  -2.39528822558570E-01  -2.39528822558440E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.29910510108652E-10   0.00000000000000E+00  -1.29910510108652E-10
      4.38836354278784E-18  -6.28584267416270E-01  -6.21643318279707E-01   0.00000000000000E+00   9.38912176838789E-13
     -1.43777655527663E-22  -2.20351848951769E-08  -2.20342459830002E-08  -3.60915085794312E-18
      9.09734104328085E-07
      0.00000000000000E+00  -3.08316353674063E-11   0.00000000000000E+00   2.15040688932344E-13   4.34577489685046E-22
      3.08314111149781E-08   3.08316261556674E-08  -7.33293221504197E-19  -2.65765221701001E-01  -2.65765221700863E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.37930169630270E-10   0.00000000000000E+00  -1.37930169630270E-10
      4.11250320352730E-18  -5.87903452869330E-01  -5.78234443196941E-01   0.00000000000000E+00   1.56254991925703E-12
     -1.37182159447878E-22  -3.06952585359563E-08  -3.06936959860372E-08  -3.37920998202310E-18
      9.11734104328085E-07
      0.00000000000000E+00  -4.15833476838682E-11   0.00000000000000E+00   2.66855706215637E-13   4.03117818951502E-22
      4.15830777490029E-08   4.15833446047096E-08  -6.87797994311123E-19  -2.91461906689628E-01  -2.91461906689482E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.45938129021255E-10   0.00000000000000E+00  -1.45938129021255E-10
      3.82062694548479E-18  -5.27138056226130E-01  -5.14084117663319E-01   0.00000000000000E+00   2.05156029122683E-12
     -1.27414596257762E-22  -4.14394580359794E-08  -4.14374064756883E-08  -3.13282895117367E-18
      9.13734104328085E-07
      0.00000000000000E+00  -5.39670491357706E-11   0.00000000000000E+00   3.07732793211539E-13   3.45251633843345E-22
      5.39667535069781E-08   5.39670612397716E-08  -6.42739196712919E-19  -3.16622327900359E-01  -3.16622327900202E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.57235351850861E-10   0.00000000000000E+00  -1.57235351850861E-10
      3.50615624178307E-18  -4.43433796542601E-01  -4.26481533589488E-01   0.00000000000000E+00   2.11009497636092E-12
     -1.15915559457317E-22  -5.38119359828970E-08  -5.38098258879207E-08  -2.86341704507015E-18
      9.15734104328085E-07
      0.00000000000000E+00  -6.67107819575266E-11   0.00000000000000E+00   3.17254267186788E-13   2.69391779851890E-22
      6.67105090896481E-08   6.67108263439156E-08  -5.98183488443780E-19  -3.41253450239632E-01  -3.41253450239462E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.70124628083740E-10   0.00000000000000E+00  -1.70124628083740E-10
      3.16590698561559E-18  -3.36424036510479E-01  -3.15460276201688E-01   0.00000000000000E+00   1.85989947958216E-12
     -1.03457039419010E-22  -6.65425616153113E-08  -6.65407017158319E-08  -2.56772349717181E-18
      9.17734104328085E-07
      0.00000000000000E+00  -7.64068308645252E-11   0.00000000000000E+00   2.41930392337864E-13   2.04297699795937E-22
      7.64066039307697E-08   7.64068458611622E-08  -5.54427505862903E-19  -3.65355862581493E-01  -3.65355862581305E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.87872977257909E-10   0.00000000000000E+00  -1.87872977257909E-10
      2.79016103109977E-18  -2.12549303157995E-01  -1.88535694649402E-01   0.00000000000000E+00   1.34634101203726E-12
     -8.87754699220053E-23  -7.62203192249162E-08  -7.62189728839042E-08  -2.23573352523687E-18
      9.19734104328085E-07
      0.00000000000000E+00  -7.50350378695936E-11   0.00000000000000E+00  -3.37047199382705E-14   9.13722488485870E-23
      7.50350747137878E-08   7.50350410090680E-08  -5.11303287286159E-19  -3.88929716451888E-01  -3.88929716451677E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.10717723015635E-10   0.00000000000000E+00  -2.10717723015635E-10
      2.36872558506850E-18  -9.37267925476302E-02  -7.01522198875328E-02   0.00000000000000E+00   8.24216658740792E-13
     -6.81451388349858E-23  -7.48251475027109E-08  -7.48243232860522E-08  -1.85742229778234E-18
      9.21734104328085E-07
      0.00000000000000E+00  -4.54129058464732E-11   0.00000000000000E+00  -7.22386431593364E-13   2.48929106615514E-23
      4.54136538488033E-08   4.54129314623717E-08  -4.57744237939844E-19  -4.12128125877552E-01  -4.12128125877391E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.60554383219122E-10   0.00000000000000E+00  -1.60554383219122E-10
      2.04761681863025E-18  -3.49296709759560E-02  -2.06721336830075E-02   0.00000000000000E+00   9.57390928940026E-13
     -2.39814222516877E-23  -4.52533344700814E-08  -4.52523770791525E-08  -1.58987258069041E-18
      9.22734104328085E-07
      0.00000000000000E+00  -3.01899161885373E-11   0.00000000000000E+00  -7.53170384531964E-13   1.26576803189575E-23
      3.01906816291216E-08   3.01899284587371E-08  -4.28392184422249E-19  -4.23646182297742E-01  -4.23646182297618E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.23550500982907E-10   0.00000000000000E+00  -1.23550500982907E-10
      1.92406631764735E-18  -2.07924488572173E-02  -1.13195068125491E-02   0.00000000000000E+00   8.54299278986109E-13
     -1.36564684486893E-23  -3.00672322570332E-08  -3.00663779577542E-08  -1.49567413322510E-18
      9.24084104328085E-07
      0.00000000000000E+00  -2.14687991669966E-11   0.00000000000000E+00  -3.18802197793397E-13   7.29237589300244E-24
      2.14690915247012E-08   2.14687727225034E-08  -3.89755465077980E-19  -4.39008434747946E-01  -4.39008434747841E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04519107190684E-10   0.00000000000000E+00  -1.04519107190684E-10
      1.78296552293993E-18  -1.34947851107297E-02  -6.76359407332433E-03   0.00000000000000E+00   3.81200203554023E-13
     -8.13603423897386E-24  -2.13646348155163E-08  -2.13642536153127E-08  -1.39321005786195E-18
      9.25906604328085E-07
      0.00000000000000E+00  -1.78102559050720E-11   0.00000000000000E+00  -9.79139463096990E-14   4.97452419028593E-24
      1.78103904284277E-08   1.78102925144814E-08  -3.39684901139348E-19  -4.59376435473654E-01  -4.59376435473555E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.90429295795116E-11   0.00000000000000E+00  -9.90429295795116E-11
      1.60245978378126E-18  -1.03098095195849E-02  -4.72955795804340E-03   0.00000000000000E+00   1.43707897058526E-13
     -5.55637709300969E-24  -1.77113932927989E-08  -1.77112495849019E-08  -1.26277488264192E-18
      9.27906604328085E-07
      0.00000000000000E+00  -1.66826780663752E-11   0.00000000000000E+00  -2.74637699346093E-14   4.03460748792909E-24
      1.66827410819962E-08   1.66827136182263E-08  -2.87200919210107E-19  -4.81276423754170E-01  -4.81276423754070E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00025729613598E-10   0.00000000000000E+00  -1.00025729613598E-10
      1.40240832455407E-18  -9.06624047995863E-03  -3.84155835288481E-03   0.00000000000000E+00   6.51958002438768E-14
     -4.21505509172125E-24  -1.65827530844130E-08  -1.65826878886127E-08  -1.11520740534396E-18
      9.29906604328085E-07
      0.00000000000000E+00  -1.63490061361002E-11   0.00000000000000E+00  -7.91226021265958E-15   3.41157472075849E-24
      1.63489889613890E-08   1.63489810491288E-08  -2.37194956844366E-19  -5.02730561631554E-01  -5.02730561631452E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02523054521313E-10   0.00000000000000E+00  -1.02523054521313E-10
      1.19736221551144E-18  -8.48829806207041E-03  -3.36954792314460E-03   0.00000000000000E+00   4.05240853686570E-14
     -3.72626633117582E-24  -1.62464985186929E-08  -1.62464579946075E-08  -9.60167258667077E-19
      9.31906604328085E-07
      0.00000000000000E+00  -1.62313530277374E-11   0.00000000000000E+00  -2.61197264272802E-15   3.05479626123744E-24
      1.62313790410242E-08   1.62313764290515E-08  -1.89597311620641E-19  -5.23747806846531E-01  -5.23747806846426E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04851792834653E-10   0.00000000000000E+00  -1.04851792834653E-10
      9.87658629842137E-19  -8.14488525189343E-03  -3.06391940748638E-03   0.00000000000000E+00   3.14509303724052E-14
     -3.27587501662738E-24  -1.61265560871472E-08  -1.61265246362169E-08  -7.98061318221496E-19
      9.33906604328085E-07
      0.00000000000000E+00  -1.61777157012082E-11   0.00000000000000E+00  -1.06161168039501E-15   2.79635451829309E-24
      1.61777082510183E-08   1.61777071894067E-08  -1.44285976909897E-19  -5.44336862321438E-01  -5.44336862321331E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06666053945317E-10   0.00000000000000E+00  -1.06666053945317E-10
      7.74326521951504E-19  -7.90863925143734E-03  -2.84515233654495E-03   0.00000000000000E+00   2.69240069430038E-14
     -2.94230199395722E-24  -1.60710680594683E-08  -1.60710411354613E-08  -6.30040545041609E-19
      9.35906604328085E-07
      0.00000000000000E+00  -1.61472232484553E-11   0.00000000000000E+00  -5.13380861702923E-16   2.59829884212328E-24
      1.61471823003315E-08   1.61471817869507E-08  -1.01107150765430E-19  -5.64504629616300E-01  -5.64504629616192E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07915800252543E-10   0.00000000000000E+00  -1.07915800252543E-10
      5.58494921446419E-19  -7.73326261506497E-03  -2.67978520282776E-03   0.00000000000000E+00   2.39617439819016E-14
     -2.68447298610546E-24  -1.60392899484421E-08  -1.60392659866981E-08  -4.57387770680990E-19
      9.37906604328085E-07
      0.00000000000000E+00  -1.61272929404812E-11   0.00000000000000E+00  -2.69143750098875E-16   2.44104568704056E-24
      1.61273359316975E-08   1.61273356625538E-08  -5.99169199616199E-20  -5.84246475400143E-01  -5.84246475400034E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08582157120526E-10   0.00000000000000E+00  -1.08582157120526E-10
      3.41330607205368E-19  -7.59696061011934E-03  -2.54994431389788E-03   0.00000000000000E+00   2.17239447927773E-14
     -2.47941083241867E-24  -1.60187752293780E-08  -1.60187535054332E-08  -2.81413687243747E-19
      9.39906604328086E-07
      0.00000000000000E+00  -1.61125977825280E-11   0.00000000000000E+00  -1.59981872537933E-16   2.31342926772965E-24
      1.61126273811315E-08   1.61126272211496E-08  -2.08255948653773E-20  -6.03431615848369E-01  -6.03431615848261E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08011253193941E-10   0.00000000000000E+00  -1.08011253193941E-10
      1.25308100817485E-19  -7.48743895222514E-03  -2.44487550098489E-03   0.00000000000000E+00   1.97894826310900E-14
     -2.31345312020229E-24  -1.60046357574383E-08  -1.60046159679557E-08  -1.04482505952109E-19
      9.41906604328086E-07
      0.00000000000000E+00  -1.60922082508680E-11   0.00000000000000E+00  -3.20485279281188E-16   2.21580558497417E-24
      1.60921895455014E-08   1.60921892250162E-08   1.54934610031998E-20  -6.21633802884069E-01  -6.21633802883964E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04464332186740E-10   0.00000000000000E+00  -1.04464332186740E-10
     -8.36205635559940E-20  -7.41013234953964E-03  -2.37288955634713E-03   0.00000000000000E+00   1.79095674837427E-14
     -2.18804558078511E-24  -1.59877428023969E-08  -1.59877248928294E-08   6.81271025527944E-20
      9.43906604328086E-07
      0.00000000000000E+00  -1.60677775507708E-11   0.00000000000000E+00  -4.41327927178034E-16   2.14435673491528E-24
      1.60677953853533E-08   1.60677949440253E-08   4.79163623155325E-20  -6.38178134825932E-01  -6.38178134825836E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.64408591943989E-11   0.00000000000000E+00  -9.64408591943989E-11
     -2.76502281944792E-19  -7.36381459752385E-03  -2.33172874873065E-03   0.00000000000000E+00   1.56065707525572E-14
     -2.09789974127719E-24  -1.59713696914017E-08  -1.59713540848309E-08   2.28585919629259E-19
      9.45906604328086E-07
      0.00000000000000E+00  -1.60459185033154E-11   0.00000000000000E+00  -4.10068311521382E-16   2.08941117096096E-24
      1.60459266039647E-08   1.60459261938964E-08   7.45409741470272E-20  -6.51967760872077E-01  -6.51967760871995E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.14045354120005E-11   0.00000000000000E+00  -8.14045354120005E-11
     -4.39311352768793E-19  -7.32970298630285E-03  -2.29976902296163E-03   0.00000000000000E+00   1.24156617341337E-14
     -2.02966500249867E-24  -1.59645340741461E-08  -1.59645216584844E-08   3.64770378621765E-19
      9.47906604328086E-07
      0.00000000000000E+00  -1.60147831374020E-11   0.00000000000000E+00  -6.85829749821544E-16   2.05221150401469E-24
      1.60148251288660E-08   1.60148244430362E-08   9.25596725604689E-20  -6.61399838165317E-01  -6.61399838165261E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.61809059750787E-11   0.00000000000000E+00  -5.61809059750787E-11
     -5.51673164718950E-19  -7.30578389353492E-03  -2.27770141056183E-03   0.00000000000000E+00   8.32565364056433E-15
     -1.98565942919100E-24  -1.59586518627148E-08  -1.59586435370611E-08   4.59113492158482E-19
      9.48906604328086E-07
      0.00000000000000E+00  -1.59939343820559E-11   0.00000000000000E+00  -9.74947786858166E-16   2.03870967223945E-24
      1.59938908573194E-08   1.59938898823716E-08   9.86609535929683E-20  -6.64610961396274E-01  -6.64610961396235E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.84363466942769E-11   0.00000000000000E+00  -3.84363466942769E-11
     -5.90109511413227E-19  -7.29654969215058E-03  -2.26947210195879E-03   0.00000000000000E+00   5.65517975386998E-15
     -1.97095308771607E-24  -1.59554591908571E-08  -1.59554535356773E-08   4.91448557820258E-19
      9.50256604328086E-07
      0.00000000000000E+00  -1.59596762950775E-11   0.00000000000000E+00  -1.12509607067878E-15   2.03109991632361E-24
      1.59597011000091E-08   1.59596999749130E-08   1.00608714755065E-19  -6.65636406224967E-01  -6.65636406224958E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.12508676193001E-12   0.00000000000000E+00  -9.12508676193001E-12
     -6.02428378541832E-19  -7.28984698349730E-03  -2.26430648032431E-03   0.00000000000000E+00   1.36563094031635E-15
     -1.96553424692466E-24  -1.59505762537820E-08  -1.59505748881511E-08   5.01819663786768E-19
      9.52079104328086E-07
      0.00000000000000E+00  -1.59023651790600E-11   0.00000000000000E+00  -1.16576951325417E-15   2.04466753951608E-24
      1.59024098285852E-08   1.59024086628157E-08   8.89980555579940E-20  -6.59522481177451E-01  -6.59522481177491E-01
      0.00000000000000E+00   0.00000000000000E+00   4.00913634706001E-11   0.00000000000000E+00   4.00913634706001E-11
     -5.29361868616664E-19  -7.29386478731439E-03  -2.27086886405380E-03   0.00000000000000E+00  -5.96744792083765E-15
     -1.99111036410405E-24  -1.59424940588384E-08  -1.59425000262863E-08   4.40363813058670E-19
      9.54079104328086E-07
      0.00000000000000E+00  -1.58221847234778E-11   0.00000000000000E+00  -8.81200078060240E-16   2.09981089175964E-24
      1.58221898803353E-08   1.58221889991353E-08   5.39531855554998E-20  -6.41275377153166E-01  -6.41275377153274E-01
      0.00000000000000E+00   0.00000000000000E+00   1.08107713842191E-10   0.00000000000000E+00   1.08107713842191E-10
     -3.13146440932282E-19  -7.32031162090933E-03  -2.30116187835637E-03   0.00000000000000E+00  -1.69804637878300E-14
     -2.07633087733973E-24  -1.59302797325137E-08  -1.59302967129775E-08   2.59193255376782E-19
      9.56079104328086E-07
      0.00000000000000E+00  -1.57152774493683E-11   0.00000000000000E+00  -6.27331865471222E-16   2.22502185554282E-24
      1.57152415340245E-08   1.57152409066927E-08  -1.10083905129278E-20  -6.08295188437736E-01  -6.08295188437927E-01
      0.00000000000000E+00   0.00000000000000E+00   1.91298109226962E-10   0.00000000000000E+00   1.91298109226962E-10
      6.94497775216419E-20  -7.39103036418691E-03  -2.37936828290163E-03   0.00000000000000E+00  -3.24446030988312E-14
     -2.26666968456749E-24  -1.59065065713165E-08  -1.59065390159196E-08  -5.84413870087142E-20
      9.58079104328085E-07
      0.00000000000000E+00  -1.55280978749393E-11   0.00000000000000E+00   5.82862382352644E-16   2.54256509725060E-24
      1.55281119142045E-08   1.55281124970669E-08  -1.17232961723438E-19  -5.56875494748105E-01  -5.56875494748390E-01
      0.00000000000000E+00   0.00000000000000E+00   2.85409406473978E-10   0.00000000000000E+00   2.85409406473978E-10
      6.40268590469598E-19  -7.64059940578073E-03  -2.65824940708975E-03   0.00000000000000E+00  -5.74112603891576E-14
     -2.76873694566318E-24  -1.58134644922805E-08  -1.58135219035408E-08  -5.23035628746161E-19
      9.60079104328085E-07
      0.00000000000000E+00  -1.51831290419879E-11   0.00000000000000E+00  -9.51491154056899E-15   3.35698489569029E-24
      1.51831726851650E-08   1.51831631702535E-08  -2.81658111863021E-19  -4.83555573848762E-01  -4.83555573849131E-01
      0.00000000000000E+00   0.00000000000000E+00   3.69576714726097E-10   0.00000000000000E+00   3.69576714726097E-10
      1.37942201992179E-18  -8.39340540697977E-03  -3.49322681858833E-03   0.00000000000000E+00  -9.04343032348957E-14
     -4.35210783405691E-24  -1.55526494506763E-08  -1.55527398849796E-08  -1.09776390805877E-18
      9.62079104328085E-07
      0.00000000000000E+00  -1.35619775855378E-11   0.00000000000000E+00  -4.19451546365709E-14   5.54093017323224E-24
      1.35620339010426E-08   1.35619919558879E-08  -5.18798364648649E-19  -3.86669928578327E-01  -3.86669928578728E-01
      0.00000000000000E+00   0.00000000000000E+00   4.00750242707181E-10   0.00000000000000E+00   4.00750242707181E-10
      2.18092250533616E-18  -1.22368616672603E-02  -7.83766076668324E-03   0.00000000000000E+00  -1.63511713269074E-13
     -1.48911311883237E-23  -1.39625786868818E-08  -1.39627421985951E-08  -1.66212414068751E-18
      9.64079104328085E-07
      0.00000000000000E+00  -4.60830968938765E-12   0.00000000000000E+00  -1.39810261590319E-13  -1.23384991911111E-23
      4.60860611708624E-09   4.60846630682464E-09  -7.87816020611520E-19  -2.68683250081127E-01  -2.68683250081535E-01
      0.00000000000000E+00   0.00000000000000E+00   4.08580706352390E-10   0.00000000000000E+00   4.08580706352390E-10
      2.99808391804094E-18  -3.34804780724989E-02  -3.18998152735881E-02   0.00000000000000E+00  -3.77604345022436E-13
     -4.33163790678931E-23  -5.01666940883196E-09  -5.01704701317702E-09  -2.21026789742941E-18
      9.66079104328085E-07
      0.00000000000000E+00  -1.57972947996946E-13   0.00000000000000E+00  -1.16265674663321E-13  -4.24356930568296E-23
      1.58125634482298E-10   1.58009368807593E-10  -1.04970610739767E-18  -1.42413344116124E-01  -1.42413344116510E-01
      0.00000000000000E+00   0.00000000000000E+00   3.86415562221861E-10   0.00000000000000E+00   3.86415562221861E-10
      3.77091504248466E-18  -6.30333240143131E-02  -6.28617973907186E-02   0.00000000000000E+00  -9.04057625159816E-13
     -9.06139417838611E-23  -5.43520873404203E-10  -5.44424931029453E-10  -2.72120893508699E-18
      9.68079104328085E-07
      0.00000000000000E+00   7.96293871589257E-14   0.00000000000000E+00  -1.22999791248467E-14  -4.58550936073080E-23
     -7.96634776963216E-11  -7.96757776754923E-11  -1.22685021796505E-18  -5.38547017878070E-02  -5.38547017880770E-02
      0.00000000000000E+00   0.00000000000000E+00   2.69965893802672E-10   0.00000000000000E+00   2.69965893802672E-10
      4.31084683009000E-18  -9.26816177864962E-02  -9.26216649621529E-02   0.00000000000000E+00  -1.20318914343893E-12
     -1.01069126453425E-22  -1.89086926983641E-10  -1.90290116127181E-10  -3.08399661212495E-18
      9.70079104328085E-07
      0.00000000000000E+00   3.26048817086720E-14   0.00000000000000E+00  -8.22749580325194E-16  -4.63813842145289E-23
     -3.25995789114219E-11  -3.26004016610486E-11  -1.29298394721476E-18  -2.19399724710685E-02  -2.19399724712113E-02
      0.00000000000000E+00   0.00000000000000E+00   1.42825312964272E-10   0.00000000000000E+00   1.42825312964272E-10
      4.59649745601855E-18  -1.21883914921991E-01  -1.21849187777671E-01   0.00000000000000E+00  -7.26954679204011E-13
     -1.05937027700103E-22  -1.09497956623914E-10  -1.10224911303223E-10  -3.30351350880379E-18
      9.72079104328085E-07
      0.00000000000000E+00   1.37767105811290E-15   0.00000000000000E+00   8.16962323400883E-16  -4.62885923416889E-23
     -1.37777604638028E-12  -1.37695908410317E-12  -1.31418010430138E-18  -1.25714104787607E-02  -1.25714104788464E-02
      0.00000000000000E+00   0.00000000000000E+00   8.57021358447989E-11   0.00000000000000E+00   8.57021358447989E-11
      4.76790172770815E-18  -1.50536861224858E-01  -1.50510294269523E-01   0.00000000000000E+00  -4.70129092342643E-13
     -1.08732787728586E-22  -8.38550476682440E-11  -8.43251767606954E-11  -3.45372162340676E-18
      9.74079104328085E-07
      0.00000000000000E+00  -1.71749658578075E-14   0.00000000000000E+00   9.01788743047182E-16  -4.57844516826209E-23
      1.71809061106549E-11   1.71818078993522E-11  -1.31993462827798E-18  -9.78740775423284E-03  -9.78740775429353E-03
      0.00000000000000E+00   0.00000000000000E+00   6.06915621972171E-11   0.00000000000000E+00   6.06915621972171E-11
      4.88928485210258E-18  -1.78609352028419E-01  -1.78584817946021E-01   0.00000000000000E+00  -4.15044895472088E-13
     -1.11063355966617E-22  -7.74583252009857E-11  -7.78733700965688E-11  -3.56935022382460E-18
      9.76079104328085E-07
      0.00000000000000E+00  -3.04924527528989E-14   0.00000000000000E+00   7.30703798186491E-16  -4.45880903422863E-23
      3.04642775170323E-11   3.04650082207859E-11  -1.32010002003079E-18  -8.79427245299901E-03  -8.79427245304669E-03
      0.00000000000000E+00   0.00000000000000E+00   4.76787885151369E-11   0.00000000000000E+00   4.76787885151369E-11
      4.98464242913285E-18  -2.06101342953132E-01  -2.06076723859940E-01   0.00000000000000E+00  -4.22623347811583E-13
     -1.13344208343947E-22  -7.77211733879981E-11  -7.81437967359231E-11  -3.66454240910206E-18
      9.78079104328085E-07
      0.00000000000000E+00  -4.12382870061795E-14   0.00000000000000E+00   5.69073485453134E-16  -4.21954183997957E-23
      4.12568101778135E-11   4.12573792512568E-11  -1.31807368734654E-18  -8.31899094767698E-03  -8.31899094771671E-03
      0.00000000000000E+00   0.00000000000000E+00   3.97332969882888E-11   0.00000000000000E+00   3.97332969882888E-11
      5.06410902310943E-18  -2.33025154818895E-01  -2.32999639020585E-01   0.00000000000000E+00  -4.42173545095705E-13
     -1.15653708271809E-22  -8.05485026943339E-11  -8.09906762395452E-11  -3.74603533576289E-18
      9.80079104328085E-07
      0.00000000000000E+00  -5.06982949385548E-14   0.00000000000000E+00   4.54596112466347E-16  -3.80091389547912E-23
      5.06571858531557E-11   5.06576404492302E-11  -1.31519517303865E-18  -8.02728387576871E-03  -8.02728387580312E-03
      0.00000000000000E+00   0.00000000000000E+00   3.44088566413707E-11   0.00000000000000E+00   3.44088566413707E-11
      5.13292673639217E-18  -2.59395642828361E-01  -2.59368843182212E-01   0.00000000000000E+00  -4.61467980136581E-13
     -1.17995555291107E-22  -8.46050291103466E-11  -8.50664970906012E-11  -3.81773156335352E-18
      9.82079104328085E-07
      0.00000000000000E+00  -5.91480107616472E-14   0.00000000000000E+00   3.78608031655927E-16  -3.14153832959354E-23
      5.91783386808511E-11   5.91787172888514E-11  -1.31205930222994E-18  -7.82161909874243E-03  -7.82161909877308E-03
      0.00000000000000E+00   0.00000000000000E+00   3.06486249429467E-11   0.00000000000000E+00   3.06486249429467E-11
      5.19422398627807E-18  -2.85224242044659E-01  -2.85195942772754E-01   0.00000000000000E+00  -4.79118623483444E-13
     -1.20363825590885E-22  -8.93482236081938E-11  -8.98273422317976E-11  -3.88216468404813E-18
      9.84079104328085E-07
      0.00000000000000E+00  -6.71385028987021E-14   0.00000000000000E+00   3.28576792327110E-16  -2.19012813407868E-23
      6.71100612985437E-11   6.71103898753141E-11  -1.30894055367258E-18  -7.66607972866638E-03  -7.66607972869425E-03
      0.00000000000000E+00   0.00000000000000E+00   2.78798014317467E-11   0.00000000000000E+00   2.78798014317467E-11
      5.24998358914156E-18  -3.10515808337351E-01  -3.10485882826275E-01   0.00000000000000E+00  -4.96140986426632E-13
     -1.22755910506630E-22  -9.44940503205115E-11  -9.49901913070609E-11  -3.94104303546898E-18
      9.86079104328085E-07
      0.00000000000000E+00  -7.46697713497193E-14   0.00000000000000E+00   2.95429896694122E-16  -9.23799002862506E-24
      7.46446726117233E-11   7.46449680416108E-11  -1.30595890602605E-18  -7.54330968170368E-03  -7.54330968172943E-03
      0.00000000000000E+00   0.00000000000000E+00   2.57539670972013E-11   0.00000000000000E+00   2.57539670972013E-11
      5.30149152333596E-18  -3.35275660029295E-01  -3.35244030847073E-01   0.00000000000000E+00  -5.13981208555246E-13
     -1.25175032196542E-22  -9.98849539301320E-11  -1.00398935138812E-10  -3.99553261730991E-18
      9.88079104328085E-07
      0.00000000000000E+00  -8.19255055891139E-14   0.00000000000000E+00   2.73064647849686E-16   6.23599470714038E-24
      8.19121965133187E-11   8.19124695779728E-11  -1.30315747408367E-18  -7.44338347130291E-03  -7.44338347132696E-03
      0.00000000000000E+00   0.00000000000000E+00   2.40455332756893E-11   0.00000000000000E+00   2.40455332756893E-11
      5.34958258988734E-18  -3.59509390545048E-01  -3.59476010370006E-01   0.00000000000000E+00  -5.33824499483419E-13
     -1.27628410569123E-22  -1.05424178354050E-10  -1.05958002853661E-10  -4.04642511580367E-18
      9.90079104328085E-07
      0.00000000000000E+00  -8.90893950913009E-14   0.00000000000000E+00   2.62042979590132E-16   2.30405966578066E-23
      8.90832491458230E-11   8.90835111888256E-11  -1.30048814743427E-18  -7.38650010282174E-03  -7.38650010284428E-03
      0.00000000000000E+00   0.00000000000000E+00   2.25454421011032E-11   0.00000000000000E+00   2.25454421011032E-11
      5.39467347408955E-18  -3.83205939399433E-01  -3.83170773024597E-01   0.00000000000000E+00  -5.55217086013752E-13
     -1.30119457906653E-22  -1.11073736203785E-10  -1.11628953289929E-10  -4.09418532665528E-18
      9.92079104328084E-07
      0.00000000000000E+00  -9.61614398562805E-14   0.00000000000000E+00   2.51680091284655E-16   4.00230672661968E-23
      9.61433622128738E-11   9.61436138930051E-11  -1.29797562418960E-18  -7.34684600513156E-03  -7.34684600515290E-03
      0.00000000000000E+00   0.00000000000000E+00   2.13401677998888E-11   0.00000000000000E+00   2.13401677998888E-11
      5.43735380968932E-18  -4.06484580756156E-01  -4.06447570294480E-01   0.00000000000000E+00  -5.84222677493380E-13
     -1.32676075680632E-22  -1.16899559015268E-10  -1.17483781692894E-10  -4.13937818549973E-18
      9.94079104328084E-07
      0.00000000000000E+00  -1.03141639884053E-13   0.00000000000000E+00   2.44112526882297E-16   5.62691967764546E-23
      1.03139638200657E-10   1.03139882313240E-10  -1.29561063562155E-18  -7.31760634119558E-03  -7.31760634121588E-03
      0.00000000000000E+00   0.00000000000000E+00   2.02999332329793E-11   0.00000000000000E+00   2.02999332329793E-11
      5.47795367615529E-18  -4.29410232507644E-01  -4.29371346124922E-01   0.00000000000000E+00  -6.19254337487306E-13
     -1.35314279750487E-22  -1.22820561208598E-10  -1.23439815546220E-10  -4.18234304053374E-18
      9.94329104328084E-07
      0.00000000000000E+00  -1.04060087256128E-13   0.00000000000000E+00   2.45676794288212E-16   5.84003923365059E-23
      1.04027526076293E-10   1.04027771753146E-10  -1.29531782169146E-18  -7.31411848843826E-03  -7.31411848845838E-03
      0.00000000000000E+00   0.00000000000000E+00   2.01114039997303E-11   0.00000000000000E+00   2.01114039997303E-11
      5.48298152715521E-18  -4.32269954349104E-01  -4.32230847693086E-01   0.00000000000000E+00  -6.38395160254301E-13
     -1.35648246874894E-22  -1.23500780592489E-10  -1.24139175752879E-10  -4.18766370546376E-18
      9.94666604328084E-07
      0.00000000000000E+00  -1.05254068839826E-13   0.00000000000000E+00   2.44424050139230E-16   6.12505135635950E-23
      1.05224192797093E-10   1.05224437221204E-10  -1.29492680266321E-18  -7.30970728735810E-03  -7.30970728737803E-03
      0.00000000000000E+00   0.00000000000000E+00   1.99267102990567E-11   0.00000000000000E+00   1.99267102990567E-11
      5.48970679188115E-18  -4.36119368333790E-01  -4.36079942952300E-01   0.00000000000000E+00  -6.44219919929263E-13
     -1.36101755764856E-22  -1.24506927600192E-10  -1.25151147520258E-10  -4.19477998921794E-18
      9.95122229328084E-07
      0.00000000000000E+00  -1.06815429372354E-13   0.00000000000000E+00   2.42371072223211E-16   6.49878374846313E-23
      1.06832056617142E-10   1.06832298988279E-10  -1.29440655863207E-18  -7.30429882861729E-03  -7.30429882863697E-03
      0.00000000000000E+00   0.00000000000000E+00   1.96782717775003E-11   0.00000000000000E+00   1.96782717775003E-11
      5.49867270445977E-18  -4.41294074669594E-01  -4.41254221134267E-01   0.00000000000000E+00  -6.52138035756251E-13
     -1.36717943085267E-22  -1.25858432729891E-10  -1.26510570765784E-10  -4.20426614582770E-18
      9.95737323078084E-07
      0.00000000000000E+00  -1.09019703065334E-13   0.00000000000000E+00   2.39841441714611E-16   6.97993088467456E-23
      1.08989990993138E-10   1.08990230834649E-10  -1.29371752241864E-18  -7.29803630185177E-03  -7.29803630187112E-03
      0.00000000000000E+00   0.00000000000000E+00   1.93493157441920E-11   0.00000000000000E+00   1.93493157441920E-11
      5.51057434764080E-18  -4.48237938477176E-01  -4.48197508906674E-01   0.00000000000000E+00  -6.62708540500437E-13
     -1.37556232887140E-22  -1.27676838038203E-10  -1.28339546578841E-10  -4.21685682522216E-18
      9.96567699640584E-07
      0.00000000000000E+00  -1.11866889918768E-13   0.00000000000000E+00   2.36828656930053E-16   7.58560563423590E-23
      1.11882806193581E-10   1.11883043022314E-10  -1.29280983661198E-18  -7.29162216477745E-03  -7.29162216479637E-03
      0.00000000000000E+00   0.00000000000000E+00   1.89185903874891E-11   0.00000000000000E+00   1.89185903874891E-11
      5.52628390169411E-18  -4.57533871131388E-01  -4.57492666137237E-01   0.00000000000000E+00  -6.76939687181247E-13
     -1.38698639980996E-22  -1.30124693722484E-10  -1.30801633409804E-10  -4.23347406508213E-18
      9.97688707999959E-07
      0.00000000000000E+00  -1.15724368881484E-13   0.00000000000000E+00   2.33401440459653E-16   8.32477210994632E-23
      1.15756826275060E-10   1.15757059676584E-10  -1.29162112502430E-18  -7.28713434462319E-03  -7.28713434464155E-03
      0.00000000000000E+00   0.00000000000000E+00   1.83598264931897E-11   0.00000000000000E+00   1.83598264931897E-11
      5.54686542066965E-18  -4.69940131034718E-01  -4.69897881933341E-01   0.00000000000000E+00  -6.96322334762672E-13
     -1.40258524463325E-22  -1.33420563834870E-10  -1.34116886169773E-10  -4.25524429564535E-18
      9.99202069285116E-07
      0.00000000000000E+00  -1.20959518902313E-13   0.00000000000000E+00   2.29812454883987E-16   9.18871011347859E-23
      1.20943195605155E-10   1.20943425417702E-10  -1.29007228028352E-18  -7.29019503687038E-03  -7.29019503688802E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76403445084884E-11   0.00000000000000E+00   1.76403445084884E-11
      5.57356163510561E-18  -4.86430001274116E-01  -4.86386345402458E-01   0.00000000000000E+00  -7.22866515676462E-13
     -1.42391754424009E-22  -1.37860903410369E-10  -1.38583769926188E-10  -4.28348935482209E-18
      1.00000000000000E-06
      0.00000000000000E+00  -1.23714861018539E-13   0.00000000000000E+00   2.29319844558331E-16   9.61250490762420E-23
      1.23687953573574E-10   1.23688182893514E-10  -1.28927034434540E-18  -7.29477595915954E-03  -7.29477595917678E-03
      0.00000000000000E+00   0.00000000000000E+00   1.72344572364637E-11   0.00000000000000E+00   1.72344572364637E-11
      5.58731353788895E-18  -4.95052141827765E-01  -4.95007749379762E-01   0.00000000000000E+00  -7.45615874099603E-13
     -1.43525008461708E-22  -1.40177024255738E-10  -1.40922640129981E-10  -4.29804319354355E-18
}
